package org.cthul.matchers.fluent8;

public interface ObjectFluent<Value extends java.lang.Object,BaseFluent,TheFluent extends BaseFluent,This extends ObjectFluent<Value,BaseFluent,TheFluent,This>> extends org.cthul.matchers.fluent.ext.ExtensibleFluentStep<Value, BaseFluent, TheFluent, This> {

    /**
     * Creates a matcher that matches if examined object is <code>null</code>.
     * <p>
     * For example:
     * <pre>assertThat(cheese, is(nullValue())</pre>
     *
     * @see org.hamcrest.core.IsNull#nullValue()
     * @return fluent
     */
    default TheFluent nullValue() {
        return __(org.hamcrest.core.IsNull.nullValue());
    }

    /**
     * A shortcut to the frequently used <code>not(nullValue())</code>.
     * <p>
     * For example:
     * <pre>assertThat(cheese, is(notNullValue()))</pre>
     * instead of:
     * <pre>assertThat(cheese, is(not(nullValue())))</pre>
     *
     * @see org.hamcrest.core.IsNull#notNullValue()
     * @return fluent
     */
    default TheFluent notNullValue() {
        return __(org.hamcrest.core.IsNull.notNullValue());
    }

    /**
     * Creates a matcher that matches only when the examined object is the same instance as
     * the specified target object.
     *
     * @param target
    the target instance against which others should be assessed
     * @see org.hamcrest.core.IsSame#sameInstance(java.lang.Object)
     * @return fluent
     */
    default TheFluent sameInstance(Value target) {
        return __(org.hamcrest.core.IsSame.sameInstance(target));
    }

    /**
     * Creates a matcher that matches only when the examined object is the same instance as
     * the specified target object.
     *
     * @param target
    the target instance against which others should be assessed
     * @see org.hamcrest.core.IsSame#theInstance(java.lang.Object)
     * @return fluent
     */
    default TheFluent theInstance(Value target) {
        return __(org.hamcrest.core.IsSame.theInstance(target));
    }

    /**
     * Creates a matcher that matches when the examined object is found within the
     * specified collection.
     * <p>
     * For example:
     * <pre>assertThat("foo", isIn(Arrays.asList("bar", "foo")))</pre>
     *
     * @param collection
    the collection in which matching items must be found
     * @see org.hamcrest.collection.IsIn#isIn(java.util.Collection)
     * @return fluent
     */
    default TheFluent isIn(java.util.Collection<Value> collection) {
        return __(org.hamcrest.collection.IsIn.isIn(collection));
    }

    /**
     * Creates a matcher that matches when the examined object is found within the
     * specified array.
     * <p>
     * For example:
     * <pre>assertThat("foo", isIn(new String[]{"bar", "foo"}))</pre>
     *
     * @param elements
    the array in which matching items must be found
     * @see org.hamcrest.collection.IsIn#isIn(java.lang.Object[])
     * @return fluent
     */
    default TheFluent isIn(Value[] elements) {
        return __(org.hamcrest.collection.IsIn.isIn(elements));
    }

    /**
     * Creates a matcher that matches when the examined object is equal to one of the
     * specified elements.
     * <p>
     * For example:
     * <pre>assertThat("foo", isIn("bar", "foo"))</pre>
     *
     * @param elements
    the elements amongst which matching items will be found
     * @see org.hamcrest.collection.IsIn#isOneOf(java.lang.Object...)
     * @return fluent
     */
    default TheFluent isOneOf(Value... elements) {
        return __(org.hamcrest.collection.IsIn.isOneOf(elements));
    }

    /**
     * Creates a matcher that matches any examined object whose <code>toString</code> method
     * returns a value that satisfies the specified matcher.
     * <p>
     * For example:
     * <pre>assertThat(true, hasToString(equalTo("TRUE")))</pre>
     *
     * @param toStringMatcher
    the matcher used to verify the toString result
     * @see org.hamcrest.object.HasToString#hasToString(org.hamcrest.Matcher)
     * @return fluent
     */
    default TheFluent hasToString(org.hamcrest.Matcher<? super java.lang.String> toStringMatcher) {
        return __(org.hamcrest.object.HasToString.hasToString(toStringMatcher));
    }

    /**
     * Creates a matcher that matches any examined object whose <code>toString</code> method
     * returns a value equalTo the specified string.
     * <p>
     * For example:
     * <pre>assertThat(true, hasToString("TRUE"))</pre>
     *
     * @param expectedToString
    the expected toString result
     * @see org.hamcrest.object.HasToString#hasToString(java.lang.String)
     * @return fluent
     */
    default TheFluent hasToString(java.lang.String expectedToString) {
        return __(org.hamcrest.object.HasToString.hasToString(expectedToString));
    }

    /**
     * @see org.cthul.matchers.fluent.adapters.LambdaAdapter#get(java.lang.String,org.cthul.matchers.fluent.adapters.Getter)
     * @return object fluent step step
     */
    default <Property> ObjectFluent.Step<Property,TheFluent,?> get(java.lang.String name, org.cthul.matchers.fluent.adapters.Getter<Value,Property> getter) {
        return as(org.cthul.matchers.fluent.ext.Extensions.uncheckedFactory(org.cthul.matchers.fluent.adapters.LambdaAdapter.get(name, getter), ObjectFluent.Step.Step.adapter()));
    }

    /**
     * @see org.cthul.matchers.fluent.adapters.LambdaAdapter#get(org.cthul.matchers.fluent.adapters.Getter)
     * @return object fluent step step
     */
    default <Property> ObjectFluent.Step<Property,TheFluent,?> get(org.cthul.matchers.fluent.adapters.Getter<Value,Property> getter) {
        return as(org.cthul.matchers.fluent.ext.Extensions.uncheckedFactory(org.cthul.matchers.fluent.adapters.LambdaAdapter.get(getter), ObjectFluent.Step.Step.adapter()));
    }

    @Override
    org.cthul.matchers.fluent8.ObjectFluent.OrChain<Value, TheFluent, ?> either();

    @Override
    org.cthul.matchers.fluent8.ObjectFluent.OrChain<Value, TheFluent, ?> either(org.hamcrest.Matcher<? super Value> matcher);

    @Override
    org.cthul.matchers.fluent8.ObjectFluent.AndChain<Value, TheFluent, ?> both();

    @Override
    org.cthul.matchers.fluent8.ObjectFluent.AndChain<Value, TheFluent, ?> both(org.hamcrest.Matcher<? super Value> matcher);

    @Override
    org.cthul.matchers.fluent8.ObjectFluent.AndChain<Value, TheFluent, ?> all();

    interface OrChain<Value extends java.lang.Object,TheFluent,This extends OrChain<Value,TheFluent,This>> extends org.cthul.matchers.fluent.ext.ExtensibleFluentStep.OrChain<Value, TheFluent, This>, org.cthul.matchers.fluent8.ObjectFluent<Value, org.cthul.matchers.fluent.Fluent<Value>, This, This> {

        @Override
        org.cthul.matchers.fluent8.ObjectFluent<Value, TheFluent, TheFluent, ?> or();

        @Override
        TheFluent or(org.hamcrest.Matcher<? super Value> matcher);

    }

    interface AndChain<Value extends java.lang.Object,TheFluent,This extends AndChain<Value,TheFluent,This>> extends org.cthul.matchers.fluent.ext.ExtensibleFluentStep.AndChain<Value, TheFluent, This>, org.cthul.matchers.fluent8.ObjectFluent<Value, org.cthul.matchers.fluent.Fluent<Value>, This, This> {

        @Override
        org.cthul.matchers.fluent8.ObjectFluent<Value, TheFluent, TheFluent, ?> and();

        @Override
        TheFluent and(org.hamcrest.Matcher<? super Value> matcher);

    }

    class Step<Value extends java.lang.Object,TheFluent,This extends Step<Value,TheFluent,This>> extends org.cthul.matchers.fluent.builder.FluentStepBuilder<Value, TheFluent, This> implements org.cthul.matchers.fluent8.ObjectFluent<Value, TheFluent, TheFluent, This> {

        private static final org.cthul.matchers.fluent.ext.ExtensionFactory X_ADAPTER = org.cthul.matchers.fluent.ext.Extensions.typecastFactory(java.lang.Object.class, Step::new, Assert::new);

        public Step(org.cthul.matchers.fluent.builder.Matchable<? extends Value, TheFluent> matchable) {
            super(matchable);
        }

        @Override
        public org.cthul.matchers.fluent8.ObjectFluent.OrChain<Value, TheFluent, ?> either() {
            return _either(org.cthul.matchers.fluent8.ObjectFluent.OrChain.class, Step.adapter());
        }

        @Override
        public org.cthul.matchers.fluent8.ObjectFluent.OrChain<Value, TheFluent, ?> either(org.hamcrest.Matcher<? super Value> matcher) {
            return either().__(matcher);
        }

        @Override
        public org.cthul.matchers.fluent8.ObjectFluent.AndChain<Value, TheFluent, ?> both() {
            return _both(org.cthul.matchers.fluent8.ObjectFluent.AndChain.class, Step.adapter());
        }

        @Override
        public org.cthul.matchers.fluent8.ObjectFluent.AndChain<Value, TheFluent, ?> both(org.hamcrest.Matcher<? super Value> matcher) {
            return both().__(matcher);
        }

        @Override
        public org.cthul.matchers.fluent8.ObjectFluent.AndChain<Value, TheFluent, ?> all() {
            return _all(org.cthul.matchers.fluent8.ObjectFluent.AndChain.class, Step.adapter());
        }

        /**
         * Converts this fluent into a ClassFluent.Step
         *
         * @return class fluent step step
         */
        public ClassFluent.Step<java.lang.Class<?>,TheFluent,?> asClass() {
            return as(ClassFluent.Step.adapter());
        }

        /**
         * Converts this fluent into a ComparableFluent.Step
         *
         * @return comparable fluent step step
         */
        public <C extends java.lang.Comparable<C>> ComparableFluent.Step<C,C,TheFluent,?> asComparable() {
            return as(ComparableFluent.Step.adapter());
        }

        /**
         * Converts this fluent into a IntegerFluent.Step
         *
         * @return integer fluent step step
         */
        public IntegerFluent.Step<java.lang.Integer,TheFluent,?> asInteger() {
            return as(IntegerFluent.Step.adapter());
        }

        /**
         * Converts this fluent into a ComparableFluent.Step
         *
         * @return comparable fluent step step
         */
        public ComparableFluent.Step<java.lang.Long,java.lang.Long,TheFluent,?> asLong() {
            return as(ComparableFluent.Step.adapter());
        }

        /**
         * Converts this fluent into a ComparableFluent.Step
         *
         * @return comparable fluent step step
         */
        public ComparableFluent.Step<java.lang.Float,java.lang.Float,TheFluent,?> asFloat() {
            return as(ComparableFluent.Step.adapter());
        }

        /**
         * Converts this fluent into a DoubleFluent.Step
         *
         * @return double fluent step step
         */
        public DoubleFluent.Step<java.lang.Double,TheFluent,?> asDouble() {
            return as(DoubleFluent.Step.adapter());
        }

        /**
         * Converts this fluent into a BigDecimalFluent.Step
         *
         * @return big decimal fluent step step
         */
        public BigDecimalFluent.Step<java.math.BigDecimal,TheFluent,?> asBigDecimal() {
            return as(BigDecimalFluent.Step.adapter());
        }

        /**
         * Converts this fluent into a IterableFluent.Step
         *
         * @return iterable fluent step step
         */
        public <T> IterableFluent.Step<T,java.lang.Iterable<T>,TheFluent,?> asIterable() {
            return as(IterableFluent.Step.adapter());
        }

        /**
         * Converts this fluent into a CollectionFluent.Step
         *
         * @return collection fluent step step
         */
        public <T> CollectionFluent.Step<T,java.util.Collection<T>,TheFluent,?> asCollection() {
            return as(CollectionFluent.Step.adapter());
        }

        /**
         * Converts this fluent into a CollectionFluent.Step
         *
         * @return collection fluent step step
         */
        public <K> CollectionFluent.Step<K,java.util.Set<K>,TheFluent,?> asSet() {
            return as(CollectionFluent.Step.adapter());
        }

        /**
         * Converts this fluent into a MapFluent.Step
         *
         * @return map fluent step step
         */
        public <K,V> MapFluent.Step<K,V,java.util.Map<K, V>,TheFluent,?> asMap() {
            return as(MapFluent.Step.adapter());
        }

        /**
         * Converts this fluent into a ExceptionFluent.Step
         *
         * @return exception fluent step step
         */
        public ExceptionFluent.Step<java.lang.Throwable,TheFluent,?> asException() {
            return as(ExceptionFluent.Step.adapter());
        }

        /**
         * Converts this fluent into a StringFluent.Step
         *
         * @return string fluent step step
         */
        public StringFluent.Step<java.lang.String,TheFluent,?> asString() {
            return as(StringFluent.Step.adapter());
        }

        public static <Value extends java.lang.Object,TheFluent> org.cthul.matchers.fluent.ext.ExtensionFactory<java.lang.Object, org.cthul.matchers.fluent8.ObjectFluent.Assert<Value>, TheFluent, org.cthul.matchers.fluent8.ObjectFluent.Step<Value, TheFluent, ?>> adapter() {
            return X_ADAPTER;
        }

    }

    class Assert<Value extends java.lang.Object> extends org.cthul.matchers.fluent.builder.FluentAssertBuilder<Value, Assert<Value>> implements org.cthul.matchers.fluent8.ObjectFluent<Value, org.cthul.matchers.fluent.Fluent<Value>, Assert<Value>, Assert<Value>> {

        public Assert(org.cthul.matchers.fluent.builder.FailureHandler handler,  org.cthul.matchers.fluent.value.MatchValue<Value> value) {
            super(handler, value);
        }

        protected Assert(org.cthul.matchers.fluent.builder.Matchable<? extends Value, ?> value) {
            super(value);
        }

        @Override
        public org.cthul.matchers.fluent8.ObjectFluent.OrChain<Value, Assert<Value>, ?> either() {
            return _either(org.cthul.matchers.fluent8.ObjectFluent.OrChain.class, Step.adapter());
        }

        @Override
        public org.cthul.matchers.fluent8.ObjectFluent.OrChain<Value, Assert<Value>, ?> either(org.hamcrest.Matcher<? super Value> matcher) {
            return either().__(matcher);
        }

        @Override
        public org.cthul.matchers.fluent8.ObjectFluent.AndChain<Value, Assert<Value>, ?> both() {
            return _both(org.cthul.matchers.fluent8.ObjectFluent.AndChain.class, Step.adapter());
        }

        @Override
        public org.cthul.matchers.fluent8.ObjectFluent.AndChain<Value, Assert<Value>, ?> both(org.hamcrest.Matcher<? super Value> matcher) {
            return both().__(matcher);
        }

        @Override
        public org.cthul.matchers.fluent8.ObjectFluent.AndChain<Value, Assert<Value>, ?> all() {
            return _all(org.cthul.matchers.fluent8.ObjectFluent.AndChain.class, Step.adapter());
        }

        /**
         * Converts this fluent into a ClassFluent.Step
         *
         * @return class fluent step fluent
         */
        public ClassFluent.Assert<java.lang.Class<?>> asClass() {
            return as(ClassFluent.Step.adapter());
        }

        /**
         * Converts this fluent into a ComparableFluent.Step
         *
         * @return comparable fluent step fluent
         */
        public <C extends java.lang.Comparable<C>> ComparableFluent.Assert<C,C> asComparable() {
            return as(ComparableFluent.Step.adapter());
        }

        /**
         * Converts this fluent into a IntegerFluent.Step
         *
         * @return integer fluent step fluent
         */
        public IntegerFluent.Assert<java.lang.Integer> asInteger() {
            return as(IntegerFluent.Step.adapter());
        }

        /**
         * Converts this fluent into a ComparableFluent.Step
         *
         * @return comparable fluent step fluent
         */
        public ComparableFluent.Assert<java.lang.Long,java.lang.Long> asLong() {
            return as(ComparableFluent.Step.adapter());
        }

        /**
         * Converts this fluent into a ComparableFluent.Step
         *
         * @return comparable fluent step fluent
         */
        public ComparableFluent.Assert<java.lang.Float,java.lang.Float> asFloat() {
            return as(ComparableFluent.Step.adapter());
        }

        /**
         * Converts this fluent into a DoubleFluent.Step
         *
         * @return double fluent step fluent
         */
        public DoubleFluent.Assert<java.lang.Double> asDouble() {
            return as(DoubleFluent.Step.adapter());
        }

        /**
         * Converts this fluent into a BigDecimalFluent.Step
         *
         * @return big decimal fluent step fluent
         */
        public BigDecimalFluent.Assert<java.math.BigDecimal> asBigDecimal() {
            return as(BigDecimalFluent.Step.adapter());
        }

        /**
         * Converts this fluent into a IterableFluent.Step
         *
         * @return iterable fluent step fluent
         */
        public <T> IterableFluent.Assert<T,java.lang.Iterable<T>> asIterable() {
            return as(IterableFluent.Step.adapter());
        }

        /**
         * Converts this fluent into a CollectionFluent.Step
         *
         * @return collection fluent step fluent
         */
        public <T> CollectionFluent.Assert<T,java.util.Collection<T>> asCollection() {
            return as(CollectionFluent.Step.adapter());
        }

        /**
         * Converts this fluent into a CollectionFluent.Step
         *
         * @return collection fluent step fluent
         */
        public <K> CollectionFluent.Assert<K,java.util.Set<K>> asSet() {
            return as(CollectionFluent.Step.adapter());
        }

        /**
         * Converts this fluent into a MapFluent.Step
         *
         * @return map fluent step fluent
         */
        public <K,V> MapFluent.Assert<K,V,java.util.Map<K, V>> asMap() {
            return as(MapFluent.Step.adapter());
        }

        /**
         * Converts this fluent into a ExceptionFluent.Step
         *
         * @return exception fluent step fluent
         */
        public ExceptionFluent.Assert<java.lang.Throwable> asException() {
            return as(ExceptionFluent.Step.adapter());
        }

        /**
         * Converts this fluent into a StringFluent.Step
         *
         * @return string fluent step fluent
         */
        public StringFluent.Assert<java.lang.String> asString() {
            return as(StringFluent.Step.adapter());
        }

    }

}
