package org.cthul.matchers.fluent8;

public interface ProcFluent<Value extends org.cthul.proc.Proc,BaseFluent,TheFluent extends BaseFluent,This extends ProcFluent<Value,BaseFluent,TheFluent,This>> extends org.cthul.matchers.fluent.ext.ExtensibleFluentStep<Value, BaseFluent, TheFluent, This>, ObjectFluent<Value, BaseFluent, TheFluent, This> {

    /**
     * Does the proc raise a throwable that satisfies the condition?
     *
     * @param throwableMatcher
     * @see org.cthul.matchers.proc.Raises#raises(org.hamcrest.Matcher)
     * @return fluent
     */
    default TheFluent raises(org.hamcrest.Matcher<? super java.lang.Throwable> throwableMatcher) {
        return __(org.cthul.matchers.proc.Raises.raises(throwableMatcher));
    }

    /**
     * Does the proc raise a throwable that satisfies the condition?
     *
     * @param clazz
     * @see org.cthul.matchers.proc.Raises#raises(java.lang.Class)
     * @return fluent
     */
    default TheFluent raises(java.lang.Class<? extends java.lang.Throwable> clazz) {
        return __(org.cthul.matchers.proc.Raises.raises(clazz));
    }

    /**
     * Does the proc raise a throwable that satisfies the condition?
     *
     * @param regex
     * @see org.cthul.matchers.proc.Raises#raises(java.lang.String)
     * @return fluent
     */
    default TheFluent raises(java.lang.String regex) {
        return __(org.cthul.matchers.proc.Raises.raises(regex));
    }

    /**
     * Does the proc raise a throwable that satisfies the condition?
     *
     * @param clazz
     * @param regex
     * @see org.cthul.matchers.proc.Raises#raises(java.lang.Class,java.lang.String)
     * @return fluent
     */
    default TheFluent raises(java.lang.Class<? extends java.lang.Throwable> clazz, java.lang.String regex) {
        return __(org.cthul.matchers.proc.Raises.raises(clazz, regex));
    }

    /**
     * Does the proc raise a throwable that satisfies the condition?
     *
     * @param clazz
     * @param matcher
     * @see org.cthul.matchers.proc.Raises#raises(java.lang.Class,org.hamcrest.Matcher)
     * @return fluent
     */
    default TheFluent raises(java.lang.Class<? extends java.lang.Throwable> clazz, org.hamcrest.Matcher<? super java.lang.Throwable> matcher) {
        return __(org.cthul.matchers.proc.Raises.raises(clazz, matcher));
    }

    /**
     * Does the proc throw an exception?
     *
     * @see org.cthul.matchers.proc.Raises#raisesException()
     * @return fluent
     */
    default TheFluent raisesException() {
        return __(org.cthul.matchers.proc.Raises.raisesException());
    }

    /**
     * Does the proc raise an exception that satisfies the condition?
     *
     * @param matcher
     * @see org.cthul.matchers.proc.Raises#raisesException(org.hamcrest.Matcher)
     * @return fluent
     */
    default TheFluent raisesException(org.hamcrest.Matcher<? super java.lang.Exception> matcher) {
        return __(org.cthul.matchers.proc.Raises.raisesException(matcher));
    }

    /**
     * Does the proc raise an exception that satisfies the condition?
     *
     * @param clazz
     * @see org.cthul.matchers.proc.Raises#raisesException(java.lang.Class)
     * @return fluent
     */
    default TheFluent raisesException(java.lang.Class<? extends java.lang.Exception> clazz) {
        return __(org.cthul.matchers.proc.Raises.raisesException(clazz));
    }

    /**
     * Does the proc raise an exception that satisfies the condition?
     *
     * @param regex
     * @see org.cthul.matchers.proc.Raises#raisesException(java.lang.String)
     * @return fluent
     */
    default TheFluent raisesException(java.lang.String regex) {
        return __(org.cthul.matchers.proc.Raises.raisesException(regex));
    }

    /**
     * Does the proc raise an exception that satisfies the condition?
     *
     * @param clazz
     * @param regex
     * @see org.cthul.matchers.proc.Raises#raisesException(java.lang.Class,java.lang.String)
     * @return fluent
     */
    default TheFluent raisesException(java.lang.Class<? extends java.lang.Exception> clazz, java.lang.String regex) {
        return __(org.cthul.matchers.proc.Raises.raisesException(clazz, regex));
    }

    /**
     * Does the proc return a value equal to {@code value}?
     *
     * @param value
     * @see org.cthul.matchers.proc.Returns#result(java.lang.Object)
     * @return fluent
     */
    default TheFluent result(java.lang.Object value) {
        return __(org.cthul.matchers.proc.Returns.result(value));
    }

    /**
     * Does the proc return a value that satisfies the condition?
     *
     * @param resultMatcher
     * @see org.cthul.matchers.proc.Returns#result(org.hamcrest.Matcher)
     * @return fluent
     */
    default TheFluent result(org.hamcrest.Matcher<?> resultMatcher) {
        return __(org.cthul.matchers.proc.Returns.result(resultMatcher));
    }

    /**
     * Does the proc complete without throwing an exception?
     *
     * @see org.cthul.matchers.proc.Returns#hasResult()
     * @return fluent
     */
    default TheFluent hasResult() {
        return __(org.cthul.matchers.proc.Returns.hasResult());
    }

    /**
     * Does the proc return a value equal to {@code value}?
     *
     * @param value
     * @see org.cthul.matchers.proc.Returns#returns(java.lang.Object)
     * @return fluent
     */
    default TheFluent returns(java.lang.Object value) {
        return __(org.cthul.matchers.proc.Returns.returns(value));
    }

    /**
     * Does the proc return a value that satisfies the condition?
     *
     * @param resultMatcher
     * @see org.cthul.matchers.proc.Returns#returns(org.hamcrest.Matcher)
     * @return fluent
     */
    default TheFluent returns(org.hamcrest.Matcher<?> resultMatcher) {
        return __(org.cthul.matchers.proc.Returns.returns(resultMatcher));
    }

    /**
     * Does the proc complete without throwing an exception?
     *
     * @see org.cthul.matchers.proc.Returns#returns()
     * @return fluent
     */
    default TheFluent returns() {
        return __(org.cthul.matchers.proc.Returns.returns());
    }

    @Override
    org.cthul.matchers.fluent8.ProcFluent.OrChain<Value, TheFluent, ?> either();

    @Override
    org.cthul.matchers.fluent8.ProcFluent.OrChain<Value, TheFluent, ?> either(org.hamcrest.Matcher<? super Value> matcher);

    @Override
    org.cthul.matchers.fluent8.ProcFluent.AndChain<Value, TheFluent, ?> both();

    @Override
    org.cthul.matchers.fluent8.ProcFluent.AndChain<Value, TheFluent, ?> both(org.hamcrest.Matcher<? super Value> matcher);

    @Override
    org.cthul.matchers.fluent8.ProcFluent.AndChain<Value, TheFluent, ?> all();

    interface OrChain<Value extends org.cthul.proc.Proc,TheFluent,This extends OrChain<Value,TheFluent,This>> extends org.cthul.matchers.fluent.ext.ExtensibleFluentStep.OrChain<Value, TheFluent, This>, org.cthul.matchers.fluent8.ProcFluent<Value, org.cthul.matchers.fluent.Fluent<Value>, This, This>, ObjectFluent.OrChain<Value, TheFluent, This> {

        @Override
        org.cthul.matchers.fluent8.ProcFluent<Value, TheFluent, TheFluent, ?> or();

        @Override
        TheFluent or(org.hamcrest.Matcher<? super Value> matcher);

    }

    interface AndChain<Value extends org.cthul.proc.Proc,TheFluent,This extends AndChain<Value,TheFluent,This>> extends org.cthul.matchers.fluent.ext.ExtensibleFluentStep.AndChain<Value, TheFluent, This>, org.cthul.matchers.fluent8.ProcFluent<Value, org.cthul.matchers.fluent.Fluent<Value>, This, This>, ObjectFluent.AndChain<Value, TheFluent, This> {

        @Override
        org.cthul.matchers.fluent8.ProcFluent<Value, TheFluent, TheFluent, ?> and();

        @Override
        TheFluent and(org.hamcrest.Matcher<? super Value> matcher);

    }

    class Step<Value extends org.cthul.proc.Proc,TheFluent,This extends Step<Value,TheFluent,This>> extends org.cthul.matchers.fluent.builder.FluentStepBuilder<Value, TheFluent, This> implements org.cthul.matchers.fluent8.ProcFluent<Value, TheFluent, TheFluent, This> {

        private static final org.cthul.matchers.fluent.ext.ExtensionFactory X_ADAPTER = org.cthul.matchers.fluent.ext.Extensions.typecastFactory(org.cthul.proc.Proc.class, Step::new, Assert::new);

        public Step(org.cthul.matchers.fluent.builder.Matchable<? extends Value, TheFluent> matchable) {
            super(matchable);
        }

        @Override
        public org.cthul.matchers.fluent8.ProcFluent.OrChain<Value, TheFluent, ?> either() {
            return _either(org.cthul.matchers.fluent8.ProcFluent.OrChain.class, Step.adapter());
        }

        @Override
        public org.cthul.matchers.fluent8.ProcFluent.OrChain<Value, TheFluent, ?> either(org.hamcrest.Matcher<? super Value> matcher) {
            return either().__(matcher);
        }

        @Override
        public org.cthul.matchers.fluent8.ProcFluent.AndChain<Value, TheFluent, ?> both() {
            return _both(org.cthul.matchers.fluent8.ProcFluent.AndChain.class, Step.adapter());
        }

        @Override
        public org.cthul.matchers.fluent8.ProcFluent.AndChain<Value, TheFluent, ?> both(org.hamcrest.Matcher<? super Value> matcher) {
            return both().__(matcher);
        }

        @Override
        public org.cthul.matchers.fluent8.ProcFluent.AndChain<Value, TheFluent, ?> all() {
            return _all(org.cthul.matchers.fluent8.ProcFluent.AndChain.class, Step.adapter());
        }

        public static <Value extends org.cthul.proc.Proc,TheFluent> org.cthul.matchers.fluent.ext.ExtensionFactory<java.lang.Object, org.cthul.matchers.fluent8.ProcFluent.Assert<Value>, TheFluent, org.cthul.matchers.fluent8.ProcFluent.Step<Value, TheFluent, ?>> adapter() {
            return X_ADAPTER;
        }

    }

    class Assert<Value extends org.cthul.proc.Proc> extends org.cthul.matchers.fluent.builder.FluentAssertBuilder<Value, Assert<Value>> implements org.cthul.matchers.fluent8.ProcFluent<Value, org.cthul.matchers.fluent.Fluent<Value>, Assert<Value>, Assert<Value>> {

        public Assert(org.cthul.matchers.fluent.builder.FailureHandler handler,  org.cthul.matchers.fluent.value.MatchValue<Value> value) {
            super(handler, value);
        }

        protected Assert(org.cthul.matchers.fluent.builder.Matchable<? extends Value, ?> value) {
            super(value);
        }

        @Override
        public org.cthul.matchers.fluent8.ProcFluent.OrChain<Value, Assert<Value>, ?> either() {
            return _either(org.cthul.matchers.fluent8.ProcFluent.OrChain.class, Step.adapter());
        }

        @Override
        public org.cthul.matchers.fluent8.ProcFluent.OrChain<Value, Assert<Value>, ?> either(org.hamcrest.Matcher<? super Value> matcher) {
            return either().__(matcher);
        }

        @Override
        public org.cthul.matchers.fluent8.ProcFluent.AndChain<Value, Assert<Value>, ?> both() {
            return _both(org.cthul.matchers.fluent8.ProcFluent.AndChain.class, Step.adapter());
        }

        @Override
        public org.cthul.matchers.fluent8.ProcFluent.AndChain<Value, Assert<Value>, ?> both(org.hamcrest.Matcher<? super Value> matcher) {
            return both().__(matcher);
        }

        @Override
        public org.cthul.matchers.fluent8.ProcFluent.AndChain<Value, Assert<Value>, ?> all() {
            return _all(org.cthul.matchers.fluent8.ProcFluent.AndChain.class, Step.adapter());
        }

    }

}
