package org.cthul.matchers.fluent8;

public interface StringFluent<Value extends java.lang.String,BaseFluent,TheFluent extends BaseFluent,This extends StringFluent<Value,BaseFluent,TheFluent,This>> extends org.cthul.matchers.fluent.ext.ExtensibleFluentStep<Value, BaseFluent, TheFluent, This>, ComparableFluent<java.lang.String,Value, BaseFluent, TheFluent, This> {

    /**
     * Can the given pattern be found in the string?
     *
     * @param regex
     * @see org.cthul.matchers.object.ContainsPattern#containsPattern(java.lang.String)
     * @return fluent
     */
    default TheFluent containsPattern(java.lang.String regex) {
        return __(org.cthul.matchers.object.ContainsPattern.containsPattern(regex));
    }

    /**
     * Can the given pattern be found in the string?
     *
     * @param p
     * @see org.cthul.matchers.object.ContainsPattern#containsPattern(java.util.regex.Pattern)
     * @return fluent
     */
    default TheFluent containsPattern(java.util.regex.Pattern p) {
        return __(org.cthul.matchers.object.ContainsPattern.containsPattern(p));
    }

    /**
     * Does the pattern match the entire string?
     *
     * @param regex
     * @see org.cthul.matchers.object.ContainsPattern#matchesPattern(java.lang.String)
     * @return fluent
     */
    default TheFluent matches(java.lang.String regex) {
        return __(org.cthul.matchers.object.ContainsPattern.matchesPattern(regex));
    }

    /**
     * Does the pattern match the entire string?
     *
     * @param p
     * @see org.cthul.matchers.object.ContainsPattern#matchesPattern(java.util.regex.Pattern)
     * @return fluent
     */
    default TheFluent matches(java.util.regex.Pattern p) {
        return __(org.cthul.matchers.object.ContainsPattern.matchesPattern(p));
    }

    /**
     * Creates a matcher that matches if the examined {@link String} contains the specified
     * {@link String} anywhere.
     * <p>
     * For example:
     * <pre>assertThat("myStringOfNote", containsString("ring"))</pre>
     *
     * @param substring
    the substring that the returned matcher will expect to find within any examined string
     * @see org.hamcrest.core.StringContains#containsString(java.lang.String)
     * @return fluent
     */
    default TheFluent contains(java.lang.String substring) {
        return __(org.hamcrest.core.StringContains.containsString(substring));
    }

    /**
     * Creates a matcher that matches if the examined {@link String} starts with the specified
     * {@link String}.
     * <p>
     * For example:
     * <pre>assertThat("myStringOfNote", startsWith("my"))</pre>
     *
     * @param prefix
     the substring that the returned matcher will expect at the start of any examined string
     * @see org.hamcrest.core.StringStartsWith#startsWith(java.lang.String)
     * @return fluent
     */
    default TheFluent startsWith(java.lang.String prefix) {
        return __(org.hamcrest.core.StringStartsWith.startsWith(prefix));
    }

    /**
     * Creates a matcher that matches if the examined {@link String} ends with the specified
     * {@link String}.
     * <p>
     * For example:
     * <pre>assertThat("myStringOfNote", endsWith("Note"))</pre>
     *
     * @param suffix
     the substring that the returned matcher will expect at the end of any examined string
     * @see org.hamcrest.core.StringEndsWith#endsWith(java.lang.String)
     * @return fluent
     */
    default TheFluent endsWith(java.lang.String suffix) {
        return __(org.hamcrest.core.StringEndsWith.endsWith(suffix));
    }

    /**
     * Creates a matcher of {@link String} that matches when the examined string is equal to
     * the specified expectedString, ignoring case.
     * <p>
     * For example:
     * <pre>assertThat("Foo", equalToIgnoringCase("FOO"))</pre>
     *
     * @param expectedString
    the expected value of matched strings
     * @see org.hamcrest.text.IsEqualIgnoringCase#equalToIgnoringCase(java.lang.String)
     * @return fluent
     */
    default TheFluent equalToIgnoringCase(java.lang.String expectedString) {
        return __(org.hamcrest.text.IsEqualIgnoringCase.equalToIgnoringCase(expectedString));
    }

    /**
     * Creates a matcher of {@link String} that matches when the examined string is equal to
     * the specified expectedString, when whitespace differences are (mostly) ignored.  To be
     * exact, the following whitespace rules are applied:
     * <ul>
     *   <li>all leading and trailing whitespace of both the expectedString and the examined string are ignored</li>
     *   <li>any remaining whitespace, appearing within either string, is collapsed to a single space before comparison</li>
     * </ul>
     * <p>
     * For example:
     * <pre>assertThat("   my\tfoo  bar ", equalToIgnoringWhiteSpace(" my  foo bar"))</pre>
     *
     * @param expectedString
    the expected value of matched strings
     * @see org.hamcrest.text.IsEqualIgnoringWhiteSpace#equalToIgnoringWhiteSpace(java.lang.String)
     * @return fluent
     */
    default TheFluent equalToIgnoringWhiteSpace(java.lang.String expectedString) {
        return __(org.hamcrest.text.IsEqualIgnoringWhiteSpace.equalToIgnoringWhiteSpace(expectedString));
    }

    /**
     * Creates a matcher of {@link String} that matches when the examined string has zero length.
     * <p>
     * For example:
     * <pre>assertThat("", isEmptyString())</pre>
     *
     * @see org.hamcrest.text.IsEmptyString#isEmptyString()
     * @return fluent
     */
    default TheFluent isEmpty() {
        return __(org.hamcrest.text.IsEmptyString.isEmptyString());
    }

    /**
     * Creates a matcher of {@link String} that matches when the examined string is <code>null</code>, or
     * has zero length.
     * <p>
     * For example:
     * <pre>assertThat(((String)null), isEmptyString())</pre>
     *
     * @see org.hamcrest.text.IsEmptyString#isEmptyOrNullString()
     * @return fluent
     */
    default TheFluent isEmptyOrNull() {
        return __(org.hamcrest.text.IsEmptyString.isEmptyOrNullString());
    }

    /**
     * Creates a matcher of {@link String} that matches when the examined string contains all of
     * the specified substrings, regardless of the order of their appearance.
     * <p>
     * For example:
     * <pre>assertThat("myfoobarbaz", stringContainsInOrder(Arrays.asList("bar", "foo")))</pre>
     *
     * @param substrings
    the substrings that must be contained within matching strings
     * @see org.hamcrest.text.StringContainsInOrder#stringContainsInOrder(java.lang.Iterable)
     * @return fluent
     */
    default TheFluent containsInOrder(java.lang.Iterable<java.lang.String> substrings) {
        return __(org.hamcrest.text.StringContainsInOrder.stringContainsInOrder(substrings));
    }

    @Override
    org.cthul.matchers.fluent8.StringFluent.OrChain<Value, TheFluent, ?> either();

    @Override
    org.cthul.matchers.fluent8.StringFluent.OrChain<Value, TheFluent, ?> either(org.hamcrest.Matcher<? super Value> matcher);

    @Override
    org.cthul.matchers.fluent8.StringFluent.AndChain<Value, TheFluent, ?> both();

    @Override
    org.cthul.matchers.fluent8.StringFluent.AndChain<Value, TheFluent, ?> both(org.hamcrest.Matcher<? super Value> matcher);

    @Override
    org.cthul.matchers.fluent8.StringFluent.AndChain<Value, TheFluent, ?> all();

    interface OrChain<Value extends java.lang.String,TheFluent,This extends OrChain<Value,TheFluent,This>> extends org.cthul.matchers.fluent.ext.ExtensibleFluentStep.OrChain<Value, TheFluent, This>, org.cthul.matchers.fluent8.StringFluent<Value, org.cthul.matchers.fluent.Fluent<Value>, This, This>, ComparableFluent.OrChain<java.lang.String,Value, TheFluent, This> {

        @Override
        org.cthul.matchers.fluent8.StringFluent<Value, TheFluent, TheFluent, ?> or();

        @Override
        TheFluent or(org.hamcrest.Matcher<? super Value> matcher);

    }

    interface AndChain<Value extends java.lang.String,TheFluent,This extends AndChain<Value,TheFluent,This>> extends org.cthul.matchers.fluent.ext.ExtensibleFluentStep.AndChain<Value, TheFluent, This>, org.cthul.matchers.fluent8.StringFluent<Value, org.cthul.matchers.fluent.Fluent<Value>, This, This>, ComparableFluent.AndChain<java.lang.String,Value, TheFluent, This> {

        @Override
        org.cthul.matchers.fluent8.StringFluent<Value, TheFluent, TheFluent, ?> and();

        @Override
        TheFluent and(org.hamcrest.Matcher<? super Value> matcher);

    }

    class Step<Value extends java.lang.String,TheFluent,This extends Step<Value,TheFluent,This>> extends org.cthul.matchers.fluent.builder.FluentStepBuilder<Value, TheFluent, This> implements org.cthul.matchers.fluent8.StringFluent<Value, TheFluent, TheFluent, This> {

        private static final org.cthul.matchers.fluent.ext.ExtensionFactory X_ADAPTER = org.cthul.matchers.fluent.ext.Extensions.typecastFactory(java.lang.String.class, Step::new, Assert::new);

        public Step(org.cthul.matchers.fluent.builder.Matchable<? extends Value, TheFluent> matchable) {
            super(matchable);
        }

        @Override
        public org.cthul.matchers.fluent8.StringFluent.OrChain<Value, TheFluent, ?> either() {
            return _either(org.cthul.matchers.fluent8.StringFluent.OrChain.class, Step.adapter());
        }

        @Override
        public org.cthul.matchers.fluent8.StringFluent.OrChain<Value, TheFluent, ?> either(org.hamcrest.Matcher<? super Value> matcher) {
            return either().__(matcher);
        }

        @Override
        public org.cthul.matchers.fluent8.StringFluent.AndChain<Value, TheFluent, ?> both() {
            return _both(org.cthul.matchers.fluent8.StringFluent.AndChain.class, Step.adapter());
        }

        @Override
        public org.cthul.matchers.fluent8.StringFluent.AndChain<Value, TheFluent, ?> both(org.hamcrest.Matcher<? super Value> matcher) {
            return both().__(matcher);
        }

        @Override
        public org.cthul.matchers.fluent8.StringFluent.AndChain<Value, TheFluent, ?> all() {
            return _all(org.cthul.matchers.fluent8.StringFluent.AndChain.class, Step.adapter());
        }

        public static <Value extends java.lang.String,TheFluent> org.cthul.matchers.fluent.ext.ExtensionFactory<java.lang.Object, org.cthul.matchers.fluent8.StringFluent.Assert<Value>, TheFluent, org.cthul.matchers.fluent8.StringFluent.Step<Value, TheFluent, ?>> adapter() {
            return X_ADAPTER;
        }

    }

    class Assert<Value extends java.lang.String> extends org.cthul.matchers.fluent.builder.FluentAssertBuilder<Value, Assert<Value>> implements org.cthul.matchers.fluent8.StringFluent<Value, org.cthul.matchers.fluent.Fluent<Value>, Assert<Value>, Assert<Value>> {

        public Assert(org.cthul.matchers.fluent.builder.FailureHandler handler,  org.cthul.matchers.fluent.value.MatchValue<Value> value) {
            super(handler, value);
        }

        protected Assert(org.cthul.matchers.fluent.builder.Matchable<? extends Value, ?> value) {
            super(value);
        }

        @Override
        public org.cthul.matchers.fluent8.StringFluent.OrChain<Value, Assert<Value>, ?> either() {
            return _either(org.cthul.matchers.fluent8.StringFluent.OrChain.class, Step.adapter());
        }

        @Override
        public org.cthul.matchers.fluent8.StringFluent.OrChain<Value, Assert<Value>, ?> either(org.hamcrest.Matcher<? super Value> matcher) {
            return either().__(matcher);
        }

        @Override
        public org.cthul.matchers.fluent8.StringFluent.AndChain<Value, Assert<Value>, ?> both() {
            return _both(org.cthul.matchers.fluent8.StringFluent.AndChain.class, Step.adapter());
        }

        @Override
        public org.cthul.matchers.fluent8.StringFluent.AndChain<Value, Assert<Value>, ?> both(org.hamcrest.Matcher<? super Value> matcher) {
            return both().__(matcher);
        }

        @Override
        public org.cthul.matchers.fluent8.StringFluent.AndChain<Value, Assert<Value>, ?> all() {
            return _all(org.cthul.matchers.fluent8.StringFluent.AndChain.class, Step.adapter());
        }

    }

}
