/*
 * Decompiled with CFR 0.152.
 */
package org.cukesalad.db.support;

import com.fasterxml.jackson.databind.ObjectMapper;
import cucumber.api.java.After;
import cucumber.api.java.Before;
import java.io.IOException;
import java.io.InputStream;
import java.sql.DriverManager;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import org.cukesalad.db.support.DBSaladContext;
import org.cukesalad.db.support.DynamicSQLQuery;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DBSaladHook {
    static final Logger LOG = LoggerFactory.getLogger(DBSaladHook.class);

    public static void refresh() {
        DBSaladContext.tearDownFiles = new ArrayList<DynamicSQLQuery>();
        DBSaladContext.dbprops = new Properties();
        DBSaladContext.batchquery = null;
        DBSaladContext.dbconnection = null;
    }

    @Before
    public void beforeHook() {
        DBSaladHook.refresh();
        DBSaladHook.loadProperties();
        DBSaladHook.setupDBConnection();
    }

    public static void setupDBConnection() {
        try {
            Class.forName(DBSaladContext.dbprops.getProperty("db.driver.class"));
        }
        catch (ClassNotFoundException e) {
            LOG.error("Error loading db driver class", (Throwable)e);
        }
        LOG.info("DB Driver class Registered!");
        try {
            DBSaladContext.dbconnection = DriverManager.getConnection(DBSaladContext.dbprops.getProperty("db.url"), DBSaladContext.dbprops.getProperty("db.username"), DBSaladContext.dbprops.getProperty("db.password"));
        }
        catch (SQLException e) {
            LOG.error("DB Connection Failed! Check output console", (Throwable)e);
        }
    }

    @After
    public void afterHook() throws IOException, SQLException {
        DBSaladHook.tearDownDBTestData();
        DBSaladHook.closeDBConnection();
        DBSaladHook.refresh();
    }

    public static void tearDownDBTestData() throws IOException, SQLException {
        for (DynamicSQLQuery tearDownFile : DBSaladContext.tearDownFiles) {
            DBSaladHook.executeUpdate(tearDownFile);
        }
    }

    public static void executeUpdate(DynamicSQLQuery sqlQuery) throws IOException, SQLException {
        List<String> batchQueries = sqlQuery.getBatchQueryList();
        Statement stmt = null;
        try {
            stmt = DBSaladContext.dbconnection.createStatement();
            for (String eachQuery : batchQueries) {
                if (eachQuery.trim().isEmpty()) continue;
                stmt.addBatch(eachQuery);
            }
            int[] updateCounts = stmt.executeBatch();
            DBSaladContext.dbconnection.commit();
            System.out.println("the update counts for \n[" + sqlQuery.getSqlQuery() + "] are - \n" + new ObjectMapper().writeValueAsString((Object)updateCounts));
        }
        catch (SQLException e) {
            System.out.println("Failed to execute file - " + sqlQuery.getSqlFileName() + "! Check output console");
            e.printStackTrace();
            throw e;
        }
        finally {
            if (stmt != null) {
                try {
                    stmt.close();
                }
                catch (SQLException e) {
                    System.out.println("Failed to close statement while executing file - " + sqlQuery.getSqlFileName() + "! Check output console");
                    e.printStackTrace();
                    throw e;
                }
            }
        }
    }

    public static ResultSet executeQuery(DynamicSQLQuery sqlQuery) throws IOException, SQLException {
        List<String> batchQueries = sqlQuery.getBatchQueryList();
        Statement stmt = null;
        ResultSet resultSet = null;
        try {
            stmt = DBSaladContext.dbconnection.createStatement();
            for (String eachQuery : batchQueries) {
                if (eachQuery.trim().isEmpty()) continue;
                resultSet = stmt.executeQuery(eachQuery);
            }
            System.out.println("result set of the query \n[" + sqlQuery.getSqlQuery() + "] are - \n" + resultSet);
        }
        catch (SQLException e) {
            System.out.println("Failed to execute file - " + sqlQuery.getSqlFileName() + "! Check output console");
            e.printStackTrace();
            throw e;
        }
        finally {
            if (stmt != null) {
                try {
                    stmt.close();
                }
                catch (SQLException e) {
                    System.out.println("Failed to close statement while executing file - " + sqlQuery.getSqlFileName() + "! Check output console");
                    e.printStackTrace();
                    throw e;
                }
            }
        }
        return resultSet;
    }

    public static void closeDBConnection() {
        try {
            DBSaladContext.dbconnection.close();
        }
        catch (SQLException e) {
            System.out.println("Failed to close DB connection! Check output console");
            e.printStackTrace();
        }
    }

    public static void loadProperties() {
        try {
            LOG.debug("loading db salad Properties");
            ClassLoader loader = Thread.currentThread().getContextClassLoader();
            InputStream stream = loader.getResourceAsStream("dbsalad.properties");
            if (stream != null) {
                DBSaladContext.dbprops.load(stream);
            }
            if (DBSaladContext.dbenv != null && (stream = loader.getResourceAsStream("dbsalad.{env}.properties".replace("{env}", DBSaladContext.dbenv))) != null) {
                DBSaladContext.dbprops.load(stream);
            }
            DBSaladContext.dbprops.putAll((Map<?, ?>)System.getProperties());
            LOG.debug("db salad Properties successfully loaded");
        }
        catch (IOException ex) {
            LOG.error("Error loading db salad Properties", (Throwable)ex);
        }
    }
}

