/*
 * Decompiled with CFR 0.152.
 */
package org.cukesalad.rest.support;

import com.jayway.jsonpath.Configuration;
import com.jayway.jsonpath.Option;
import com.jayway.jsonpath.spi.json.JacksonJsonProvider;
import com.jayway.jsonpath.spi.json.JsonProvider;
import com.jayway.jsonpath.spi.mapper.JacksonMappingProvider;
import com.jayway.jsonpath.spi.mapper.MappingProvider;
import cucumber.api.java.After;
import cucumber.api.java.Before;
import java.io.IOException;
import java.io.InputStream;
import java.util.EnumSet;
import java.util.Map;
import java.util.Set;
import javax.xml.parsers.ParserConfigurationException;
import org.cukesalad.rest.support.RestContext;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class RestHook {
    static final Logger LOG = LoggerFactory.getLogger(RestHook.class);
    public static final int ORDER = 0;

    public static void refresh() throws ParserConfigurationException {
        LOG.debug("Refreshing restProperties");
        RestContext.refresh();
    }

    @Before(order=0)
    public void beforeHook() throws ParserConfigurationException {
        RestHook.refresh();
        RestHook.loadProperties();
        RestHook.setupJsonConfig();
    }

    @After
    public void afterHook() throws IOException, ParserConfigurationException {
        RestHook.refresh();
    }

    public static void setupJsonConfig() {
        Configuration.setDefaults((Configuration.Defaults)new Configuration.Defaults(){
            private final JsonProvider jsonProvider = new JacksonJsonProvider();
            private final MappingProvider mappingProvider = new JacksonMappingProvider();

            public JsonProvider jsonProvider() {
                return this.jsonProvider;
            }

            public MappingProvider mappingProvider() {
                return this.mappingProvider;
            }

            public Set<Option> options() {
                return EnumSet.noneOf(Option.class);
            }
        });
    }

    public static void loadProperties() {
        try {
            LOG.debug("loading rest salad Properties");
            ClassLoader loader = Thread.currentThread().getContextClassLoader();
            InputStream stream = loader.getResourceAsStream("restsalad.properties");
            if (stream != null) {
                RestContext.restProps.load(stream);
            }
            if (RestContext.env != null && (stream = loader.getResourceAsStream("restsalad.{env}.properties".replace("{env}", RestContext.env))) != null) {
                RestContext.restProps.load(stream);
            }
            RestContext.restProps.putAll((Map<?, ?>)System.getProperties());
            LOG.debug("rest salad Properties successfully loaded");
        }
        catch (IOException ex) {
            LOG.error("Error loading rest salad Properties", (Throwable)ex);
        }
    }
}

