/*
 * Decompiled with CFR 0.152.
 */
package org.cukesalad.rest.steps;

import com.jayway.jsonpath.JsonPath;
import com.jayway.jsonpath.Predicate;
import com.jayway.jsonpath.TypeRef;
import com.sun.jersey.api.client.Client;
import com.sun.jersey.api.client.ClientResponse;
import com.sun.jersey.api.client.WebResource;
import cucumber.api.DataTable;
import cucumber.api.java.en.Given;
import cucumber.api.java.en.Then;
import java.io.ByteArrayInputStream;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import javax.xml.xpath.XPathConstants;
import org.apache.commons.lang3.StringEscapeUtils;
import org.cukesalad.context.CukeSaladContext;
import org.cukesalad.rest.support.RestContext;
import org.hamcrest.Matcher;
import org.hamcrest.Matchers;
import org.junit.Assert;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class RestSalad {
    @Given(value="^I start building a request with \"([^\"]*)\" method and URL \"([^\"]*)\"$")
    public void i_start_building_a_request_with_method_and_URL(String method, String serviceUrl) throws Throwable {
        RestContext.method = method.toUpperCase();
        RestContext.webresource = Client.create().resource(serviceUrl);
    }

    @Given(value="^I add \"([^\"]*)\" equal to \"([^\"]*)\" as parameter to request$")
    public void i_add_equal_to_as_parameter_to_request(String key, String value) throws Throwable {
        RestContext.webresource = RestContext.webresource.queryParam(key, value);
    }

    @Given(value="^I add below values as parameters to the request:$")
    public void i_add_below_values_as_parameters_to_the_request(DataTable paramTable) throws Throwable {
        for (Map.Entry headerEntry : paramTable.asMap(String.class, String.class).entrySet()) {
            if (((String)headerEntry.getKey()).equals("paramName")) continue;
            RestContext.webresource = RestContext.webresource.queryParam((String)headerEntry.getKey(), (String)headerEntry.getValue());
        }
    }

    @Given(value="^I add post body to the request as:$")
    public void i_add_post_body_to_the_request_as(String postBody) throws Throwable {
        RestContext.postBody = postBody;
    }

    @Given(value="^I add the below values as headers to the request:$")
    public void i_add_the_below_values_as_headers_to_the_request(DataTable headerTable) throws Throwable {
        List headerMap = headerTable.asMaps(String.class, String.class);
        if (headerMap != null && headerMap.size() > 0) {
            if (RestContext.headerMapList != null) {
                RestContext.headerMapList.addAll(headerMap);
            } else {
                RestContext.headerMapList = headerMap;
            }
        }
    }

    @Given(value="^I retrieve the resource$")
    public void i_retrieve_the_resource() throws Throwable {
        System.out.println(RestContext.method + " - " + RestContext.webresource.getURI() + ", headers -" + RestContext.headerMapList);
        WebResource.Builder requestBuilder = RestContext.webresource.getRequestBuilder();
        for (Map<String, String> headerMap : RestContext.headerMapList) {
            requestBuilder = (WebResource.Builder)requestBuilder.header(headerMap.get("headerName"), (Object)headerMap.get("headerValue"));
        }
        RestContext.clientResponse = (ClientResponse)requestBuilder.method(RestContext.method, ClientResponse.class, (Object)RestContext.postBody);
        RestContext.restResponse = (String)RestContext.clientResponse.getEntity(String.class);
        RestContext.responseHeader = RestContext.clientResponse.getHeaders();
        RestContext.responseType = RestContext.clientResponse.getType().toString();
        if (RestContext.responseType != null && RestContext.responseType.equals("application/xml")) {
            RestContext.xmlResponseDocument = RestContext.docBuilder.parse(new ByteArrayInputStream(RestContext.restResponse.getBytes()));
        }
        RestContext.postBody = null;
        RestContext.headerMapList = new ArrayList<Map<String, String>>();
        System.out.println(RestContext.restResponse);
    }

    @Then(value="^the status code returned should be (\\d+)$")
    public void the_status_code_returned_should_be(int status) throws Throwable {
        System.out.println("RestContext.clientResponse = " + RestContext.clientResponse + " status = " + status);
        Assert.assertEquals((long)status, (long)RestContext.clientResponse.getStatus());
    }

    @Then(value="^The response should contain following headers:$")
    public void the_response_should_contain_following_headers(DataTable headerTable) {
        List headerNamesToMatch = headerTable.topCells();
        List headerValuesTableToMatch = headerTable.cells(1);
        for (List headerValues : headerValuesTableToMatch) {
            Assert.assertEquals(headerValues.get(1), ((List)RestContext.responseHeader.get(headerValues.get(0))).get(0));
        }
    }

    @Then(value="^I add response headers to \"([^\"]*)\" context$")
    public void I_add_response_headers_to_context(String contextName) {
        CukeSaladContext.addToContext((String)contextName, RestContext.responseHeader.getClass(), RestContext.responseHeader);
    }

    @Then(value="^The response should contain \"([^\"]*)\" with value \"([^\"]*)\"$")
    public void the_response_should_contain_with_value(String achvAttrPathToCheck, String valueExpected) throws Throwable {
        if (RestContext.responseType != null && RestContext.responseType.equals("application/xml")) {
            Node node = (Node)RestContext.xPath.compile(achvAttrPathToCheck).evaluate(RestContext.xmlResponseDocument, XPathConstants.NODE);
            Assert.assertEquals((Object)valueExpected, (Object)node.getTextContent());
        } else {
            List achvAttrValuesActual = (List)JsonPath.parse((String)RestContext.restResponse).read(achvAttrPathToCheck, (TypeRef)new TypeRef<List<String>>(){});
            for (String achvAttrValueActual : achvAttrValuesActual) {
                Assert.assertTrue((boolean)achvAttrValueActual.equals(valueExpected));
            }
        }
    }

    @Then(value="^The response should contain \"([^\"]*)\"$")
    public void the_response_should_contain(String achvAttrPathToCheck) throws Throwable {
        if (RestContext.responseType != null && RestContext.responseType.equals("application/xml")) {
            NodeList nodeList = (NodeList)RestContext.xPath.compile(achvAttrPathToCheck).evaluate(RestContext.xmlResponseDocument, XPathConstants.NODESET);
            Assert.assertTrue((nodeList.getLength() > 0 ? 1 : 0) != 0);
        } else {
            List achvAttrValuesActual = (List)JsonPath.parse((String)RestContext.restResponse).read(achvAttrPathToCheck, (TypeRef)new TypeRef<List<String>>(){});
            Assert.assertThat((Object)achvAttrValuesActual, (Matcher)Matchers.iterableWithSize((Matcher)Matchers.greaterThanOrEqualTo((Comparable)Integer.valueOf(1))));
        }
    }

    @Then(value="^The response should contain \"([^\"]*)\" with values:$")
    public void the_response_should_contain_with_values(String achvAttrPathToCheck, DataTable valueExpected) throws Throwable {
        List achvAttrValuesExpected = valueExpected.topCells();
        if (RestContext.responseType != null && RestContext.responseType.equals("application/xml")) {
            NodeList nodeList = (NodeList)RestContext.xPath.compile(achvAttrPathToCheck).evaluate(RestContext.xmlResponseDocument, XPathConstants.NODESET);
            ArrayList<String> actualValuesList = new ArrayList<String>();
            for (int i = 0; null != nodeList && i < nodeList.getLength(); ++i) {
                Node nod = nodeList.item(i);
                actualValuesList.add(nod.getTextContent());
            }
            Assert.assertThat(actualValuesList, (Matcher)Matchers.contains((Object[])achvAttrValuesExpected.toArray()));
        } else {
            List achvAttrValuesActual = (List)JsonPath.parse((String)RestContext.restResponse).read(achvAttrPathToCheck, new Predicate[0]);
            Assert.assertThat((Object)achvAttrValuesActual, (Matcher)Matchers.contains((Object[])achvAttrValuesExpected.toArray()));
        }
    }

    @Then(value="^The \"([^\"]*)\" array has element with below attributes:$")
    public void the_array_has_element_with_below_attributes(String attrPathToCheck, DataTable exptectedTable) throws Throwable {
        List attributesNamesToMatch = exptectedTable.topCells();
        List attributesValuesTableToMatch = exptectedTable.cells(1);
        for (List attributeValues : attributesValuesTableToMatch) {
            String attributeValue;
            int attrIndex;
            String attrPathFilterPredicate;
            if (RestContext.responseType != null && RestContext.responseType.equals("application/xml")) {
                attrPathFilterPredicate = attrPathToCheck + "[";
                for (String attributeNameToMatch : attributesNamesToMatch) {
                    attrIndex = attributesNamesToMatch.indexOf(attributeNameToMatch);
                    if (attrIndex != 0) {
                        attrPathFilterPredicate = attrPathFilterPredicate.concat(" and ");
                    }
                    attributeValue = StringEscapeUtils.escapeEcmaScript((String)((String)attributeValues.get(attrIndex)));
                    attrPathFilterPredicate = attrPathFilterPredicate.concat(attributeNameToMatch + "='" + attributeValue + "'");
                }
                attrPathFilterPredicate = attrPathFilterPredicate.concat("]");
                NodeList node = (NodeList)RestContext.xPath.compile(attrPathFilterPredicate).evaluate(RestContext.xmlResponseDocument, XPathConstants.NODESET);
                Assert.assertTrue((String)("No elements found for this crtieria- " + attrPathFilterPredicate), (node.getLength() > 0 ? 1 : 0) != 0);
                continue;
            }
            attrPathFilterPredicate = attrPathToCheck + "[?(";
            for (String attributeNameToMatch : attributesNamesToMatch) {
                attrIndex = attributesNamesToMatch.indexOf(attributeNameToMatch);
                if (attrIndex != 0) {
                    attrPathFilterPredicate = attrPathFilterPredicate.concat(" && ");
                }
                attributeValue = StringEscapeUtils.escapeEcmaScript((String)((String)attributeValues.get(attrIndex)));
                attrPathFilterPredicate = attrPathFilterPredicate.concat("@." + attributeNameToMatch + "=='" + attributeValue + "'");
            }
            attrPathFilterPredicate = attrPathFilterPredicate.concat(")]");
            Assert.assertThat((String)("No elements found for this crtieria- " + attrPathFilterPredicate), (Object)((List)JsonPath.parse((String)RestContext.restResponse).read(attrPathFilterPredicate, new Predicate[0])), (Matcher)Matchers.iterableWithSize((int)1));
        }
    }

    @Then(value="^The response should contain \"([^\"]*)\" as empty array$")
    public void the_response_should_contain_as_empty_array(String arrayPath) throws Throwable {
        if (RestContext.responseType != null && RestContext.responseType.equals("application/xml")) {
            Node node = (Node)RestContext.xPath.compile(arrayPath).evaluate(RestContext.xmlResponseDocument, XPathConstants.NODE);
            Assert.assertTrue((boolean)node.getTextContent().isEmpty());
        } else {
            List achvAttrValuesActual = (List)JsonPath.parse((String)RestContext.restResponse).read(arrayPath, (TypeRef)new TypeRef<List>(){});
            Assert.assertThat((Object)achvAttrValuesActual, (Matcher)Matchers.emptyIterable());
        }
    }

    @Then(value="^The response should contain \"([^\"]*)\" with (\\d+) elements$")
    public void the_response_should_contain_with_elements(String arrayPath, int arraySize) throws Throwable {
        if (RestContext.responseType != null && RestContext.responseType.equals("application/xml")) {
            NodeList nodeList = (NodeList)RestContext.xPath.compile(arrayPath).evaluate(RestContext.xmlResponseDocument, XPathConstants.NODESET);
            Assert.assertEquals((long)arraySize, (long)nodeList.getLength());
        } else {
            List achvAttrValuesActual = (List)JsonPath.parse((String)RestContext.restResponse).read(arrayPath, (TypeRef)new TypeRef<List>(){});
            Assert.assertThat((Object)achvAttrValuesActual, (Matcher)Matchers.iterableWithSize((int)arraySize));
        }
    }

    @Then(value="^The response is empty$")
    public void the_response_is_empty() throws Throwable {
        Assert.assertThat((Object)RestContext.restResponse, (Matcher)Matchers.isEmptyOrNullString());
    }
}

