/*
 * Decompiled with CFR 0.152.
 */
package org.cxbox.constgen;

import java.io.Writer;
import java.util.Set;
import javax.annotation.processing.AbstractProcessor;
import javax.annotation.processing.RoundEnvironment;
import javax.annotation.processing.SupportedAnnotationTypes;
import javax.lang.model.element.Element;
import javax.lang.model.element.TypeElement;
import javax.lang.model.type.DeclaredType;
import javax.lang.model.type.TypeKind;
import javax.lang.model.type.TypeMirror;
import javax.tools.Diagnostic;
import javax.tools.JavaFileObject;
import org.cxbox.constgen.CodeGenerator;
import org.cxbox.constgen.GeneratesDtoMetamodel;

@SupportedAnnotationTypes(value={"org.cxbox.constgen.GeneratesDtoMetamodel"})
public class ConstAnnotationProcessor
extends AbstractProcessor {
    private static final boolean ALLOW_OTHER_PROCESSORS_TO_CLAIM_ANNOTATIONS = false;

    @Override
    public boolean process(Set<? extends TypeElement> annotations, RoundEnvironment roundEnv) {
        this.processingEnv.getMessager().printMessage(Diagnostic.Kind.NOTE, "Running " + this.getClass().getSimpleName());
        if (roundEnv.processingOver() || annotations.isEmpty()) {
            return false;
        }
        if (roundEnv.getRootElements() == null || roundEnv.getRootElements().isEmpty()) {
            this.processingEnv.getMessager().printMessage(Diagnostic.Kind.NOTE, "No sources to process");
            return false;
        }
        for (TypeElement typeElement : annotations) {
            Set<? extends Element> elements = roundEnv.getElementsAnnotatedWith(typeElement);
            for (Element element : elements) {
                try {
                    TypeElement typeElement2 = (TypeElement)element;
                    CodeGenerator codeGen = new CodeGenerator(typeElement2, this.getSuperclass(typeElement2), this.processingEnv.getElementUtils());
                    JavaFileObject jfo = this.processingEnv.getFiler().createSourceFile(codeGen.getPackageName() + "." + codeGen.getClassName(), new Element[0]);
                    Writer writer = jfo.openWriter();
                    try {
                        codeGen.generate().writeTo((Appendable)writer);
                    }
                    finally {
                        if (writer == null) continue;
                        writer.close();
                    }
                }
                catch (Exception e) {
                    this.processingEnv.getMessager().printMessage(Diagnostic.Kind.ERROR, e.getMessage());
                }
            }
        }
        return false;
    }

    private Element getSuperclass(TypeElement typeElement) {
        Element superclassElement;
        TypeMirror superclass = typeElement.getSuperclass();
        if (superclass != null && superclass.getKind() == TypeKind.DECLARED && (superclassElement = ((DeclaredType)superclass).asElement()).getAnnotation(GeneratesDtoMetamodel.class) != null) {
            return superclassElement;
        }
        return null;
    }
}

