/*
 * Decompiled with CFR 0.152.
 */
package org.cxbox.constgen;

import java.io.Serializable;
import java.util.function.Function;
import lombok.NonNull;

public final class DtoField<D, T>
implements Serializable {
    private final String name;
    private final Function<D, T> getter;
    private final Class<T> valueClazz;

    public DtoField(@NonNull String name, @NonNull Function<D, T> getter, Class<?> valueClazz) {
        this.name = name;
        this.getter = getter;
        this.valueClazz = valueClazz;
    }

    @Deprecated(since="4.0.0-M12", forRemoval=true)
    public DtoField(@NonNull String name, Class<?> valueClazz) {
        this.name = name;
        this.getter = noDefaultGetter -> {
            throw new DefaultGetterNotFoundException(this.name);
        };
        this.valueClazz = valueClazz;
    }

    public T getValue(D dto) {
        return this.getter.apply(dto);
    }

    @NonNull
    public String getName() {
        return this.name;
    }

    @NonNull
    public Function<D, T> getGetter() {
        return this.getter;
    }

    public Class<T> getValueClazz() {
        return this.valueClazz;
    }

    private static class DefaultGetterNotFoundException
    extends RuntimeException {
        public DefaultGetterNotFoundException(String fieldName) {
            super("DTO hasn't default getter for field: " + fieldName);
        }
    }
}

