/*
 * Decompiled with CFR 0.152.
 */
package org.cxbox.constgen;

import com.squareup.javapoet.ClassName;
import com.squareup.javapoet.FieldSpec;
import com.squareup.javapoet.JavaFile;
import com.squareup.javapoet.ParameterizedTypeName;
import com.squareup.javapoet.TypeName;
import com.squareup.javapoet.TypeSpec;
import java.lang.invoke.LambdaMetafactory;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.function.Function;
import java.util.function.Predicate;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.lang.model.element.AnnotationMirror;
import javax.lang.model.element.Element;
import javax.lang.model.element.ElementKind;
import javax.lang.model.element.ExecutableElement;
import javax.lang.model.element.Modifier;
import javax.lang.model.element.Name;
import javax.lang.model.element.TypeElement;
import javax.lang.model.element.VariableElement;
import javax.lang.model.type.TypeMirror;
import javax.lang.model.util.Elements;
import org.cxbox.constgen.Constant;
import org.cxbox.constgen.DtoField;

class CodeGenerator {
    private final TypeElement typeElement;
    private final Element superclass;
    private final Elements elements;
    private final String packageName;
    private final String className;

    CodeGenerator(TypeElement typeElement, Element superclass, Elements elements) {
        this.typeElement = typeElement;
        this.superclass = superclass;
        this.elements = elements;
        this.packageName = elements.getPackageOf(typeElement).getQualifiedName().toString();
        this.className = String.valueOf(typeElement.getSimpleName()) + "_";
    }

    private static boolean isStatic(VariableElement el) {
        return el.getModifiers().contains((Object)Modifier.STATIC);
    }

    private static boolean isStatic(ExecutableElement el) {
        return el.getModifiers().contains((Object)Modifier.STATIC);
    }

    JavaFile generate() {
        TypeSpec.Builder classBuilder = TypeSpec.classBuilder((String)this.className);
        if (this.superclass != null) {
            classBuilder.superclass((TypeName)ClassName.get((String)this.elements.getPackageOf(this.superclass).getQualifiedName().toString(), (String)(String.valueOf(this.superclass.getSimpleName()) + "_"), (String[])new String[0]));
        }
        classBuilder.addModifiers(new Modifier[]{Modifier.PUBLIC});
        for (Constant constant : this.collectFields()) {
            ParameterizedTypeName parameterizedTypeName = ParameterizedTypeName.get((ClassName)ClassName.get(DtoField.class), (TypeName[])new TypeName[]{TypeName.get((TypeMirror)this.typeElement.asType()), constant.getType()});
            FieldSpec fieldSpec = FieldSpec.builder((TypeName)parameterizedTypeName, (String)constant.getName(), (Modifier[])new Modifier[0]).addModifiers(new Modifier[]{Modifier.PUBLIC, Modifier.FINAL, Modifier.STATIC}).initializer(constant.getInitializer(), new Object[]{constant.getName()}).build();
            classBuilder.addField(fieldSpec);
        }
        return JavaFile.builder((String)this.packageName, (TypeSpec)classBuilder.build()).build();
    }

    private List<Constant> collectFields() {
        ArrayList<Constant> fieldSpecs = new ArrayList<Constant>();
        ArrayList<VariableElement> fields = new ArrayList<VariableElement>();
        ArrayList<ExecutableElement> methods = new ArrayList<ExecutableElement>();
        for (Element element : this.typeElement.getEnclosedElements()) {
            ExecutableElement method;
            VariableElement varEl;
            if (element.getKind() == ElementKind.FIELD && !this.isTransient(varEl = (VariableElement)element) && !CodeGenerator.isStatic(varEl)) {
                fields.add(varEl);
            }
            if (element.getKind() != ElementKind.METHOD || CodeGenerator.isStatic(method = (ExecutableElement)element)) continue;
            methods.add(method);
        }
        fields.forEach(field -> fieldSpecs.add(new Constant(field.getSimpleName().toString(), TypeName.get((TypeMirror)field.asType()).box(), this.fieldInitializer((List<ExecutableElement>)methods, (VariableElement)field))));
        Collections.sort(fieldSpecs);
        return fieldSpecs;
    }

    /*
     * Unable to fully structure code
     */
    public String fieldInitializer(List<ExecutableElement> methods, VariableElement field) {
        getterName = this.getterName(field);
        if (this.hasFieldGetter(field) || this.hasClassGetter(this.typeElement)) ** GOTO lbl-1000
        if (methods.stream().filter((Predicate<ExecutableElement>)LambdaMetafactory.metafactory(null, null, null, (Ljava/lang/Object;)Z, lambda$fieldInitializer$1(java.lang.String javax.lang.model.element.ExecutableElement ), (Ljavax/lang/model/element/ExecutableElement;)Z)((String)getterName)).map((Function<ExecutableElement, ExecutableElement>)LambdaMetafactory.metafactory(null, null, null, (Ljava/lang/Object;)Ljava/lang/Object;, cast(java.lang.Object ), (Ljavax/lang/model/element/ExecutableElement;)Ljavax/lang/model/element/ExecutableElement;)(ExecutableElement.class)).filter((Predicate<ExecutableElement>)LambdaMetafactory.metafactory(null, null, null, (Ljava/lang/Object;)Z, lambda$fieldInitializer$2(javax.lang.model.element.ExecutableElement ), (Ljavax/lang/model/element/ExecutableElement;)Z)()).anyMatch((Predicate<ExecutableElement>)LambdaMetafactory.metafactory(null, null, null, (Ljava/lang/Object;)Z, lambda$fieldInitializer$3(javax.lang.model.element.VariableElement javax.lang.model.element.ExecutableElement ), (Ljavax/lang/model/element/ExecutableElement;)Z)((VariableElement)field))) lbl-1000:
        // 2 sources

        {
            v0 = true;
        } else {
            v0 = false;
        }
        getterExist = v0;
        box = TypeName.get((TypeMirror)field.asType()).box();
        if (box instanceof ClassName) {
            className = (ClassName)box;
            fqn = className.canonicalName();
        } else if (box instanceof ParameterizedTypeName) {
            parameterizedTypeName = (ParameterizedTypeName)box;
            fqn = parameterizedTypeName.rawType.canonicalName();
        } else {
            fqn = "null";
        }
        return StringSubstitutor.replace("new DtoField<>($S${getter}, ${clazz})", Map.of("getter", getterExist != false ? ", " + this.methodReference(getterName) : "", "clazz", fqn + ".class"));
    }

    private String methodReference(String getterName) {
        return StringSubstitutor.replace("${class}::${getter}", Map.of("class", TypeName.get((TypeMirror)this.typeElement.asType()), "getter", getterName));
    }

    private String getterName(Element field) {
        return StringSubstitutor.replace("${prefix}${name}", Map.of("prefix", field.asType().getKind().isPrimitive() && TypeName.BOOLEAN.equals((Object)TypeName.get((TypeMirror)field.asType())) ? "is" : "get", "name", StringUtils.capitalize(field.getSimpleName().toString())));
    }

    private boolean isTransient(VariableElement el) {
        for (AnnotationMirror annotationMirror : this.elements.getAllAnnotationMirrors(el)) {
            Name qualifiedName = ((TypeElement)annotationMirror.getAnnotationType().asElement()).getQualifiedName();
            if (!qualifiedName.contentEquals("org.cxbox.constgen.DtoMetamodelIgnore")) continue;
            return true;
        }
        return false;
    }

    private boolean hasFieldGetter(VariableElement field) {
        for (AnnotationMirror annotationMirror : this.elements.getAllAnnotationMirrors(field)) {
            Name qualifiedName = ((TypeElement)annotationMirror.getAnnotationType().asElement()).getQualifiedName();
            if (!qualifiedName.contentEquals("lombok.Getter")) continue;
            return true;
        }
        return false;
    }

    private boolean hasClassGetter(TypeElement clazz) {
        for (AnnotationMirror annotationMirror : this.elements.getAllAnnotationMirrors(clazz)) {
            Name qualifiedName = ((TypeElement)annotationMirror.getAnnotationType().asElement()).getQualifiedName();
            if (!qualifiedName.contentEquals("lombok.Getter")) continue;
            return true;
        }
        return false;
    }

    public String getPackageName() {
        return this.packageName;
    }

    public String getClassName() {
        return this.className;
    }

    private static /* synthetic */ boolean lambda$fieldInitializer$3(VariableElement field, ExecutableElement method) {
        return Objects.equals(TypeName.get((TypeMirror)method.getReturnType()), TypeName.get((TypeMirror)field.asType()));
    }

    private static /* synthetic */ boolean lambda$fieldInitializer$2(ExecutableElement method) {
        return method.getTypeParameters().isEmpty();
    }

    private static /* synthetic */ boolean lambda$fieldInitializer$1(String getterName, ExecutableElement method) {
        return Objects.equals(getterName, method.getSimpleName().toString());
    }

    public static final class StringSubstitutor {
        private StringSubstitutor() {
            throw new UnsupportedOperationException("This is a utility class and cannot be instantiated");
        }

        public static String replace(String template, Map<String, Object> parameters) {
            StringBuilder newTemplate = new StringBuilder(template);
            ArrayList<Object> valueList = new ArrayList<Object>();
            Matcher matcher = Pattern.compile("[$][{](\\w+)}").matcher(template);
            while (matcher.find()) {
                String key = matcher.group(1);
                String paramName = "${" + key + "}";
                int index = newTemplate.indexOf(paramName);
                if (index == -1) continue;
                newTemplate.replace(index, index + paramName.length(), "%s");
                valueList.add(parameters.get(key));
            }
            return String.format(newTemplate.toString(), valueList.toArray());
        }
    }

    public static final class StringUtils {
        private StringUtils() {
            throw new UnsupportedOperationException("This is a utility class and cannot be instantiated");
        }

        public static String capitalize(String str) {
            int codePoint;
            int newCodePoint;
            int strLen = StringUtils.length(str);
            if (strLen == 0) {
                return str;
            }
            int firstCodepoint = str.codePointAt(0);
            if (firstCodepoint == (newCodePoint = Character.toTitleCase(firstCodepoint))) {
                return str;
            }
            int[] newCodePoints = new int[strLen];
            int outOffset = 0;
            newCodePoints[outOffset++] = newCodePoint;
            for (int inOffset = Character.charCount(firstCodepoint); inOffset < strLen; inOffset += Character.charCount(codePoint)) {
                codePoint = str.codePointAt(inOffset);
                newCodePoints[outOffset++] = codePoint;
            }
            return new String(newCodePoints, 0, outOffset);
        }

        public static int length(CharSequence cs) {
            return cs == null ? 0 : cs.length();
        }
    }
}

