/*
 * Decompiled with CFR 0.152.
 */
package org.cxbox.core.autoconfigure.cache;

import com.google.common.collect.ImmutableList;
import java.beans.ConstructorProperties;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.concurrent.Callable;
import javax.validation.constraints.NotNull;
import lombok.Generated;
import org.cxbox.core.autoconfigure.AutoConfiguration;
import org.cxbox.core.config.cache.CacheManagerBasedCacheResolver;
import org.cxbox.core.config.cache.CxboxCaches;
import org.cxbox.core.config.cache.CxboxRequestAwareCacheHolder;
import org.cxbox.core.metahotreload.MetaHotReloadService;
import org.springframework.boot.autoconfigure.AutoConfigureAfter;
import org.springframework.boot.autoconfigure.cache.CacheAutoConfiguration;
import org.springframework.boot.autoconfigure.cache.CacheProperties;
import org.springframework.boot.autoconfigure.cache.CacheType;
import org.springframework.boot.autoconfigure.condition.ConditionalOnBean;
import org.springframework.boot.autoconfigure.condition.ConditionalOnClass;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.cache.Cache;
import org.springframework.cache.CacheManager;
import org.springframework.cache.concurrent.ConcurrentMapCache;
import org.springframework.cache.concurrent.ConcurrentMapCacheManager;
import org.springframework.cache.interceptor.CacheAspectSupport;
import org.springframework.cache.interceptor.CacheResolver;
import org.springframework.cache.support.CompositeCacheManager;
import org.springframework.cache.support.NoOpCache;
import org.springframework.cache.support.NoOpCacheManager;
import org.springframework.cache.support.SimpleCacheManager;
import org.springframework.context.ApplicationContext;
import org.springframework.context.annotation.Bean;
import org.springframework.web.context.annotation.RequestScope;
import org.springframework.web.context.request.RequestContextHolder;

@AutoConfiguration
@ConditionalOnClass(value={CacheManager.class})
@ConditionalOnMissingBean(name={"cxboxCacheResolver"})
@ConditionalOnBean(value={CacheAspectSupport.class})
@AutoConfigureAfter(value={CacheAutoConfiguration.class})
public class CxboxCacheAutoConfiguration {
    private final ApplicationContext applicationContext;
    private final CacheProperties cacheProperties;

    @Bean
    public CacheResolver cxboxCacheResolver(MetaHotReloadService metaHotReloadService) {
        metaHotReloadService.loadMeta();
        if (CacheType.NONE.equals((Object)this.cacheProperties.getType())) {
            return new CacheManagerBasedCacheResolver((CacheManager)new NoOpCacheManager());
        }
        CompositeCacheManager compositeCacheManager = new CompositeCacheManager();
        compositeCacheManager.setCacheManagers(this.buildCacheManagers());
        compositeCacheManager.setFallbackToNoOpCache(true);
        return new CacheManagerBasedCacheResolver((CacheManager)compositeCacheManager);
    }

    @Bean
    @RequestScope
    public CxboxRequestAwareCacheHolder requestCache() {
        return new CxboxRequestAwareCacheHolder((Cache)new ConcurrentMapCache("requestCache"));
    }

    protected List<CacheManager> buildCacheManagers() {
        ArrayList<CacheManager> result = new ArrayList<CacheManager>();
        result.add(this.buildUnExpirableCacheManager(CxboxCaches.getSimpleCacheNames().toArray(new String[0])));
        result.add(this.buildRequestAwareCacheManager(CxboxCaches.getRequestCacheName()));
        return result;
    }

    protected CacheManager buildUnExpirableCacheManager(String ... names) {
        return new ConcurrentMapCacheManager(names);
    }

    protected CacheManager buildRequestAwareCacheManager(String cacheName) {
        SimpleCacheManager simpleCacheManager = new SimpleCacheManager();
        simpleCacheManager.setCaches((Collection)ImmutableList.of((Object)new RequestAwareCacheDecorator(cacheName)));
        simpleCacheManager.initializeCaches();
        return simpleCacheManager;
    }

    @ConstructorProperties(value={"applicationContext", "cacheProperties"})
    @Generated
    public CxboxCacheAutoConfiguration(ApplicationContext applicationContext, CacheProperties cacheProperties) {
        this.applicationContext = applicationContext;
        this.cacheProperties = cacheProperties;
    }

    class RequestAwareCacheDecorator
    implements Cache {
        private final String name;
        private final NoOpCache noOpCache;

        RequestAwareCacheDecorator(String name) {
            this.name = name;
            this.noOpCache = new NoOpCache(name);
        }

        @NotNull
        public String getName() {
            return this.name;
        }

        @NotNull
        public Object getNativeCache() {
            return this.getDelegate().getNativeCache();
        }

        public Cache.ValueWrapper get(@NotNull Object key) {
            return this.getDelegate().get(key);
        }

        public <T> T get(@NotNull Object key, Class<T> type) {
            return (T)this.getDelegate().get(key, type);
        }

        public <T> T get(@NotNull Object key, @NotNull Callable<T> valueLoader) {
            return (T)this.getDelegate().get(key, valueLoader);
        }

        public void put(@NotNull Object key, Object value) {
            this.getDelegate().put(key, value);
        }

        public Cache.ValueWrapper putIfAbsent(@NotNull Object key, Object value) {
            return this.getDelegate().putIfAbsent(key, value);
        }

        public void evict(@NotNull Object key) {
            this.getDelegate().evict(key);
        }

        public void clear() {
            this.getDelegate().clear();
        }

        private Cache getDelegate() {
            if (RequestContextHolder.getRequestAttributes() == null) {
                return this.noOpCache;
            }
            return ((CxboxRequestAwareCacheHolder)CxboxCacheAutoConfiguration.this.applicationContext.getBean(this.name, CxboxRequestAwareCacheHolder.class)).getCache();
        }
    }
}

