/*
 * Decompiled with CFR 0.152.
 */
package org.cxbox.core.controller;

import java.beans.ConstructorProperties;
import java.time.ZoneId;
import java.util.ArrayList;
import java.util.Locale;
import java.util.Optional;
import java.util.TimeZone;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import lombok.Generated;
import org.cxbox.api.data.dictionary.LOV;
import org.cxbox.api.service.LocaleService;
import org.cxbox.api.service.session.CoreSessionService;
import org.cxbox.api.util.locale.LocaleSpecification;
import org.cxbox.api.util.tz.TimeZoneSpecification;
import org.cxbox.core.dto.LoggedUser;
import org.cxbox.core.dto.ResponseDTO;
import org.cxbox.core.util.ResponseBuilder;
import org.cxbox.core.util.session.LoginService;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.context.i18n.LocaleContext;
import org.springframework.context.i18n.SimpleTimeZoneAwareLocaleContext;
import org.springframework.context.i18n.TimeZoneAwareLocaleContext;
import org.springframework.util.StringUtils;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;
import org.springframework.web.servlet.LocaleContextResolver;
import org.springframework.web.servlet.LocaleResolver;

@RestController
@RequestMapping(value={"#{ (${cxbox.api.use-servlet-context-path} == true) ? '':  '${cxbox.api.path}'}"})
public class LoginController {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(LoginController.class);
    private final LocaleService localeService;
    private final LocaleResolver localeResolver;
    private final LoginService loginService;
    private final CoreSessionService coreSessionService;

    @RequestMapping(method={RequestMethod.GET}, value={"/login"})
    public LoggedUser get(HttpServletRequest request, HttpServletResponse response, @RequestParam(name="role", required=false) String role, TimeZoneSpecification timezone, LocaleSpecification locale) {
        this.resetLocaleContext(request, response, timezone, locale);
        return this.loginService.getLoggedUser(role);
    }

    @RequestMapping(method={RequestMethod.GET}, value={"/logout"})
    public ResponseDTO logout() {
        return ResponseBuilder.build(new ArrayList());
    }

    protected void resetLocaleContext(HttpServletRequest request, HttpServletResponse response, TimeZoneSpecification timezone, LocaleSpecification locale) {
        if (this.localeResolver instanceof LocaleContextResolver) {
            LocaleContextResolver localeContextResolver = (LocaleContextResolver)this.localeResolver;
            LocaleContext context = localeContextResolver.resolveLocaleContext(request);
            localeContextResolver.setLocaleContext(request, response, (LocaleContext)new SimpleTimeZoneAwareLocaleContext(this.getLocale(context, locale), this.getTimezone(context, timezone)));
        }
    }

    protected Locale getLocale(LocaleContext context, LocaleSpecification locale) {
        ArrayList candidates = new ArrayList();
        Optional.ofNullable(locale).map(LocaleSpecification::getLocale).map(LOV::getKey).map(StringUtils::parseLocaleString).ifPresent(candidates::add);
        Optional.ofNullable(this.coreSessionService.getLocale(null)).ifPresent(candidates::add);
        Optional.of(context.getLocale()).ifPresent(candidates::add);
        return candidates.stream().filter(l -> this.localeService.isLanguageSupported(l.getLanguage())).findFirst().orElseGet(() -> ((LocaleService)this.localeService).getDefaultLocale());
    }

    protected TimeZone getTimezone(LocaleContext context, TimeZoneSpecification timezone) {
        return Optional.ofNullable(timezone).map(TimeZoneSpecification::getTimeZone).map(LOV::getKey).map(ZoneId::of).map(TimeZone::getTimeZone).orElseGet(() -> this.coreSessionService.getTimeZone(this.getTimeZone(context)));
    }

    private TimeZone getTimeZone(LocaleContext context) {
        if (context instanceof TimeZoneAwareLocaleContext) {
            return ((TimeZoneAwareLocaleContext)context).getTimeZone();
        }
        return null;
    }

    @ConstructorProperties(value={"localeService", "localeResolver", "loginService", "coreSessionService"})
    @Generated
    public LoginController(LocaleService localeService, LocaleResolver localeResolver, LoginService loginService, CoreSessionService coreSessionService) {
        this.localeService = localeService;
        this.localeResolver = localeResolver;
        this.loginService = loginService;
        this.coreSessionService = coreSessionService;
    }
}

