/*
 * Decompiled with CFR 0.152.
 */
package org.cxbox.core.controller;

import java.util.Map;
import javax.servlet.http.HttpServletRequest;
import org.cxbox.core.controller.BCFactory;
import org.cxbox.core.controller.param.QueryParameters;
import org.cxbox.core.crudma.CrudmaActionHolder;
import org.cxbox.core.crudma.CrudmaActionType;
import org.cxbox.core.crudma.CrudmaGateway;
import org.cxbox.core.crudma.bc.BusinessComponent;
import org.cxbox.core.crudma.bc.impl.BcDescription;
import org.cxbox.core.dto.ResponseDTO;
import org.cxbox.core.exception.ClientException;
import org.cxbox.core.util.ResponseBuilder;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"#{ (${cxbox.api.use-servlet-context-path} == true) ? '':  '${cxbox.api.path}'}/custom-action/**"})
public class UniversalCustomActionController {
    @Autowired
    private CrudmaGateway crudmaGateway;
    @Autowired
    private BCFactory bcFactory;
    @Autowired
    private CrudmaActionHolder crudmaActionHolder;

    @RequestMapping(method={RequestMethod.POST})
    public ResponseDTO invoke(HttpServletRequest request, QueryParameters queryParameters, @RequestBody Map<String, Map<String, Object>> requestBody) {
        if (requestBody == null || requestBody.get("data") == null) {
            throw new ClientException("Request with wrong request body. Expected: {\"data\":{}}");
        }
        BusinessComponent bc = this.bcFactory.getBusinessComponent(request, queryParameters);
        String action = queryParameters.getParameter("_action");
        CrudmaActionHolder.CrudmaAction crudmaAction = this.crudmaActionHolder.of(CrudmaActionType.INVOKE).setBc(bc).setName(action).setDescription(String.format("\u0412\u044b\u043f\u043e\u043b\u043d\u0435\u043d\u0438\u0435 \u0434\u0435\u0439\u0441\u0442\u0432\u0438\u044f %s.%s, id: %s, parentId: %s", ((BcDescription)bc.getDescription()).getName(), action, bc.getId(), bc.getParentId())).getAction();
        return ResponseBuilder.build(this.crudmaGateway.invokeAction(crudmaAction, requestBody.get("data")));
    }
}

