/*
 * Decompiled with CFR 0.152.
 */
package org.cxbox.core.controller;

import java.beans.ConstructorProperties;
import java.util.Map;
import javax.servlet.http.HttpServletRequest;
import lombok.Generated;
import org.cxbox.api.util.i18n.InfoMessageSource;
import org.cxbox.core.controller.BCFactory;
import org.cxbox.core.controller.param.QueryParameters;
import org.cxbox.core.crudma.CrudmaActionHolder;
import org.cxbox.core.crudma.CrudmaActionType;
import org.cxbox.core.crudma.CrudmaGateway;
import org.cxbox.core.crudma.bc.BusinessComponent;
import org.cxbox.core.crudma.bc.impl.BcDescription;
import org.cxbox.core.dto.ResponseDTO;
import org.cxbox.core.exception.ClientException;
import org.cxbox.core.util.ResponseBuilder;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"#{ (${cxbox.api.use-servlet-context-path} == true) ? '':  '${cxbox.api.path}'}"})
public class UniversalRowMetaController {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(UniversalRowMetaController.class);
    private final CrudmaGateway crudmaGateway;
    private final BCFactory bcFactory;
    private final CrudmaActionHolder crudmaActionHolder;

    @RequestMapping(method={RequestMethod.GET, RequestMethod.POST}, value={"row-meta-new/**"})
    public ResponseDTO rowMetaNew(HttpServletRequest request, QueryParameters queryParameters) {
        String action = queryParameters.getParameter("_action");
        BusinessComponent bc = this.bcFactory.getBusinessComponent(request, queryParameters);
        CrudmaActionHolder.CrudmaAction crudmaAction = this.crudmaActionHolder.of(CrudmaActionType.CREATE).setBc(bc).setOriginalActionType(action).setDescription(InfoMessageSource.infoMessage((String)"info.record_create_request", (Object[])new Object[]{((BcDescription)bc.getDescription()).getName(), bc.getParentId()})).getAction();
        return ResponseBuilder.build(this.crudmaGateway.create(crudmaAction));
    }

    @RequestMapping(method={RequestMethod.GET}, value={"row-meta-empty/**"})
    public ResponseDTO rowMetaEmpty(HttpServletRequest request, QueryParameters queryParameters) {
        BusinessComponent bc = this.bcFactory.getBusinessComponent(request, queryParameters);
        CrudmaActionHolder.CrudmaAction crudmaAction = this.crudmaActionHolder.of(CrudmaActionType.META).setBc(bc).setDescription(InfoMessageSource.infoMessage((String)"info.row_meta_empty_request", (Object[])new Object[]{((BcDescription)bc.getDescription()).getName(), bc.getParentId()})).getAction();
        return ResponseBuilder.build(this.crudmaGateway.getMetaEmpty(crudmaAction));
    }

    @RequestMapping(method={RequestMethod.GET}, value={"row-meta/**"})
    public ResponseDTO rowMeta(HttpServletRequest request, QueryParameters queryParameters) {
        BusinessComponent bc = this.bcFactory.getBusinessComponent(request, queryParameters);
        CrudmaActionHolder.CrudmaAction crudmaAction = this.crudmaActionHolder.of(CrudmaActionType.META).setBc(bc).setDescription(InfoMessageSource.infoMessage((String)"info.row_meta_request", (Object[])new Object[]{((BcDescription)bc.getDescription()).getName(), bc.getId(), bc.getParentId()})).getAction();
        return ResponseBuilder.build(this.crudmaGateway.getMeta(crudmaAction));
    }

    @RequestMapping(method={RequestMethod.POST}, value={"row-meta/**"})
    public ResponseDTO onFieldUpdateMeta(HttpServletRequest request, QueryParameters queryParameters, @RequestBody Map<String, Object> requestBody) {
        if (requestBody == null || requestBody.get("data") == null || !(requestBody.get("data") instanceof Map)) {
            throw new ClientException("Request with wrong request body. Expected: {\"data\":{}}");
        }
        requestBody = (Map)requestBody.get("data");
        BusinessComponent bc = this.bcFactory.getBusinessComponent(request, queryParameters);
        CrudmaActionHolder.CrudmaAction crudmaAction = this.crudmaActionHolder.of(CrudmaActionType.PREVIEW).setBc(bc).setDescription(InfoMessageSource.infoMessage((String)"info.record_preview_request", (Object[])new Object[]{((BcDescription)bc.getDescription()).getName(), bc.getId(), bc.getParentId()})).getAction();
        return ResponseBuilder.build(this.crudmaGateway.preview(crudmaAction, requestBody));
    }

    @ConstructorProperties(value={"crudmaGateway", "bcFactory", "crudmaActionHolder"})
    @Generated
    public UniversalRowMetaController(CrudmaGateway crudmaGateway, BCFactory bcFactory, CrudmaActionHolder crudmaActionHolder) {
        this.crudmaGateway = crudmaGateway;
        this.bcFactory = bcFactory;
        this.crudmaActionHolder = crudmaActionHolder;
    }
}

