/*
 * Decompiled with CFR 0.152.
 */
package org.cxbox.core.controller;

import com.fasterxml.jackson.databind.ObjectMapper;
import java.beans.ConstructorProperties;
import lombok.Generated;
import org.cxbox.core.crudma.bc.BcRegistry;
import org.cxbox.core.dto.ResponseDTO;
import org.cxbox.core.service.UIService;
import org.cxbox.core.service.ViewService;
import org.cxbox.core.ui.BcUtils;
import org.cxbox.core.util.ResponseBuilder;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"#{ (${cxbox.api.use-servlet-context-path} == true) ? '':  '${cxbox.api.path}'}"})
public class ViewController {
    @Qualifier(value="cxboxObjectMapper")
    private final ObjectMapper mapper;
    private final ViewService views;
    private final BcUtils bcUtils;
    private final BcRegistry bcRegistry;
    private final UIService uiService;

    @RequestMapping(method={RequestMethod.GET}, value={"/screen/{name}/**", "/screen/{name}"})
    public ResponseDTO screen(@PathVariable String name) {
        return ResponseBuilder.build((Object)this.views.getScreen(name));
    }

    private void invalidateCache() {
        this.bcRegistry.refresh();
        this.bcUtils.invalidateFieldCache();
        this.uiService.invalidateCache();
    }

    @ConstructorProperties(value={"mapper", "views", "bcUtils", "bcRegistry", "uiService"})
    @Generated
    public ViewController(@Qualifier(value="cxboxObjectMapper") ObjectMapper mapper, ViewService views, BcUtils bcUtils, BcRegistry bcRegistry, UIService uiService) {
        this.mapper = mapper;
        this.views = views;
        this.bcUtils = bcUtils;
        this.bcRegistry = bcRegistry;
        this.uiService = uiService;
    }
}

