/*
 * Decompiled with CFR 0.152.
 */
package org.cxbox.core.controller.http;

import java.io.IOException;
import java.util.Collections;
import javax.servlet.FilterChain;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.lang3.StringUtils;
import org.springframework.http.HttpStatus;
import org.springframework.security.web.header.HeaderWriterFilter;
import org.springframework.security.web.util.UrlUtils;

public class StaticRedirectFilter
extends HeaderWriterFilter {
    public StaticRedirectFilter(String location) {
        this(location, true);
    }

    public StaticRedirectFilter(String location, boolean relative) {
        super(Collections.singletonList((req, res) -> StaticRedirectFilter.sendRedirect(req, res, location, relative)));
    }

    private static void sendRedirect(HttpServletRequest req, HttpServletResponse res, String location, boolean relative) {
        String redirect = StaticRedirectFilter.calculateRedirectUrl(req.getContextPath(), location, relative);
        res.setStatus(HttpStatus.FOUND.value());
        res.setHeader("Location", redirect);
    }

    public static String calculateRedirectUrl(String contextPath, String url, boolean relative) {
        String result = url;
        if (!UrlUtils.isAbsoluteUrl((String)result)) {
            if (StringUtils.isBlank((CharSequence)result)) {
                result = "/";
            }
            if (!result.startsWith("/")) {
                result = "/" + result;
            }
            if (relative) {
                result = contextPath + result;
            }
        }
        return result;
    }

    protected void doFilterInternal(HttpServletRequest request, HttpServletResponse response, FilterChain filterChain) throws ServletException, IOException {
        super.doFilterInternal(request, response, (req, res) -> {});
    }
}

