/*
 * Decompiled with CFR 0.152.
 */
package org.cxbox.core.controller.param;

import java.util.function.BiFunction;
import lombok.Generated;
import org.cxbox.core.controller.param.AbstractQueryParameter;
import org.cxbox.core.controller.param.ParameterBuilder;
import org.cxbox.core.controller.param.QueryParameter;
import org.cxbox.core.controller.param.SearchOperation;
import org.cxbox.core.util.TypeConverter;

public class BindParameter
extends AbstractQueryParameter {
    private final SearchOperation operation;
    private final String stringValue;
    private final String sqlParameter;

    public BindParameter(String name, SearchOperation operation, String stringValue) {
        super(name);
        this.operation = operation;
        this.sqlParameter = this.getSQLParameter(name, operation);
        this.stringValue = stringValue;
    }

    private String getSQLParameter(String name, SearchOperation operation) {
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append(this.getName());
        if (operation != null) {
            stringBuilder.append("_").append(operation.getOperationName());
        }
        return stringBuilder.toString();
    }

    @Override
    public <R> R apply(BiFunction<String, String, R> biFunction) {
        StringBuilder stringBuilder = new StringBuilder("_bind.");
        stringBuilder.append(this.getName());
        if (this.operation != null) {
            stringBuilder.append(".").append(this.operation.getOperationName());
        }
        return biFunction.apply(stringBuilder.toString(), this.stringValue);
    }

    public <T> T getValue(Class<T> clazz) {
        return TypeConverter.to(clazz, this.stringValue);
    }

    public String getBooleanValue() {
        return TypeConverter.toBoolean(this.stringValue) != false ? "Y" : "N";
    }

    public String getStringValuesAsString() {
        return String.join((CharSequence)",", QueryParameter.getListValue(this.stringValue, String.class));
    }

    @Generated
    public String toString() {
        return "BindParameter(operation=" + (Object)((Object)this.getOperation()) + ", stringValue=" + this.getStringValue() + ", sqlParameter=" + this.getSqlParameter() + ")";
    }

    @Generated
    public SearchOperation getOperation() {
        return this.operation;
    }

    @Generated
    public String getStringValue() {
        return this.stringValue;
    }

    @Generated
    public String getSqlParameter() {
        return this.sqlParameter;
    }

    public static class Builder
    implements ParameterBuilder<BindParameter> {
        private static final ParameterBuilder<BindParameter> INSTANCE = new Builder();

        public static ParameterBuilder<BindParameter> getInstance() {
            return INSTANCE;
        }

        @Override
        public Class<BindParameter> getParameterType() {
            return BindParameter.class;
        }

        @Override
        public boolean matches(String key, String value) {
            return key.startsWith("_bind.");
        }

        @Override
        public BindParameter buildParameter(String key, String value) {
            if (this.matches(key, value)) {
                String bind = key.replace("_bind.", "");
                String[] split = bind.split("\\.");
                SearchOperation operation = split.length == 1 ? null : SearchOperation.of(split[1]);
                return new BindParameter(split[0], operation, value);
            }
            return null;
        }
    }
}

