/*
 * Decompiled with CFR 0.152.
 */
package org.cxbox.core.controller.param;

import java.util.function.BiFunction;
import lombok.Generated;
import org.cxbox.core.controller.param.AbstractQueryParameter;
import org.cxbox.core.controller.param.ParameterBuilder;
import org.cxbox.core.controller.param.SortType;

public class SortParameter
extends AbstractQueryParameter {
    private final SortType type;
    private final Integer priority;

    public SortParameter(String name, SortType type, Integer priority) {
        super(name);
        this.type = type;
        this.priority = priority;
    }

    @Override
    public <R> R apply(BiFunction<String, String, R> biFunction) {
        return biFunction.apply(String.format("_sort.%d.%s", this.getPriority(), this.getType().name().toLowerCase()), this.getName());
    }

    @Generated
    public String toString() {
        return "SortParameter(type=" + (Object)((Object)this.getType()) + ", priority=" + this.getPriority() + ")";
    }

    @Generated
    public SortType getType() {
        return this.type;
    }

    @Generated
    public Integer getPriority() {
        return this.priority;
    }

    public static class Builder
    implements ParameterBuilder<SortParameter> {
        private static final ParameterBuilder<SortParameter> INSTANCE = new Builder();

        public static ParameterBuilder<SortParameter> getInstance() {
            return INSTANCE;
        }

        @Override
        public Class<SortParameter> getParameterType() {
            return SortParameter.class;
        }

        @Override
        public boolean matches(String key, String value) {
            return key.startsWith("_sort.");
        }

        @Override
        public SortParameter buildParameter(String key, String value) {
            if (this.matches(key, value)) {
                String field = key.replace("_sort.", "");
                String[] entryKey = field.split("\\.");
                SortType type = SortType.of(entryKey[1], SortType.ASC);
                Integer priority = Integer.valueOf(entryKey[0]);
                return new SortParameter(value, type, priority);
            }
            return null;
        }
    }
}

