/*
 * Decompiled with CFR 0.152.
 */
package org.cxbox.core.crudma.bc.impl;

import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.function.Function;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.cxbox.core.crudma.bc.BcDescriptionBuilder;
import org.cxbox.core.crudma.bc.BcIdentifier;
import org.cxbox.core.crudma.bc.BcOverrider;
import org.cxbox.core.crudma.bc.BcRegistry;
import org.cxbox.core.crudma.bc.BcSupplier;
import org.cxbox.core.crudma.bc.RefreshableBcSupplier;
import org.cxbox.core.crudma.bc.impl.BcDescription;
import org.cxbox.core.exception.ClientException;
import org.springframework.context.annotation.DependsOn;
import org.springframework.stereotype.Service;

@DependsOn(value={"deploymentTransactionSupport"})
@Service
public class BcRegistryImpl
implements BcRegistry {
    private final List<BcSupplier> bcSuppliers;
    private final List<BcOverrider> bcOverriders;
    private Map<String, BcDescription> bcDescriptionMap;

    public BcRegistryImpl(Optional<List<BcSupplier>> bcSuppliers, Optional<List<BcOverrider>> bcOverriders) {
        this.bcSuppliers = bcSuppliers.orElse(Collections.emptyList());
        this.bcOverriders = bcOverriders.orElse(Collections.emptyList());
        this.build();
    }

    @Override
    public void refresh() {
        this.bcSuppliers.stream().filter(RefreshableBcSupplier.class::isInstance).map(RefreshableBcSupplier.class::cast).forEach(RefreshableBcSupplier::refresh);
        this.build();
    }

    private void build() {
        HashMap<String, BcDescription> bcDescriptionMap = new HashMap<String, BcDescription>();
        for (BcSupplier bcSupplier : this.bcSuppliers) {
            for (String bcName : bcSupplier.getAllBcNames()) {
                bcDescriptionMap.put(bcName, bcSupplier.getBcDescription(bcName));
            }
        }
        for (BcOverrider bcOverrider : this.bcOverriders) {
            for (BcOverrider.BcOverride bcOverride : bcOverrider.getBcOverrides()) {
                this.overrideBc(bcDescriptionMap, bcOverride.getBcIdentifiers(), bcOverride.getServiceClass());
            }
        }
        this.bcDescriptionMap = Collections.unmodifiableMap(bcDescriptionMap);
    }

    @Override
    public <T> Stream<T> select(Predicate<BcDescription> predicate, Function<BcDescription, T> transformer) {
        return this.bcDescriptionMap.values().stream().filter(predicate).map(transformer);
    }

    @Override
    public Collection<String> getAllBcNames() {
        return this.bcDescriptionMap.keySet();
    }

    @Override
    public BcDescription getBcDescription(String bcName) {
        BcDescription bcDescription = this.bcDescriptionMap.get(bcName);
        if (bcDescription == null) {
            throw new ClientException(String.format("BC \u043d\u0435 \u043d\u0430\u0439\u0434\u0435\u043d [%s]", bcName));
        }
        return bcDescription;
    }

    @Override
    public String getUrlFromBc(String bcName) {
        if (bcName == null) {
            return null;
        }
        return this.getBcHierarchy(bcName).stream().map(BcDescription::getName).collect(Collectors.joining("/:id/"));
    }

    @Override
    public List<BcDescription> getBcHierarchy(String bcName) {
        ArrayList<BcDescription> reverseHierarchy = new ArrayList<BcDescription>();
        BcDescription bcDescription = this.getBcDescription(bcName);
        reverseHierarchy.add(bcDescription);
        while (bcDescription.getParentName() != null) {
            bcDescription = this.getBcDescription(bcDescription.getParentName());
            reverseHierarchy.add(bcDescription);
        }
        return Lists.reverse(reverseHierarchy);
    }

    private void overrideBc(Map<String, BcDescription> bcDescriptionMap, List<BcIdentifier> bcIdentifiers, Class<?> serviceClass) {
        for (BcIdentifier bcIdentifier : bcIdentifiers) {
            bcDescriptionMap.put(bcIdentifier.getName(), BcDescriptionBuilder.build(bcIdentifier.getName(), bcIdentifier.getParentName(), serviceClass, bcDescriptionMap.get(bcIdentifier.getName()).isRefresh()));
        }
    }
}

