/*
 * Decompiled with CFR 0.152.
 */
package org.cxbox.core.crudma.ext.impl;

import com.google.common.collect.Sets;
import java.beans.ConstructorProperties;
import java.util.Arrays;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import lombok.Generated;
import org.cxbox.api.data.dto.DataResponseDTO;
import org.cxbox.api.data.dto.DataResponseDTO_;
import org.cxbox.api.data.dto.rowmeta.ActionDTO;
import org.cxbox.api.data.dto.rowmeta.FieldDTO;
import org.cxbox.api.util.Invoker;
import org.cxbox.core.controller.BCFactory;
import org.cxbox.core.controller.param.QueryParameters;
import org.cxbox.core.crudma.CrudmaActionHolder;
import org.cxbox.core.crudma.CrudmaActionType;
import org.cxbox.core.crudma.InterimResult;
import org.cxbox.core.crudma.bc.BcRegistry;
import org.cxbox.core.crudma.bc.BusinessComponent;
import org.cxbox.core.crudma.bc.impl.InnerBcDescription;
import org.cxbox.core.crudma.ext.CrudmaGatewayInvokeExtensionProvider;
import org.cxbox.core.crudma.state.BcState;
import org.cxbox.core.crudma.state.BcStateAware;
import org.cxbox.core.dto.DrillDownType;
import org.cxbox.core.dto.rowmeta.ActionResultDTO;
import org.cxbox.core.dto.rowmeta.ActionType;
import org.cxbox.core.dto.rowmeta.ActionsDTO;
import org.cxbox.core.dto.rowmeta.MetaDTO;
import org.cxbox.core.dto.rowmeta.PostAction;
import org.cxbox.core.service.ResponseFactory;
import org.cxbox.core.service.ResponseService;
import org.cxbox.core.service.action.ActionAvailableChecker;
import org.cxbox.core.service.action.ActionDescriptionBuilder;
import org.springframework.core.annotation.Order;
import org.springframework.stereotype.Component;

@Component
@Order(value=100)
public class BcStateCrudmaGatewayInvokeExtensionProvider
implements CrudmaGatewayInvokeExtensionProvider {
    private final BcRegistry bcRegistry;
    private final BCFactory bcFactory;
    private final ResponseFactory respFactory;
    private final BcStateAware bcStateAware;

    @Override
    public <T> Invoker<T, RuntimeException> extendInvoker(CrudmaActionHolder.CrudmaAction crudmaAction, Invoker<T, RuntimeException> invoker, boolean readOnly) {
        return () -> {
            BusinessComponent bc = crudmaAction.getBc();
            CrudmaActionType action = crudmaAction.getActionType();
            if (Objects.equals((Object)crudmaAction.getActionType(), (Object)CrudmaActionType.INVOKE) && Objects.equals(ActionType.CANCEL_CREATE.getType(), crudmaAction.getName())) {
                this.bcStateAware.clear();
                Object description = bc.getDescription();
                if (description instanceof InnerBcDescription) {
                    return this.getResponseService(bc).onCancel(bc);
                }
                return new ActionResultDTO().setAction(PostAction.postDelete());
            }
            this.restoreBcState(bc, action);
            Object invokeResult = invoker.invoke();
            this.afterInvoke(crudmaAction, readOnly, bc, action, invokeResult);
            return invokeResult;
        };
    }

    private void afterInvoke(CrudmaActionHolder.CrudmaAction crudmaAction, boolean readOnly, BusinessComponent bc, CrudmaActionType action, Object invokeResult) {
        InterimResult result;
        if (action != null && !readOnly) {
            this.bcStateAware.clear();
        }
        if (Objects.equals((Object)crudmaAction.getActionType(), (Object)CrudmaActionType.CREATE) && readOnly) {
            result = BcStateCrudmaGatewayInvokeExtensionProvider.castToInterimResultOrElseThrow(invokeResult, crudmaAction.getActionType());
            result.setBc(this.getBcForState(bc.withId(result.getDto().getId()), result.getMeta().getPostActions()));
            BcState bcState = new BcState(null, false, Optional.ofNullable(crudmaAction.getOriginalActionType()).orElse(ActionType.CREATE.getType()));
            this.bcStateAware.set(result.getBc(), bcState);
            this.addActionCancel(bc, result.getMeta().getRow().getActions());
        }
        if (Objects.equals((Object)crudmaAction.getActionType(), (Object)CrudmaActionType.PREVIEW) && readOnly) {
            result = BcStateCrudmaGatewayInvokeExtensionProvider.castToInterimResultOrElseThrow(invokeResult, crudmaAction.getActionType());
            boolean isRecordPersisted = this.bcStateAware.isPersisted(bc);
            this.bcStateAware.clear();
            this.bcStateAware.set(result.getBc(), new BcState(result.getDto(), isRecordPersisted, Optional.ofNullable(result.getBc()).map(BusinessComponent::getParameters).map(par -> par.getParameter("_action")).orElse(ActionType.CREATE.getType())));
            if (!this.bcStateAware.isPersisted(bc)) {
                this.addActionCancel(bc, result.getMeta().getRow().getActions());
            }
        }
        if (!this.bcStateAware.isPersisted(bc)) {
            if (CrudmaActionType.META.equals((Object)crudmaAction.getActionType())) {
                MetaDTO meta = BcStateCrudmaGatewayInvokeExtensionProvider.castToMetaDTOOrElseThrow(invokeResult, crudmaAction.getActionType());
                this.addActionCancel(bc, meta.getRow().getActions());
                meta.getRow().getFields().get(DataResponseDTO_.vstamp.getName()).setCurrentValue((Object)-1L);
            } else if (CrudmaActionType.GET.equals((Object)crudmaAction.getActionType()) && (result = BcStateCrudmaGatewayInvokeExtensionProvider.castToDataResponseDTOOrElseThrow(invokeResult, crudmaAction.getActionType())) != null) {
                result.setVstamp(-1L);
            }
        } else {
            MetaDTO meta;
            FieldDTO vstampField;
            CrudmaActionType actionType = crudmaAction.getActionType();
            if (CrudmaActionType.META.equals((Object)actionType) && this.bcStateAware.getState(bc) != null && this.bcStateAware.getState(bc).getDto() != null && (vstampField = (meta = BcStateCrudmaGatewayInvokeExtensionProvider.castToMetaDTOOrElseThrow(invokeResult, crudmaAction.getActionType())).getRow().getFields().get(DataResponseDTO_.vstamp.getName())) != null && this.bcStateAware.getState(bc).getDto().getVstamp() < Long.parseLong(vstampField.getCurrentValue().toString())) {
                vstampField.setCurrentValue((Object)this.bcStateAware.getState(bc).getDto().getVstamp());
            }
        }
    }

    private static InterimResult castToInterimResultOrElseThrow(Object invokeResult, CrudmaActionType actionType) {
        if (invokeResult instanceof InterimResult) {
            return (InterimResult)invokeResult;
        }
        throw new IllegalArgumentException("invokeResult is expected to be InterimResult for CrudmaActionType = " + (Object)((Object)actionType));
    }

    private static DataResponseDTO castToDataResponseDTOOrElseThrow(Object invokeResult, CrudmaActionType actionType) {
        if (invokeResult instanceof DataResponseDTO) {
            return (DataResponseDTO)invokeResult;
        }
        throw new IllegalArgumentException("invokeResult is expected to be InterimResult for DataResponseDTO = " + (Object)((Object)actionType));
    }

    private static MetaDTO castToMetaDTOOrElseThrow(Object invokeResult, CrudmaActionType actionType) {
        if (invokeResult instanceof MetaDTO) {
            return (MetaDTO)invokeResult;
        }
        throw new IllegalArgumentException("invokeResult is expected to be InterimResult for CrudmaActionType = " + (Object)((Object)actionType));
    }

    private BusinessComponent getBcForState(BusinessComponent bc, List<PostAction> postActions) {
        for (PostAction postAction : postActions) {
            if (!"drillDown".equals(postAction.getAttribute("type")) || !DrillDownType.INNER.getValue().equals(postAction.getAttribute("drillDownType"))) continue;
            String[] url = postAction.getAttribute("url").split("/");
            if (!Objects.equals(bc.getId(), url[url.length - 1])) continue;
            return new BusinessComponent(bc.getId(), bc.getParentId(), this.bcRegistry.getBcDescription(url[url.length - 2]));
        }
        return bc;
    }

    private void restoreBcState(BusinessComponent currentBc, CrudmaActionType action) {
        for (BusinessComponent bc : Arrays.asList(this.getParentBcForRestore(currentBc), currentBc)) {
            BcState state;
            if (bc == null || (state = this.bcStateAware.getState(bc)) == null || !(bc.getDescription() instanceof InnerBcDescription)) continue;
            if (state.getPendingAction() != null) {
                QueryParameters originalParameters = bc.getParameters();
                originalParameters.setParameter("_action", state.getPendingAction());
                bc.setParameters(originalParameters);
            }
            ResponseService<?, ?> responseService = this.getResponseService(bc);
            if (!this.bcStateAware.isPersisted(bc)) {
                responseService.createEntity(bc);
            }
            if (state.getDto() == null || Sets.immutableEnumSet((Enum)CrudmaActionType.UPDATE, (Enum[])new CrudmaActionType[]{CrudmaActionType.PREVIEW, CrudmaActionType.INVOKE}).contains((Object)action)) continue;
            responseService.updateEntity(bc, state.getDto());
        }
    }

    private BusinessComponent getParentBcForRestore(BusinessComponent currentBc) {
        if (currentBc.getHierarchy() == null || currentBc.getHierarchy().getParent() == null) {
            return null;
        }
        return this.bcFactory.getBusinessComponent(currentBc.getHierarchy().getParent(), QueryParameters.onlyDatesQueryParameters(currentBc.getParameters()));
    }

    private ResponseService<?, ?> getResponseService(BusinessComponent bc) {
        return this.respFactory.getService((InnerBcDescription)bc.getDescription());
    }

    private void addActionCancel(BusinessComponent bc, ActionsDTO actions) {
        boolean hasCancelAction = false;
        for (ActionDTO action : actions) {
            if (ActionType.DELETE.isTypeOf(action) || ActionType.CREATE.isTypeOf(action)) {
                action.setAvailable(false);
            }
            if (!ActionType.CANCEL_CREATE.isTypeOf(action)) continue;
            action.setAvailable(true);
            hasCancelAction = true;
        }
        if (hasCancelAction) {
            return;
        }
        actions.addMethod(0, new ActionDescriptionBuilder().action(ActionType.CANCEL_CREATE).available(ActionAvailableChecker.ALWAYS_TRUE).withoutAutoSaveBefore().build(null), bc);
    }

    @ConstructorProperties(value={"bcRegistry", "bcFactory", "respFactory", "bcStateAware"})
    @Generated
    public BcStateCrudmaGatewayInvokeExtensionProvider(BcRegistry bcRegistry, BCFactory bcFactory, ResponseFactory respFactory, BcStateAware bcStateAware) {
        this.bcRegistry = bcRegistry;
        this.bcFactory = bcFactory;
        this.respFactory = respFactory;
        this.bcStateAware = bcStateAware;
    }
}

