/*
 * Decompiled with CFR 0.152.
 */
package org.cxbox.core.crudma.impl;

import java.io.Serializable;
import java.lang.reflect.Field;
import java.time.LocalDateTime;
import java.time.temporal.TemporalAdjuster;
import java.util.Collections;
import java.util.Optional;
import javax.persistence.criteria.Expression;
import javax.persistence.criteria.Order;
import javax.persistence.criteria.Predicate;
import org.apache.commons.beanutils.PropertyUtils;
import org.cxbox.api.data.ResultPage;
import org.cxbox.api.exception.ServerException;
import org.cxbox.api.util.i18n.ErrorMessageSource;
import org.cxbox.constgen.DtoField;
import org.cxbox.core.crudma.bc.BusinessComponent;
import org.cxbox.core.crudma.impl.VersionAwareResponseService;
import org.cxbox.core.dto.data.HistoricityDto;
import org.cxbox.core.dto.rowmeta.ActionResultDTO;
import org.cxbox.core.dto.rowmeta.ActionType;
import org.cxbox.core.dto.rowmeta.CreateResult;
import org.cxbox.core.dto.rowmeta.PostAction;
import org.cxbox.core.exception.VersionMismatchException;
import org.cxbox.core.service.HistoricityKey;
import org.cxbox.core.service.action.Actions;
import org.cxbox.core.service.rowmeta.HistoricityFieldMetaBuilder;
import org.cxbox.core.util.DateTimeUtil;
import org.cxbox.core.util.InstrumentationAwareReflectionUtils;
import org.cxbox.model.core.entity.AbstractEntity;
import org.cxbox.model.core.entity.HistoricityEntity;
import org.cxbox.model.core.entity.HistoricityEntity_;
import org.springframework.beans.BeanUtils;
import org.springframework.data.jpa.domain.Specification;

public abstract class HistoricityResponseService<T extends HistoricityDto, E extends HistoricityEntity>
extends VersionAwareResponseService<T, E> {
    private final Class<? extends HistoricityKey<E, T>> historicityKeyClass;

    public HistoricityResponseService(Class<T> typeOfDTO, Class<E> typeOfEntity, Class<? extends HistoricityKey<E, T>> historicityKeyClass, Class<? extends HistoricityFieldMetaBuilder<T>> metaBuilder) {
        super(typeOfDTO, typeOfEntity, null, metaBuilder);
        this.historicityKeyClass = historicityKeyClass;
    }

    private HistoricityKey<E, T> getHistoricityKey() {
        return (HistoricityKey)this.applicationContext.getBean(this.historicityKeyClass);
    }

    @Override
    public final ResultPage<T> getList(BusinessComponent bc) {
        ResultPage resultPage = super.getList(bc);
        if (resultPage.getResult().size() > 1) {
            throw new ServerException(ErrorMessageSource.errorMessage((String)"error.duplicate_key"));
        }
        return resultPage;
    }

    @Override
    protected final Specification<E> getParentSpecification(BusinessComponent bc) {
        return (Specification & Serializable)(root, query, cb) -> {
            LocalDateTime redDate = bc.getParameters().getDateTo().with(DateTimeUtil.asStartOfDay());
            return cb.and(new Predicate[]{this.getKeySpecification(bc).toPredicate(root, query, cb), cb.lessThanOrEqualTo((Expression)root.get(HistoricityEntity_.startDate), (Comparable)redDate), cb.or((Expression)root.get(HistoricityEntity_.endDate).isNull(), (Expression)cb.greaterThanOrEqualTo((Expression)root.get(HistoricityEntity_.endDate), (Comparable)redDate))});
        };
    }

    private Specification<E> getKeySpecification(BusinessComponent bc) {
        return (Specification & Serializable)(root, query, cb) -> cb.and((Predicate[])this.getHistoricityKey().getAttributes().stream().map(keyAttribute -> cb.equal((Expression)root.get(keyAttribute.getAttribute()), keyAttribute.getValueSupplier().get(bc))).toArray(Predicate[]::new));
    }

    @Override
    protected final CreateResult<T> doCreateEntity(E entity, BusinessComponent bc) {
        if (super.getList(bc).getResult().size() > 0) {
            throw new VersionMismatchException();
        }
        this.startEntity(entity, bc.getParameters().getDateTo(), this.findNextEntry(bc).map(HistoricityEntity::getStartDate).map(date -> date.minusDays(1L).with(this.asEndOfDay())).orElse(null));
        this.fillKey(bc, entity);
        this.baseDAO.save(entity);
        return new CreateResult<HistoricityDto>((HistoricityDto)((Object)this.entityToDto(bc, entity)));
    }

    private void fillKey(BusinessComponent bc, E entity) {
        for (HistoricityKey.KeyAttribute<E, T, ?> attribute : this.getHistoricityKey().getAttributes()) {
            PropertyUtils.setSimpleProperty(entity, (String)attribute.getAttribute().getName(), attribute.getValueSupplier().get(bc));
        }
    }

    @Override
    public final ActionResultDTO<T> deleteEntity(BusinessComponent bc) {
        HistoricityEntity entity = (HistoricityEntity)this.isExist(bc.getIdAsLong());
        if (DateTimeUtil.isSameDay(bc.getParameters().getDateTo(), entity.getStartDate())) {
            this.baseDAO.delete((AbstractEntity)entity);
        } else {
            this.closeEntity(entity, bc.getParameters().getDateTo());
        }
        return new ActionResultDTO();
    }

    @Override
    protected final ActionResultDTO<T> doUpdateEntity(E entity, T data, BusinessComponent bc) {
        E entityForUpdate = this.getEntityForUpdate(entity, data, bc);
        this.update(entityForUpdate, data, bc);
        return new ActionResultDTO<HistoricityDto>((HistoricityDto)((Object)this.entityToDto(bc, entityForUpdate))).setAction(PostAction.refreshBc(bc));
    }

    private E getEntityForUpdate(E entity, T data, BusinessComponent bc) {
        if (this.isKeyChanged(data)) {
            return this.copyEntity(entity);
        }
        if (DateTimeUtil.isSameDay(bc.getParameters().getDateTo(), entity.getStartDate())) {
            return entity;
        }
        E copy = this.copyEntity(entity);
        this.startEntity(copy, bc.getParameters().getDateTo(), entity.getEndDate());
        this.closeEntity(entity, bc.getParameters().getDateTo());
        return copy;
    }

    protected E copyEntity(E entity) {
        HistoricityEntity copy = (HistoricityEntity)this.typeOfEntity.newInstance();
        BeanUtils.copyProperties(entity, (Object)copy, (String[])((String[])InstrumentationAwareReflectionUtils.getAllNonSyntheticFieldsList(HistoricityEntity.class).stream().map(Field::getName).toArray(String[]::new)));
        this.baseDAO.save(copy);
        return (E)copy;
    }

    private boolean isKeyChanged(T dto) {
        for (HistoricityKey.KeyAttribute<E, T, ?> attribute : this.getHistoricityKey().getAttributes()) {
            for (DtoField<T, ?> dtoField : attribute.getDtoFields()) {
                if (!dto.isFieldChanged(dtoField)) continue;
                return true;
            }
        }
        return false;
    }

    protected abstract void update(E var1, T var2, BusinessComponent var3);

    protected ActionResultDTO<T> copy(BusinessComponent bc, T dto) {
        return null;
    }

    @Override
    public final Actions<T> getActions() {
        return Actions.builder().addAll(this.actions()).create().available(bc -> bc.getId() == null && this.isActionCreateAvailable(bc)).add().save().available(this::isActionSaveAvailable).add().delete().available(this::isActionDeleteAvailable).add().action(ActionType.COPY).available(this::isActionCopyAvailable).invoker(this::copy).add().build();
    }

    protected Actions<T> actions() {
        return new Actions(Collections.emptyList(), Collections.emptyList());
    }

    protected boolean isActionCreateAvailable(BusinessComponent bc) {
        return true;
    }

    protected boolean isActionSaveAvailable(BusinessComponent bc) {
        return true;
    }

    protected boolean isActionDeleteAvailable(BusinessComponent bc) {
        return false;
    }

    protected boolean isActionCopyAvailable(BusinessComponent bc) {
        return false;
    }

    private Optional<E> findNextEntry(BusinessComponent bc) {
        return Optional.ofNullable((HistoricityEntity)this.baseDAO.getFirstResultOrNull(this.typeOfEntity, (Specification & Serializable)(root, query, cb) -> {
            query.orderBy(new Order[]{cb.asc((Expression)root.get(HistoricityEntity_.startDate))});
            LocalDateTime redDate = bc.getParameters().getDateTo().with(this.asEndOfDay());
            return cb.and((Expression)this.getKeySpecification(bc).toPredicate(root, query, cb), (Expression)cb.greaterThan((Expression)root.get(HistoricityEntity_.startDate), (Comparable)redDate));
        }));
    }

    private void startEntity(E entity, LocalDateTime startDate, LocalDateTime endDate) {
        entity.setStartDate(startDate.with(DateTimeUtil.asStartOfDay()));
        entity.setEndDate(endDate);
    }

    private void closeEntity(E entity, LocalDateTime endDate) {
        entity.setEndDate(endDate.minusDays(1L).with(this.asEndOfDay()));
    }

    private TemporalAdjuster asEndOfDay() {
        return temporal -> ((LocalDateTime)temporal).withHour(23).withMinute(59).withSecond(59).withNano(0);
    }
}

