/*
 * Decompiled with CFR 0.152.
 */
package org.cxbox.core.crudma.impl.inner;

import com.google.common.collect.ImmutableList;
import java.util.Collections;
import java.util.List;
import java.util.stream.Collectors;
import org.cxbox.api.data.ResultPage;
import org.cxbox.api.data.dto.rowmeta.FieldDTO;
import org.cxbox.core.crudma.bc.BcRegistry;
import org.cxbox.core.crudma.bc.BusinessComponent;
import org.cxbox.core.crudma.impl.AbstractCrudmaService;
import org.cxbox.core.dto.data.BcDto;
import org.cxbox.core.dto.rowmeta.MetaDTO;
import org.cxbox.core.util.ListPaging;
import org.springframework.stereotype.Service;

@Service
public class BcCrudmaService
extends AbstractCrudmaService {
    private final List<BcDto> bcList;
    private final List<FieldDTO> fieldDtoList = ImmutableList.builder().add((Object)FieldDTO.disabledFilterableField((String)"id")).add((Object)FieldDTO.disabledFilterableField((String)"name")).build();

    public BcCrudmaService(BcRegistry bcRegistry) {
        this.bcList = bcRegistry.getAllBcNames().stream().map(BcDto::new).collect(Collectors.toList());
    }

    public ResultPage<BcDto> getAll(BusinessComponent bc) {
        return ListPaging.getResultPage(this.bcList, bc.getParameters());
    }

    @Override
    public long count(BusinessComponent bc) {
        return this.bcList.size();
    }

    @Override
    public MetaDTO getMeta(BusinessComponent bc) {
        return this.buildMeta(this.fieldDtoList);
    }

    @Override
    public MetaDTO getMetaEmpty(BusinessComponent bc) {
        return this.buildMeta(Collections.emptyList());
    }
}

