/*
 * Decompiled with CFR 0.152.
 */
package org.cxbox.core.crudma.impl.inner;

import java.util.Collection;
import java.util.List;
import java.util.Set;
import javax.persistence.metamodel.Attribute;
import org.cxbox.api.data.dto.UniversalDTO;
import org.cxbox.core.crudma.bc.BcRegistry;
import org.cxbox.core.crudma.bc.BusinessComponent;
import org.cxbox.core.crudma.bc.impl.InnerBcDescription;
import org.cxbox.core.crudma.impl.inner.UniversalCrudmaService;
import org.cxbox.core.dto.rowmeta.CreateResult;
import org.cxbox.core.dto.rowmeta.PostAction;
import org.cxbox.model.core.api.Translatable;
import org.cxbox.model.core.api.Translation;
import org.cxbox.model.core.api.TranslationService;
import org.cxbox.model.core.entity.BaseEntity;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class TranslationCrudmaService
extends UniversalCrudmaService<UniversalDTO, Translation> {
    @Autowired
    private BcRegistry bcRegistry;
    @Autowired
    private TranslationService translationService;

    @Override
    protected Class<UniversalDTO> getDtoClass() {
        return UniversalDTO.class;
    }

    @Override
    public CreateResult<UniversalDTO> create(BusinessComponent bc) {
        return this.doCreate(bc);
    }

    private <L extends Translation<E, L>, E extends BaseEntity> CreateResult<UniversalDTO> doCreate(BusinessComponent bc) {
        E parent = this.getParentEntity(bc);
        List created = this.translationService.populate(parent);
        return new CreateResult<UniversalDTO>(this.entityToDto((Translation)created.get(0), this.getDtoClass(), this.extractNames(this.getAttributes(bc)))).setAction(PostAction.refreshBc(bc));
    }

    @Override
    protected UniversalDTO entityToDto(Translation entity, Class<? extends UniversalDTO> dtoClass, Set<String> attributes) {
        UniversalDTO result = super.entityToDto(entity, dtoClass, attributes);
        result.setId(entity.getLanguage());
        return result;
    }

    @Override
    protected Translation getEntity(BusinessComponent bc) {
        Translatable parent = (Translatable)this.getParentEntity(bc);
        return (Translation)parent.getTranslation(bc.getId(), null).orElseThrow(IllegalArgumentException::new);
    }

    @Override
    protected Collection<? extends Translation> getEntities(BusinessComponent bc) {
        Translatable parent = (Translatable)this.getParentEntity(bc);
        return parent.getTranslations().values();
    }

    @Override
    public long count(BusinessComponent bc) {
        return this.getEntities(bc).size();
    }

    @Override
    protected Class<? extends Translation> getEntityClass(BusinessComponent bc) {
        return ((Translatable)this.getParentEntity(bc)).getTranslationType();
    }

    @Override
    protected List<Attribute<?, ?>> getAttributes(BusinessComponent bc) {
        return super.getAttributes(this.getEntityClass(bc), a -> String.class.isAssignableFrom(a.getJavaType()));
    }

    protected <E extends BaseEntity> E getParentEntity(BusinessComponent bc) {
        InnerBcDescription bcDescription = (InnerBcDescription)this.bcRegistry.getBcDescription(bc.getParentName());
        Class entityClass = this.responseFactory.getEntityFromService(bcDescription);
        return (E)this.jpaDao.findById(entityClass, bc.getParentIdAsLong());
    }

    @Override
    protected boolean isSaveAvailable(BusinessComponent bc) {
        return true;
    }

    @Override
    protected boolean isCreateAvailable(BusinessComponent bc) {
        return !this.translationService.getMissingTranslations(this.getParentEntity(bc)).isEmpty();
    }
}

