/*
 * Decompiled with CFR 0.152.
 */
package org.cxbox.core.dao.impl;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import java.util.Set;
import javax.persistence.EntityGraph;
import javax.persistence.EntityManager;
import javax.persistence.TypedQuery;
import javax.persistence.criteria.CriteriaBuilder;
import javax.persistence.criteria.CriteriaQuery;
import javax.persistence.criteria.Expression;
import javax.persistence.criteria.Predicate;
import javax.persistence.criteria.Root;
import javax.persistence.criteria.Selection;
import javax.persistence.metamodel.SingularAttribute;
import lombok.Generated;
import org.cxbox.api.data.PageSpecification;
import org.cxbox.api.data.ResultPage;
import org.cxbox.api.service.tx.TransactionService;
import org.cxbox.core.controller.param.FilterParameters;
import org.cxbox.core.controller.param.QueryParameters;
import org.cxbox.core.controller.param.SortParameters;
import org.cxbox.core.dao.BaseDAO;
import org.cxbox.core.dao.IPdqExtractor;
import org.cxbox.core.dao.impl.MetadataUtils;
import org.cxbox.core.util.filter.provider.ClassifyDataProvider;
import org.cxbox.model.core.dao.impl.JpaDaoImpl;
import org.hibernate.Session;
import org.hibernate.query.Query;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.data.jpa.domain.Specification;
import org.springframework.stereotype.Repository;
import org.springframework.transaction.annotation.Transactional;

@Repository
@Transactional
public class BaseDAOImpl
extends JpaDaoImpl
implements BaseDAO {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(BaseDAOImpl.class);
    private final Optional<IPdqExtractor> pdqExtractor;
    private final List<ClassifyDataProvider> providers;

    public BaseDAOImpl(Set<EntityManager> entityManagers, TransactionService txService, Optional<IPdqExtractor> pdqExtractor, List<ClassifyDataProvider> providers) {
        super(entityManagers, txService);
        this.pdqExtractor = pdqExtractor;
        this.providers = providers;
    }

    private Specification getPdqSearchSpec(QueryParameters queryParameters) {
        return this.pdqExtractor.map(pdqExtractor -> pdqExtractor.extractPdq(queryParameters.getPdqName())).orElse(null);
    }

    @Override
    public <T, X> Long getCount(Class<T> clazz, Class dtoClazz, SingularAttribute<T, X> name, X value, QueryParameters queryParameters) {
        return this.getCount(clazz, dtoClazz, (Specification & Serializable)(root, cq, cb) -> cb.equal((Expression)root.get(name), value), queryParameters);
    }

    @Override
    public <T> ResultPage<T> getList(Class<T> entityClazz, Class dtoClazz, Specification<T> defaultSearchSpec, QueryParameters parameters) {
        return this.getList(entityClazz, dtoClazz, defaultSearchSpec, parameters, null);
    }

    @Override
    public <T> ResultPage<T> getList(CriteriaQuery<T> cq, Root<T> root, Class dtoClazz, Predicate defaultSearchSpec, QueryParameters parameters) {
        return this.getList(cq, root, dtoClazz, defaultSearchSpec, parameters, null);
    }

    @Override
    public <T> Predicate getPredicateFromSearchParams(Root<T> root, CriteriaQuery<?> cq, CriteriaBuilder cb, Class dtoClazz, FilterParameters searchParams) {
        return MetadataUtils.getPredicateFromSearchParams(root, cq, cb, dtoClazz, searchParams, this.providers);
    }

    @Override
    public <T> Long getCount(CriteriaQuery<Long> cq, Root<T> root, Class dtoClazz, Predicate defaultSearchSpec, QueryParameters queryParameters) {
        Specification & Serializable pdqSearchSpec;
        EntityManager entityManager = this.getSupportedEntityManager(root.getModel().getBindableJavaType().getName());
        queryParameters = this.emptyIfNull(queryParameters);
        FilterParameters searchParams = queryParameters.getFilter();
        CriteriaBuilder cb = entityManager.getCriteriaBuilder();
        if (defaultSearchSpec == null) {
            defaultSearchSpec = cb.and(new Predicate[0]);
        }
        if ((pdqSearchSpec = this.getPdqSearchSpec(queryParameters)) == null) {
            pdqSearchSpec = (Specification & Serializable)(root1, cq1, cb1) -> cb1.and(new Predicate[0]);
        }
        cq.select((Selection)cb.count(root));
        Predicate searchParamsPredicate = this.getPredicateFromSearchParams(root, cq, cb, dtoClazz, searchParams);
        cq.where((Expression)cb.and(new Predicate[]{defaultSearchSpec, searchParamsPredicate, pdqSearchSpec.toPredicate(root, cq, cb)}));
        return (Long)entityManager.createQuery(cq).getSingleResult();
    }

    @Override
    public <T> Long getCount(Class<T> entityClass, Class<?> dtoClazz, Specification<T> searchSpec, QueryParameters queryParameters) {
        Specification pdqSearchSpec;
        EntityManager entityManager = this.getSupportedEntityManager(entityClass.getName());
        queryParameters = this.emptyIfNull(queryParameters);
        FilterParameters parameters = queryParameters.getFilter();
        CriteriaBuilder cb = entityManager.getCriteriaBuilder();
        CriteriaQuery cq = cb.createQuery(Long.class);
        Root root = cq.from(entityClass);
        cq.select((Selection)cb.count((Expression)root));
        ArrayList<Predicate> predicates = new ArrayList<Predicate>();
        if (searchSpec != null) {
            predicates.add(searchSpec.toPredicate(root, cq, cb));
        }
        if ((pdqSearchSpec = this.getPdqSearchSpec(queryParameters)) != null) {
            predicates.add(pdqSearchSpec.toPredicate(root, cq, cb));
        }
        predicates.add(this.getPredicateFromSearchParams(root, cq, cb, dtoClazz, parameters));
        cq.where((Expression)cb.and(predicates.toArray(new Predicate[0])));
        return (Long)entityManager.createQuery(cq).getSingleResult();
    }

    @Override
    public <T> ResultPage<T> getList(CriteriaQuery<T> cq, Root<T> root, Class dtoClazz, Predicate defaultSearchSpec, QueryParameters parameters, EntityGraph<? super T> fetchGraph) {
        Specification & Serializable pdqSearchSpec;
        EntityManager entityManager = this.getSupportedEntityManager(root.getModel().getBindableJavaType().getName());
        CriteriaBuilder cb = entityManager.getCriteriaBuilder();
        SortParameters sort = parameters.getSort();
        FilterParameters filter = parameters.getFilter();
        if (defaultSearchSpec == null) {
            defaultSearchSpec = cb.and(new Predicate[0]);
        }
        if ((pdqSearchSpec = this.getPdqSearchSpec(parameters)) == null) {
            pdqSearchSpec = (Specification & Serializable)(root1, cq1, cb1) -> cb1.and(new Predicate[0]);
        }
        Predicate searchParamsPredicate = this.getPredicateFromSearchParams(root, cq, cb, dtoClazz, filter);
        if (cq.getRestriction() != null) {
            cq.where((Expression)cb.and(new Predicate[]{cq.getRestriction(), defaultSearchSpec, searchParamsPredicate, pdqSearchSpec.toPredicate(root, cq, cb)}));
        } else {
            cq.where((Expression)cb.and(new Predicate[]{defaultSearchSpec, searchParamsPredicate, pdqSearchSpec.toPredicate(root, cq, cb)}));
        }
        MetadataUtils.addSorting(dtoClazz, root, cq, cb, sort);
        this.applyGraph(root, fetchGraph);
        Query query = ((Session)entityManager.unwrap(Session.class)).getSession().createQuery(cq);
        this.applyPaging((TypedQuery)query, parameters.getPage());
        return ResultPage.of((List)query.getResultList(), (PageSpecification)parameters.getPage());
    }

    @Override
    public <T> ResultPage<T> getList(Class<T> entityClazz, Class dtoClazz, Specification<T> defaultSearchSpec, QueryParameters parameters, EntityGraph<? super T> fetchGraph) {
        EntityManager entityManager = this.getSupportedEntityManager(entityClazz.getName());
        CriteriaBuilder cb = entityManager.getCriteriaBuilder();
        CriteriaQuery cq = cb.createQuery(entityClazz);
        Root root = cq.from(entityClazz);
        Predicate predicate = defaultSearchSpec.toPredicate(root, cq, cb);
        return this.getList(cq, root, dtoClazz, predicate, parameters, fetchGraph);
    }

    private QueryParameters emptyIfNull(QueryParameters queryParameters) {
        if (queryParameters == null) {
            return QueryParameters.emptyQueryParameters();
        }
        return queryParameters;
    }
}

