/*
 * Decompiled with CFR 0.152.
 */
package org.cxbox.core.dao.impl;

import java.io.Serializable;
import java.util.Collections;
import java.util.List;
import javax.persistence.criteria.Expression;
import org.cxbox.api.data.dictionary.CoreDictionaries;
import org.cxbox.core.crudma.bc.impl.InnerBcDescription;
import org.cxbox.core.util.session.SessionService;
import org.cxbox.model.core.dao.JpaDao;
import org.cxbox.model.ui.entity.SearchSpec;
import org.cxbox.model.ui.entity.SearchSpec_;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.cache.annotation.CacheEvict;
import org.springframework.cache.annotation.Cacheable;
import org.springframework.data.jpa.domain.Specification;
import org.springframework.stereotype.Repository;
import org.springframework.transaction.annotation.Transactional;

@Transactional
@Repository
public class SearchSpecDao {
    @Autowired
    private JpaDao jpaDao;
    @Autowired
    private SessionService sessionService;
    private final ParametrizedSSSpecification securitySpecification = serviceName -> (Specification & Serializable)(root, cq, cb) -> cb.and((Expression)cb.equal((Expression)root.get(SearchSpec_.type), (Object)CoreDictionaries.SearchSpecType.SECURITY), (Expression)cb.equal((Expression)root.get(SearchSpec_.serviceName), (Object)serviceName));
    private final ParametrizedSSSpecification bcSpecification = bcName -> (Specification & Serializable)(root, cq, cb) -> cb.and((Expression)cb.equal((Expression)root.get(SearchSpec_.type), (Object)CoreDictionaries.SearchSpecType.BC), (Expression)cb.equal((Expression)root.get(SearchSpec_.bcName), (Object)bcName));
    private final ParametrizedSSSpecification linkSpecification = serviceName -> (Specification & Serializable)(root, cq, cb) -> cb.and((Expression)cb.equal((Expression)root.get(SearchSpec_.type), (Object)CoreDictionaries.SearchSpecType.LINK), (Expression)cb.equal((Expression)root.get(SearchSpec_.serviceName), (Object)serviceName));

    public Specification<SearchSpec> securitySpecification(String serviceName) {
        return this.securitySpecification.toSpecification(serviceName);
    }

    public Specification<SearchSpec> bcSpecification(String bcName) {
        return this.bcSpecification.toSpecification(bcName);
    }

    public Specification<SearchSpec> linkSpecification(String serviceName) {
        return this.linkSpecification.toSpecification(serviceName);
    }

    @Cacheable(cacheResolver="cxboxCacheResolver", cacheNames={"specifications"}, key="{#root.methodName, #bcDescription?.name, @sessionService.sessionUserRole}")
    public List<SearchSpec> getSecuritySpecifications(InnerBcDescription bcDescription) {
        if (bcDescription == null || bcDescription.getServiceClass() == null) {
            return Collections.emptyList();
        }
        return this.jpaDao.getList(SearchSpec.class, Specification.where(this.securitySpecification.toSpecification(bcDescription.getServiceClass().getSimpleName())).and((Specification & Serializable)(root, cq, cb) -> cb.or((Expression)cb.equal((Expression)root.get(SearchSpec_.roleCd), (Object)this.sessionService.getSessionUserRole()), (Expression)cb.isNull((Expression)root.get(SearchSpec_.roleCd)))));
    }

    @Cacheable(cacheResolver="cxboxCacheResolver", cacheNames={"specifications"}, key="{#root.methodName, #bcDescription?.name}")
    public List<SearchSpec> getBcSpecifications(InnerBcDescription bcDescription) {
        if (bcDescription == null || bcDescription.getServiceClass() == null) {
            return Collections.emptyList();
        }
        return this.jpaDao.getList(SearchSpec.class, this.bcSpecification.toSpecification(bcDescription.getName()));
    }

    @Cacheable(cacheResolver="cxboxCacheResolver", cacheNames={"specifications"}, key="{#root.methodName, #bcDescription?.name}")
    public List<SearchSpec> getLinkSpecifications(InnerBcDescription bcDescription) {
        if (bcDescription == null || bcDescription.getServiceClass() == null) {
            return Collections.emptyList();
        }
        return this.jpaDao.getList(SearchSpec.class, (Specification & Serializable)(root, cq, cb) -> cb.and((Expression)cb.equal((Expression)root.get(SearchSpec_.type), (Object)CoreDictionaries.SearchSpecType.LINK), (Expression)cb.equal((Expression)root.get(SearchSpec_.bcName), (Object)bcDescription.getName())));
    }

    @CacheEvict(cacheResolver="cxboxCacheResolver", cacheNames={"specifications"}, allEntries=true)
    public void clearCache() {
    }

    private static interface ParametrizedSSSpecification {
        public Specification<SearchSpec> toSpecification(String var1);
    }
}

