/*
 * Decompiled with CFR 0.152.
 */
package org.cxbox.core.dto;

import com.fasterxml.jackson.databind.JsonNode;
import java.util.Collection;
import java.util.List;
import lombok.Generated;
import org.cxbox.api.data.dictionary.SimpleDictionary;
import org.cxbox.core.dto.data.view.ScreenResponsibility;
import org.cxbox.model.core.entity.User;

public class LoggedUser {
    private String sessionId;
    private Number userId;
    private String login;
    private String lastName;
    private String firstName;
    private String patronymic;
    private String fullName;
    private String principalName;
    private String phone;
    private String activeRole;
    private List<SimpleDictionary> roles;
    @Deprecated
    private List<ScreenResponsibility> screens;
    private JsonNode userSettingsVersion;
    private Collection<SimpleDictionary> featureSettings;
    private String systemUrl;
    private String timezone;
    private String language;
    private boolean devPanelEnabled;

    public static Builder builder() {
        return new LoggedUser().new Builder();
    }

    @Generated
    public String getSessionId() {
        return this.sessionId;
    }

    @Generated
    public Number getUserId() {
        return this.userId;
    }

    @Generated
    public String getLogin() {
        return this.login;
    }

    @Generated
    public String getLastName() {
        return this.lastName;
    }

    @Generated
    public String getFirstName() {
        return this.firstName;
    }

    @Generated
    public String getPatronymic() {
        return this.patronymic;
    }

    @Generated
    public String getFullName() {
        return this.fullName;
    }

    @Generated
    public String getPrincipalName() {
        return this.principalName;
    }

    @Generated
    public String getPhone() {
        return this.phone;
    }

    @Generated
    public String getActiveRole() {
        return this.activeRole;
    }

    @Generated
    public List<SimpleDictionary> getRoles() {
        return this.roles;
    }

    @Deprecated
    @Generated
    public List<ScreenResponsibility> getScreens() {
        return this.screens;
    }

    @Generated
    public JsonNode getUserSettingsVersion() {
        return this.userSettingsVersion;
    }

    @Generated
    public Collection<SimpleDictionary> getFeatureSettings() {
        return this.featureSettings;
    }

    @Generated
    public String getSystemUrl() {
        return this.systemUrl;
    }

    @Generated
    public String getTimezone() {
        return this.timezone;
    }

    @Generated
    public String getLanguage() {
        return this.language;
    }

    @Generated
    public boolean isDevPanelEnabled() {
        return this.devPanelEnabled;
    }

    @Generated
    private LoggedUser() {
    }

    public class Builder {
        private Builder() {
        }

        public Builder sessionId(String sessionId) {
            LoggedUser.this.sessionId = sessionId;
            return this;
        }

        public Builder systemUrl(String url) {
            LoggedUser.this.systemUrl = url;
            return this;
        }

        public Builder user(User user) {
            LoggedUser.this.userId = user.getId();
            LoggedUser.this.login = user.getLogin();
            LoggedUser.this.lastName = user.getLastName();
            LoggedUser.this.firstName = user.getFirstName();
            LoggedUser.this.patronymic = user.getPatronymic();
            LoggedUser.this.fullName = user.getFullName();
            LoggedUser.this.principalName = user.getUserPrincipalName();
            LoggedUser.this.phone = user.getPhone();
            return this;
        }

        public Builder activeRole(String activeRole) {
            LoggedUser.this.activeRole = activeRole;
            return this;
        }

        public Builder language(String locale) {
            LoggedUser.this.language = locale;
            return this;
        }

        public Builder timezone(String timezone) {
            LoggedUser.this.timezone = timezone;
            return this;
        }

        public Builder roles(List<SimpleDictionary> roleList) {
            LoggedUser.this.roles = roleList;
            return this;
        }

        public Builder screens(List<ScreenResponsibility> screens) {
            LoggedUser.this.screens = screens;
            return this;
        }

        public Builder userSettings(JsonNode userSettings) {
            LoggedUser.this.userSettingsVersion = userSettings;
            return this;
        }

        public Builder featureSettings(Collection<SimpleDictionary> featureList) {
            LoggedUser.this.featureSettings = featureList;
            return this;
        }

        public Builder devPanelEnabled(boolean devPanelEnabled) {
            LoggedUser.this.devPanelEnabled = devPanelEnabled;
            return this;
        }

        public LoggedUser build() {
            return LoggedUser.this;
        }
    }
}

