/*
 * Decompiled with CFR 0.152.
 */
package org.cxbox.core.dto.rowmeta;

import com.fasterxml.jackson.annotation.JsonAnyGetter;
import java.beans.ConstructorProperties;
import java.util.Map;
import java.util.Objects;
import lombok.Generated;
import org.apache.commons.lang3.StringUtils;
import org.cxbox.core.dto.rowmeta.PreActionType;

public class PreAction {
    private final PreActionType preActionType;
    private final String message;
    private final Map<String, String> customParameters;

    private static PreAction preAction(PreActionType preAction, String message, Map<String, String> customParameters) {
        return PreAction.builder().preActionType(preAction).message(message).customParameters(customParameters).build();
    }

    public static PreAction confirm(String message) {
        return PreAction.preAction(PreActionType.CONFIRMATION, message, null);
    }

    public static PreAction confirm() {
        return PreAction.confirm(null);
    }

    public static PreAction info(String message) {
        return PreAction.preAction(PreActionType.INFORMATION, message, null);
    }

    public static PreAction info() {
        return PreAction.info(null);
    }

    public static PreAction error(String message) {
        return PreAction.preAction(PreActionType.ERROR, message, null);
    }

    public static PreAction error() {
        return PreAction.error(null);
    }

    public static PreAction custom(String message, Map<String, String> customParameters) {
        return PreAction.preAction(PreActionType.CUSTOM, message, customParameters);
    }

    public String getType() {
        return this.preActionType.getType();
    }

    public String getMessage() {
        return this.message;
    }

    @JsonAnyGetter
    public Map<String, String> getCustomParameters() {
        return this.customParameters;
    }

    public String getMessage(String action) {
        return StringUtils.isBlank((CharSequence)this.message) && Objects.nonNull((Object)this.preActionType) ? this.preActionType.getMessage(StringUtils.trimToEmpty((String)action)) : this.message;
    }

    @Generated
    public static PreActionBuilder builder() {
        return new PreActionBuilder();
    }

    @ConstructorProperties(value={"preActionType", "message", "customParameters"})
    @Generated
    public PreAction(PreActionType preActionType, String message, Map<String, String> customParameters) {
        this.preActionType = preActionType;
        this.message = message;
        this.customParameters = customParameters;
    }

    @Generated
    public static class PreActionBuilder {
        @Generated
        private PreActionType preActionType;
        @Generated
        private String message;
        @Generated
        private Map<String, String> customParameters;

        @Generated
        PreActionBuilder() {
        }

        @Generated
        public PreActionBuilder preActionType(PreActionType preActionType) {
            this.preActionType = preActionType;
            return this;
        }

        @Generated
        public PreActionBuilder message(String message) {
            this.message = message;
            return this;
        }

        @Generated
        public PreActionBuilder customParameters(Map<String, String> customParameters) {
            this.customParameters = customParameters;
            return this;
        }

        @Generated
        public PreAction build() {
            return new PreAction(this.preActionType, this.message, this.customParameters);
        }

        @Generated
        public String toString() {
            return "PreAction.PreActionBuilder(preActionType=" + (Object)((Object)this.preActionType) + ", message=" + this.message + ", customParameters=" + this.customParameters + ")";
        }
    }
}

