/*
 * Decompiled with CFR 0.152.
 */
package org.cxbox.core.dto.rowmeta;

import com.fasterxml.jackson.databind.ObjectMapper;
import java.beans.ConstructorProperties;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import javax.annotation.Nullable;
import lombok.Generated;
import lombok.NonNull;
import org.cxbox.api.data.dictionary.DictionaryCache;
import org.cxbox.api.data.dictionary.IDictionaryType;
import org.cxbox.api.data.dictionary.LOV;
import org.cxbox.api.data.dictionary.SimpleDictionary;
import org.cxbox.api.data.dto.DataResponseDTO;
import org.cxbox.api.data.dto.rowmeta.FieldDTO;
import org.cxbox.api.data.dto.rowmeta.FieldsDTO;
import org.cxbox.api.data.dto.rowmeta.IconCode;
import org.cxbox.constgen.DtoField;
import org.cxbox.core.dto.FieldDrillDown;
import org.cxbox.core.service.action.DrillDownTypeSpecifier;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class RowDependentFieldsMeta<T extends DataResponseDTO>
extends FieldsDTO {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(RowDependentFieldsMeta.class);
    private final ObjectMapper objectMapper;

    public FieldDTO get(DtoField<? super T, ?> field) {
        return (FieldDTO)this.fields.get(field.getName());
    }

    public final void addConcreteValue(DtoField<? super T, ?> field, SimpleDictionary dictDTO) {
        Optional.ofNullable(field).map(dtoField -> (FieldDTO)this.fields.get(dtoField.getName())).ifPresent(fieldDTO -> fieldDTO.addValue(dictDTO));
    }

    public final void setDictionaryTypeWithConcreteValuesFromList(DtoField<? super T, ?> field, IDictionaryType type, List<LOV> lovs) {
        String[] keys = (String[])lovs.stream().filter(Objects::nonNull).map(LOV::getKey).toArray(String[]::new);
        this.setDictionaryTypeWithConcreteValues(field, type, keys);
    }

    @Deprecated
    public void setDictionaryValuesWithIcons(String field, IDictionaryType type, Map<LOV, IconCode> valueIconMap) {
        Optional.ofNullable(field).map(dtoField -> (FieldDTO)this.fields.get(dtoField)).ifPresent(fieldDTO -> {
            fieldDTO.setDictionaryName(type.getName());
            fieldDTO.clearValues();
            valueIconMap.forEach((key, value) -> fieldDTO.setIconWithValue(type.lookupValue(key), value, false));
        });
    }

    @SafeVarargs
    public final void setRequired(DtoField<? super T, ?> ... fields) {
        this.required(true, fields);
    }

    @SafeVarargs
    public final void setNotRequired(DtoField<? super T, ?> ... fields) {
        this.required(false, fields);
    }

    @SafeVarargs
    public final void required(boolean required, DtoField<? super T, ?> ... fields) {
        Stream.of(fields).forEach(field -> Optional.ofNullable(field).map(dtoField -> (FieldDTO)this.fields.get(dtoField.getName())).ifPresent(fieldDTO -> fieldDTO.setRequired(Boolean.valueOf(required))));
    }

    public final void disableFields() {
        this.fields.values().forEach(fieldDTO -> fieldDTO.setDisabled(Boolean.valueOf(true)));
    }

    @SafeVarargs
    public final void setDisabled(DtoField<? super T, ?> ... fields) {
        this.disable(true, fields);
    }

    @SafeVarargs
    public final void setEnabled(DtoField<? super T, ?> ... fields) {
        this.disable(false, fields);
    }

    public final void disable(boolean disabled, DtoField<? super T, ?> ... fields) {
        List<String> fieldsList = Stream.of(fields).map(DtoField::getName).collect(Collectors.toList());
        this.disable(disabled, fieldsList);
    }

    public void setDisabled(List<String> fields) {
        this.disable(true, fields);
    }

    private final void disable(boolean disabled, List<String> fields) {
        fields.forEach(field -> Optional.ofNullable(field).map(dtoField -> (FieldDTO)this.fields.get(dtoField)).ifPresent(fieldDTO -> fieldDTO.setDisabled(Boolean.valueOf(disabled))));
    }

    public final void setDictionaryTypeWithAllValues(DtoField<? super T, ?> field, IDictionaryType type) {
        this.setDictionaryTypeWithAllValues(field, type.getName());
    }

    public final void setDictionaryTypeWithAllValues(DtoField<? super T, ?> field, String type) {
        Optional.ofNullable(field).map(dtoField -> (FieldDTO)this.fields.get(dtoField.getName())).ifPresent(fieldDTO -> {
            fieldDTO.setDictionaryName(type);
            fieldDTO.clearValues();
            fieldDTO.setValues(DictionaryCache.dictionary().getAll(type));
        });
    }

    @Deprecated
    public final void setDictionaryTypeWithConcreteValues(DtoField<? super T, ?> field, IDictionaryType type, String ... keys) {
        Optional.ofNullable(field).map(dtoField -> (FieldDTO)this.fields.get(dtoField.getName())).ifPresent(fieldDTO -> {
            fieldDTO.setDictionaryName(type.getName());
            fieldDTO.clearValues();
            ArrayList<SimpleDictionary> dictDTOList = new ArrayList<SimpleDictionary>();
            for (String key : keys) {
                SimpleDictionary dto = DictionaryCache.dictionary().get(type, key);
                if (dto == null) continue;
                dictDTOList.add(dto);
            }
            fieldDTO.setValues(dictDTOList);
        });
    }

    public final void setDictionaryTypeWithCustomValues(DtoField<? super T, ?> field, String ... keys) {
        Optional.ofNullable(field).map(dtoField -> (FieldDTO)this.fields.get(dtoField.getName())).ifPresent(fieldDTO -> {
            fieldDTO.clearValues();
            ArrayList<SimpleDictionary> dictDTOList = new ArrayList<SimpleDictionary>();
            for (String key : keys) {
                SimpleDictionary dto = new SimpleDictionary(key, key);
                dictDTOList.add(dto);
            }
            fieldDTO.setValues(dictDTOList);
        });
    }

    public final void setDictionaryTypeWithConcreteValues(DtoField<? super T, ?> field, IDictionaryType type, List<LOV> lovs) {
        String[] keys = (String[])lovs.stream().filter(Objects::nonNull).map(LOV::getKey).toArray(String[]::new);
        this.setDictionaryTypeWithConcreteValues(field, type, keys);
    }

    public final void setDictionaryTypeWithConcreteValues(DtoField<? super T, ?> field, IDictionaryType type, LOV ... lovs) {
        String[] keys = (String[])Arrays.stream(lovs).filter(Objects::nonNull).map(LOV::getKey).toArray(String[]::new);
        this.setDictionaryTypeWithConcreteValues(field, type, keys);
    }

    public final void setConcreteValues(DtoField<? super T, ?> field, Collection<SimpleDictionary> dictDtoList) {
        Optional.ofNullable(field).map(dtoField -> (FieldDTO)this.fields.get(dtoField.getName())).ifPresent(fieldDTO -> {
            fieldDTO.setDictionaryName(field.getName());
            fieldDTO.clearValues();
            fieldDTO.setValues(dictDtoList);
        });
    }

    public <E extends Enum> void setEnumValues(@Nullable DtoField<? super T, E> field, E ... values) {
        if (values == null) {
            throw new NullPointerException("values is marked non-null but is null");
        }
        if (field != null) {
            this.setConcreteValues(field, Arrays.stream(values).map(en -> new SimpleDictionary(en.name(), this.serialize((Enum<?>)en))).collect(Collectors.toList()));
        }
    }

    String serialize(@NonNull Enum<?> en) {
        if (en == null) {
            throw new NullPointerException("en is marked non-null but is null");
        }
        String serialize = this.objectMapper.writeValueAsString(en);
        return serialize.substring(1, serialize.length() - 1);
    }

    public final void setDrilldown(DtoField<? super T, ?> field, DrillDownTypeSpecifier drillDownType, String drillDown) {
        Optional.ofNullable(field).map(dtoField -> (FieldDTO)this.fields.get(dtoField.getName())).ifPresent(fieldDTO -> {
            fieldDTO.setDrillDown(drillDown);
            fieldDTO.setDrillDownType(drillDownType.getValue());
        });
    }

    public final void setDrilldowns(List<FieldDrillDown> drillDowns) {
        for (FieldDrillDown drillDown : drillDowns) {
            Optional.ofNullable(drillDown).map(dd -> (FieldDTO)this.fields.get(dd.getTaskField())).ifPresent(fieldDTO -> {
                fieldDTO.setDrillDown(drillDown.getUrl());
                fieldDTO.setDrillDownType(drillDown.getType().getValue());
            });
        }
    }

    public final void setDictionaryValuesWithIcons(DtoField<? super T, ?> field, IDictionaryType type, Map<LOV, IconCode> valueIconMap) {
        Optional.ofNullable(field).map(dtoField -> (FieldDTO)this.fields.get(dtoField.getName())).ifPresent(fieldDTO -> {
            fieldDTO.setDictionaryName(type.getName());
            fieldDTO.clearValues();
            valueIconMap.forEach((key, value) -> fieldDTO.setIconWithValue(type.lookupValue(key), value, false));
        });
    }

    public final void setCurrentValue(DtoField<? super T, ?> field, Object value) {
        Optional.ofNullable(field).map(dtoField -> (FieldDTO)this.fields.get(dtoField.getName())).ifPresent(fieldDTO -> fieldDTO.setCurrentValue(value));
    }

    public final void setPlaceholder(DtoField<? super T, ?> field, String placeholder) {
        Optional.ofNullable(field).map(dtoField -> (FieldDTO)this.fields.get(dtoField.getName())).ifPresent(fieldDTO -> fieldDTO.setPlaceholder(placeholder));
    }

    @ConstructorProperties(value={"objectMapper"})
    @Generated
    public RowDependentFieldsMeta(ObjectMapper objectMapper) {
        this.objectMapper = objectMapper;
    }
}

