/*
 * Decompiled with CFR 0.152.
 */
package org.cxbox.core.metahotreload.service;

import com.fasterxml.jackson.databind.ObjectMapper;
import java.beans.ConstructorProperties;
import java.util.List;
import java.util.Optional;
import lombok.Generated;
import lombok.NonNull;
import org.cxbox.core.metahotreload.dto.BcSourceDTO;
import org.cxbox.core.metahotreload.util.JsonUtils;
import org.cxbox.model.core.dao.JpaDao;
import org.cxbox.model.ui.entity.Bc;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.stereotype.Service;

@Service
public class BcUtil {
    private final JpaDao jpaDao;
    @Qualifier(value="cxboxObjectMapper")
    private final ObjectMapper objectMapper;

    public void process(@NonNull List<BcSourceDTO> dtos) {
        if (dtos == null) {
            throw new NullPointerException("dtos is marked non-null but is null");
        }
        dtos.stream().map(bcDto -> BcUtil.mapToEntity(bcDto, this.objectMapper)).forEach(arg_0 -> ((JpaDao)this.jpaDao).save(arg_0));
    }

    @NonNull
    private static Bc mapToEntity(@NonNull BcSourceDTO bcDto, ObjectMapper objectMapper) {
        if (bcDto == null) {
            throw new NullPointerException("bcDto is marked non-null but is null");
        }
        return new Bc().setName(bcDto.getName()).setParentName(bcDto.getParentName()).setQuery(bcDto.getQuery()).setDefaultOrder(bcDto.getDefaultOrder()).setReportDateField(bcDto.getReportDateField()).setPageLimit(bcDto.getPageLimit()).setEditable(Optional.ofNullable(bcDto.getEditable()).map(val -> val > 0L).orElse(false)).setRefresh(Optional.ofNullable(bcDto.getRefresh()).map(val -> val > 0L).orElse(false)).setBinds(JsonUtils.serializeOrElseNull(objectMapper, bcDto.getBinds()));
    }

    @ConstructorProperties(value={"jpaDao", "objectMapper"})
    @Generated
    public BcUtil(JpaDao jpaDao, @Qualifier(value="cxboxObjectMapper") ObjectMapper objectMapper) {
        this.jpaDao = jpaDao;
        this.objectMapper = objectMapper;
    }
}

