/*
 * Decompiled with CFR 0.152.
 */
package org.cxbox.core.metahotreload.service;

import java.beans.ConstructorProperties;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.StringJoiner;
import java.util.stream.Collectors;
import javax.persistence.criteria.Predicate;
import javax.validation.constraints.NotNull;
import lombok.Generated;
import lombok.NonNull;
import org.cxbox.api.data.dictionary.LOV;
import org.cxbox.api.service.session.InternalAuthorizationService;
import org.cxbox.api.service.tx.TransactionService;
import org.cxbox.core.metahotreload.MetaHotReloadService;
import org.cxbox.core.metahotreload.conf.properties.MetaConfigurationProperties;
import org.cxbox.core.metahotreload.dto.BcSourceDTO;
import org.cxbox.core.metahotreload.dto.ScreenSourceDto;
import org.cxbox.core.metahotreload.dto.ViewSourceDTO;
import org.cxbox.core.metahotreload.dto.WidgetSourceDTO;
import org.cxbox.core.metahotreload.service.BcUtil;
import org.cxbox.core.metahotreload.service.MetaResourceReaderService;
import org.cxbox.core.metahotreload.service.ScreenAndNavigationGroupAndNavigationViewUtil;
import org.cxbox.core.metahotreload.service.ViewAndViewWidgetUtil;
import org.cxbox.core.metahotreload.service.WidgetUtil;
import org.cxbox.model.core.dao.JpaDao;
import org.cxbox.model.core.entity.Responsibilities;
import org.cxbox.model.ui.entity.Bc;
import org.cxbox.model.ui.entity.Screen;
import org.cxbox.model.ui.entity.View;
import org.cxbox.model.ui.entity.ViewWidgets;
import org.cxbox.model.ui.entity.Widget;
import org.cxbox.model.ui.navigation.NavigationGroup;
import org.cxbox.model.ui.navigation.NavigationView;
import org.springframework.data.jpa.domain.Specification;

public class MetaHotReloadServiceImpl
implements MetaHotReloadService {
    protected final MetaConfigurationProperties config;
    protected final MetaResourceReaderService metaResourceReaderService;
    protected final InternalAuthorizationService authzService;
    protected final TransactionService txService;
    protected final JpaDao jpaDao;
    protected final WidgetUtil widgetUtil;
    protected final ViewAndViewWidgetUtil viewAndViewWidgetUtil;
    protected final ScreenAndNavigationGroupAndNavigationViewUtil screenAndNavigationGroupAndNavigationViewUtil;
    protected final BcUtil bcUtil;

    private static void deleteAllMeta(@NotNull JpaDao jpaDao) {
        jpaDao.delete(NavigationView.class, (Specification & Serializable)(root, query, cb) -> cb.and(new Predicate[0]));
        jpaDao.delete(NavigationGroup.class, (Specification & Serializable)(root, query, cb) -> cb.and(new Predicate[0]));
        jpaDao.delete(Screen.class, (Specification & Serializable)(root, query, cb) -> cb.and(new Predicate[0]));
        jpaDao.delete(ViewWidgets.class, (Specification & Serializable)(root, query, cb) -> cb.and(new Predicate[0]));
        jpaDao.delete(View.class, (Specification & Serializable)(root, query, cb) -> cb.and(new Predicate[0]));
        jpaDao.delete(Widget.class, (Specification & Serializable)(root, query, cb) -> cb.and(new Predicate[0]));
        jpaDao.delete(Bc.class, (Specification & Serializable)(root, query, cb) -> cb.and(new Predicate[0]));
    }

    @Override
    public void loadMeta() {
        List<BcSourceDTO> bcDtos = this.metaResourceReaderService.getBcs();
        List<ScreenSourceDto> screenDtos = this.metaResourceReaderService.getScreens();
        List<WidgetSourceDTO> widgetDtos = this.metaResourceReaderService.getWidgets();
        List<ViewSourceDTO> viewDtos = this.metaResourceReaderService.getViews();
        this.authzService.loginAs(this.authzService.createAuthentication(InternalAuthorizationService.VANILLA));
        this.txService.invokeInTx(() -> {
            this.loadMetaPreProcess(widgetDtos, viewDtos, screenDtos);
            MetaHotReloadServiceImpl.deleteAllMeta(this.jpaDao);
            this.bcUtil.process(bcDtos);
            Map<String, Widget> nameToWidget = this.widgetUtil.process(widgetDtos);
            this.viewAndViewWidgetUtil.process(viewDtos, nameToWidget);
            this.screenAndNavigationGroupAndNavigationViewUtil.process(screenDtos);
            this.responsibilitiesProcess(screenDtos, viewDtos);
            this.loadMetaAfterProcess();
            return null;
        });
    }

    private void responsibilitiesProcess(List<ScreenSourceDto> screenDtos, List<ViewSourceDTO> viewDtos) {
        if (this.config.isViewAllowedRolesEnabled()) {
            Map<String, String> viewToScreenMap = this.jpaDao.getList(NavigationView.class).stream().collect(Collectors.toMap(NavigationView::getViewName, NavigationView::getScreenName));
            ArrayList<Responsibilities> responsibilities = new ArrayList<Responsibilities>();
            long defaultDepartmentId = 0L;
            viewDtos.forEach(view -> view.getRolesAllowed().forEach(role -> responsibilities.add(new Responsibilities().setResponsibilityType(Responsibilities.ResponsibilityType.VIEW).setInternalRoleCD(new LOV(role)).setView(view.getName()).setDepartmentId(Long.valueOf(defaultDepartmentId)))));
            Map<String, ScreenSourceDto> screenNameToScreen = screenDtos.stream().collect(Collectors.toMap(ScreenSourceDto::getName, sd -> sd));
            HashMap rolesToScreens = new HashMap();
            viewDtos.forEach(v -> {
                if (viewToScreenMap.containsKey(v.getName())) {
                    String screenName = (String)viewToScreenMap.get(v.getName());
                    v.getRolesAllowed().forEach(role -> {
                        if (!rolesToScreens.containsKey(role)) {
                            rolesToScreens.put(role, new HashSet());
                        }
                        ((Set)rolesToScreens.get(role)).add((ScreenSourceDto)screenNameToScreen.get(screenName));
                    });
                }
            });
            for (Map.Entry entry : rolesToScreens.entrySet()) {
                String role = (String)entry.getKey();
                Set screens = (Set)entry.getValue();
                responsibilities.add(new Responsibilities().setResponsibilityType(Responsibilities.ResponsibilityType.SCREEN).setInternalRoleCD(new LOV(role)).setScreens(this.mapToScreens(screenNameToScreen, screens)).setDepartmentId(Long.valueOf(defaultDepartmentId)));
            }
            this.jpaDao.delete(Responsibilities.class, (Specification & Serializable)(root, query, cb) -> cb.and(new Predicate[0]));
            this.jpaDao.saveAll(responsibilities);
        }
    }

    @NonNull
    private String mapToScreens(@NonNull Map<String, ScreenSourceDto> screenNameToScreen, @NonNull Set<ScreenSourceDto> screens) {
        if (screenNameToScreen == null) {
            throw new NullPointerException("screenNameToScreen is marked non-null but is null");
        }
        if (screens == null) {
            throw new NullPointerException("screens is marked non-null but is null");
        }
        StringJoiner joiner = new StringJoiner(",");
        List orderedScreens = screens.stream().sorted(Comparator.comparing(ScreenSourceDto::getOrder).thenComparing(ScreenSourceDto::getName)).collect(Collectors.toList());
        for (int i = 0; i < orderedScreens.size(); ++i) {
            ScreenSourceDto screen = (ScreenSourceDto)orderedScreens.get(i);
            String s = "  {\n    \"id\": \"id" + i + "\",\n    \"name\": \"" + screen.getName() + "\",\n    \"text\": \"" + screen.getTitle() + "\",\n    \"url\": \"/screen/" + screen.getName() + "\",\n    \"icon\": \"" + screen.getIcon() + "\"\n  }";
            joiner.add(s);
        }
        String collect = joiner.toString();
        return "[\n" + collect + "\n]";
    }

    protected void loadMetaPreProcess(List<WidgetSourceDTO> widgetDtos, List<ViewSourceDTO> viewDtos, List<ScreenSourceDto> screenDtos) {
    }

    protected void loadMetaAfterProcess() {
    }

    @ConstructorProperties(value={"config", "metaResourceReaderService", "authzService", "txService", "jpaDao", "widgetUtil", "viewAndViewWidgetUtil", "screenAndNavigationGroupAndNavigationViewUtil", "bcUtil"})
    @Generated
    public MetaHotReloadServiceImpl(MetaConfigurationProperties config, MetaResourceReaderService metaResourceReaderService, InternalAuthorizationService authzService, TransactionService txService, JpaDao jpaDao, WidgetUtil widgetUtil, ViewAndViewWidgetUtil viewAndViewWidgetUtil, ScreenAndNavigationGroupAndNavigationViewUtil screenAndNavigationGroupAndNavigationViewUtil, BcUtil bcUtil) {
        this.config = config;
        this.metaResourceReaderService = metaResourceReaderService;
        this.authzService = authzService;
        this.txService = txService;
        this.jpaDao = jpaDao;
        this.widgetUtil = widgetUtil;
        this.viewAndViewWidgetUtil = viewAndViewWidgetUtil;
        this.screenAndNavigationGroupAndNavigationViewUtil = screenAndNavigationGroupAndNavigationViewUtil;
        this.bcUtil = bcUtil;
    }
}

