/*
 * Decompiled with CFR 0.152.
 */
package org.cxbox.core.metahotreload.service;

import com.fasterxml.jackson.databind.ObjectMapper;
import java.beans.ConstructorProperties;
import java.io.BufferedReader;
import java.io.File;
import java.io.InputStreamReader;
import java.io.Reader;
import java.nio.charset.StandardCharsets;
import java.util.Arrays;
import java.util.List;
import java.util.stream.Collectors;
import lombok.Generated;
import lombok.NonNull;
import org.apache.commons.lang3.tuple.Pair;
import org.cxbox.core.metahotreload.conf.properties.MetaConfigurationProperties;
import org.cxbox.core.metahotreload.dto.BcSourceDTO;
import org.cxbox.core.metahotreload.dto.ScreenSourceDto;
import org.cxbox.core.metahotreload.dto.ViewSourceDTO;
import org.cxbox.core.metahotreload.dto.WidgetSourceDTO;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.context.ApplicationContext;
import org.springframework.core.io.Resource;

public class MetaResourceReaderService {
    final ApplicationContext applicationContext;
    final MetaConfigurationProperties config;
    @Qualifier(value="cxboxObjectMapper")
    final ObjectMapper objMapper;

    @NonNull
    public List<ScreenSourceDto> getScreens() {
        return this.readFilesToDto(ScreenSourceDto.class, this.config.getDirectory() + this.config.getScreenPath()).stream().map(Pair::getLeft).collect(Collectors.toList());
    }

    @NonNull
    public List<ViewSourceDTO> getViews() {
        return this.readFilesToDto(ViewSourceDTO.class, this.config.getDirectory() + this.config.getViewPath()).stream().map(Pair::getLeft).collect(Collectors.toList());
    }

    @NonNull
    public List<WidgetSourceDTO> getWidgets() {
        return this.readFilesToDto(WidgetSourceDTO.class, this.config.getDirectory() + this.config.getWidgetPath()).stream().map(Pair::getLeft).collect(Collectors.toList());
    }

    @NonNull
    public List<BcSourceDTO> getBcs() {
        List<Pair<BcSourceDTO, Resource>> pairs = this.readFilesToDto(BcSourceDTO.class, this.config.getDirectory() + this.config.getBcPath());
        pairs.forEach(pair -> {
            BcSourceDTO dto = (BcSourceDTO)pair.getLeft();
            Resource resource = (Resource)pair.getRight();
            String query = this.readRelativeResource(resource, new File(dto.getQueryFile()).getName()).lines().collect(Collectors.joining("\n"));
            dto.setQuery(query);
        });
        return pairs.stream().map(Pair::getLeft).collect(Collectors.toList());
    }

    @NonNull
    private <T> List<Pair<T, Resource>> readFilesToDto(@NonNull Class<T> clazz, @NonNull String locationPattern) {
        if (clazz == null) {
            throw new NullPointerException("clazz is marked non-null but is null");
        }
        if (locationPattern == null) {
            throw new NullPointerException("locationPattern is marked non-null but is null");
        }
        return Arrays.stream(this.applicationContext.getResources(locationPattern)).map(resource -> this.readDto((Resource)resource, clazz)).collect(Collectors.toList());
    }

    @NonNull
    private <T> Pair<T, Resource> readDto(@NonNull Resource resource, @NonNull Class<T> valueType) {
        if (resource == null) {
            throw new NullPointerException("resource is marked non-null but is null");
        }
        if (valueType == null) {
            throw new NullPointerException("valueType is marked non-null but is null");
        }
        return Pair.of((Object)this.objMapper.readValue((Reader)this.readResource(resource), valueType), (Object)resource);
    }

    @NonNull
    private BufferedReader readRelativeResource(@NonNull Resource resource, @NonNull String relativeFileName) {
        if (resource == null) {
            throw new NullPointerException("resource is marked non-null but is null");
        }
        if (relativeFileName == null) {
            throw new NullPointerException("relativeFileName is marked non-null but is null");
        }
        Resource relative = resource.createRelative(relativeFileName);
        return this.readResource(relative);
    }

    @NonNull
    private BufferedReader readResource(@NonNull Resource resource) {
        if (resource == null) {
            throw new NullPointerException("resource is marked non-null but is null");
        }
        return new BufferedReader(new InputStreamReader(resource.getInputStream(), StandardCharsets.UTF_8));
    }

    @ConstructorProperties(value={"applicationContext", "config", "objMapper"})
    @Generated
    public MetaResourceReaderService(ApplicationContext applicationContext, MetaConfigurationProperties config, @Qualifier(value="cxboxObjectMapper") ObjectMapper objMapper) {
        this.applicationContext = applicationContext;
        this.config = config;
        this.objMapper = objMapper;
    }
}

