/*
 * Decompiled with CFR 0.152.
 */
package org.cxbox.core.service;

import java.beans.ConstructorProperties;
import java.util.Collections;
import java.util.Map;
import java.util.Set;
import lombok.Generated;
import org.cxbox.api.data.dto.DataResponseDTO;
import org.cxbox.api.service.tx.TransactionService;
import org.cxbox.api.util.Invoker;
import org.cxbox.constgen.DtoField;
import org.cxbox.core.crudma.CrudmaActionHolder;
import org.cxbox.core.crudma.CrudmaActionType;
import org.cxbox.core.crudma.bc.BcIdentifier;
import org.cxbox.core.dto.mapper.DtoConstructorService;
import org.cxbox.core.ui.BcUtils;
import org.cxbox.model.core.api.EntitySerializationEvent;
import org.cxbox.model.core.entity.BaseEntity;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.context.ApplicationEvent;
import org.springframework.context.ApplicationEventPublisher;
import org.springframework.stereotype.Component;

@Component
public class DTOMapper {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(DTOMapper.class);
    private final ApplicationEventPublisher applicationEventPublisher;
    private final DtoConstructorService dtoConstructorService;
    private final TransactionService txService;
    private final BcUtils bcUtils;

    public <E extends BaseEntity, D extends DataResponseDTO> D entityToDto(BcIdentifier bc, E entity, Class<D> dtoClass, boolean flushRequired, Map<String, Object> attributes) {
        return this.entityToDto(entity, dtoClass, this.bcUtils.getDtoFieldsForCurrentScreen(bc), flushRequired, attributes);
    }

    public <E extends BaseEntity, D extends DataResponseDTO> D entityToDto(BcIdentifier bc, E entity, Class<D> dtoClass, boolean flushRequired) {
        return this.entityToDto(entity, dtoClass, this.bcUtils.getDtoFieldsForCurrentScreen(bc), flushRequired, Collections.emptyMap());
    }

    public <E extends BaseEntity, D extends DataResponseDTO> D entityToDto(BcIdentifier bc, E entity, Class<D> dtoClass) {
        return this.entityToDto(bc, entity, dtoClass, this.isFlushRequired(), Collections.emptyMap());
    }

    public <E extends BaseEntity, D extends DataResponseDTO> D entityToDto(BcIdentifier bc, E entity, Class<D> dtoClass, Map<String, Object> attributes) {
        return this.entityToDto(bc, entity, dtoClass, this.isFlushRequired(), attributes);
    }

    public <E extends BaseEntity, D extends DataResponseDTO> D entityToDto(E entity, Class<D> dtoClass) {
        return this.entityToDto(entity, dtoClass, this.bcUtils.getDtoFields(dtoClass), this.isFlushRequired(), Collections.emptyMap());
    }

    public <E extends BaseEntity, D extends DataResponseDTO> D entityToDto(E entity, Class<D> dtoClass, Set<DtoField<D, ?>> fields, boolean flushRequired) {
        return this.entityToDto(entity, dtoClass, fields, flushRequired, Collections.emptyMap());
    }

    public <E extends BaseEntity, D extends DataResponseDTO> D entityToDto(E entity, Class<D> dtoClass, DtoField<D, ?> field) {
        return this.entityToDto(entity, dtoClass, Collections.singleton(field));
    }

    public <E extends BaseEntity, D extends DataResponseDTO> D entityToDto(E entity, Class<D> dtoClass, Set<DtoField<D, ?>> fields) {
        return this.entityToDto(entity, dtoClass, fields, this.isFlushRequired());
    }

    private <E extends BaseEntity, D extends DataResponseDTO> D entityToDto(E entity, Class<D> dtoClass, Set<DtoField<D, ?>> fields, boolean flushRequired, Map<String, Object> attributes) {
        if (flushRequired) {
            this.sendSerializationEvent(entity);
        }
        D result = this.createDto(entity, dtoClass, fields, attributes);
        this.setVstamp(result, entity);
        return result;
    }

    private <E extends BaseEntity, D extends DataResponseDTO> D createDto(E entity, Class<D> dtoClass, Set<DtoField<D, ?>> dtoFields, Map<String, Object> attributes) {
        return this.dtoConstructorService.create(entity, dtoClass, dtoFields, attributes);
    }

    private void setVstamp(Object dto, BaseEntity entity) {
        if (!(dto instanceof DataResponseDTO)) {
            return;
        }
        DataResponseDTO responseDTO = (DataResponseDTO)dto;
        responseDTO.setVstamp(entity.getVstamp());
        this.txService.invokeAfterCompletion(Invoker.of(() -> responseDTO.setVstamp(entity.getVstamp())));
    }

    private void sendSerializationEvent(BaseEntity entity) {
        this.applicationEventPublisher.publishEvent((ApplicationEvent)new EntitySerializationEvent((Object)this, entity));
    }

    private boolean isFlushRequired() {
        CrudmaActionType action = CrudmaActionHolder.getActionType();
        return action != null && action.isFlushRequired();
    }

    @ConstructorProperties(value={"applicationEventPublisher", "dtoConstructorService", "txService", "bcUtils"})
    @Generated
    public DTOMapper(ApplicationEventPublisher applicationEventPublisher, DtoConstructorService dtoConstructorService, TransactionService txService, BcUtils bcUtils) {
        this.applicationEventPublisher = applicationEventPublisher;
        this.dtoConstructorService = dtoConstructorService;
        this.txService = txService;
        this.bcUtils = bcUtils;
    }
}

