/*
 * Decompiled with CFR 0.152.
 */
package org.cxbox.core.service.impl;

import java.beans.ConstructorProperties;
import java.io.Serializable;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import javax.persistence.criteria.Expression;
import javax.persistence.criteria.Predicate;
import lombok.Generated;
import org.apache.commons.lang3.StringUtils;
import org.cxbox.api.data.dictionary.LOV;
import org.cxbox.core.service.ResponsibilitiesService;
import org.cxbox.model.core.dao.JpaDao;
import org.cxbox.model.core.entity.Department;
import org.cxbox.model.core.entity.Responsibilities;
import org.cxbox.model.core.entity.Responsibilities_;
import org.cxbox.model.core.entity.User;
import org.springframework.data.jpa.domain.Specification;

public class ResponsibilitiesServiceImpl
implements ResponsibilitiesService {
    private final JpaDao jpaDao;

    private List<Responsibilities> getListByUserList(User user, LOV userRole, Responsibilities.ResponsibilityType responsibilityType) {
        return this.jpaDao.getList(Responsibilities.class, (Specification & Serializable)(root, cq, cb) -> cb.and(new Predicate[]{cb.equal((Expression)root.get(Responsibilities_.departmentId), (Object)user.getDepartment().getId()), cb.equal((Expression)root.get(Responsibilities_.internalRoleCD), (Object)userRole), cb.equal((Expression)root.get(Responsibilities_.responsibilityType), (Object)responsibilityType)}));
    }

    @Override
    public Map<String, Boolean> getListRespByUser(User user, LOV userRole) {
        return this.getListByUserList(user, userRole, Responsibilities.ResponsibilityType.VIEW).stream().collect(Collectors.toMap(Responsibilities::getView, Responsibilities::isReadOnly, (x1, x2) -> x2));
    }

    @Override
    public String getListScreensByUser(User user, LOV userRole) {
        return this.getListByUserList(user, userRole, Responsibilities.ResponsibilityType.SCREEN).stream().map(Responsibilities::getScreens).filter(StringUtils::isNotBlank).findFirst().orElse(null);
    }

    @Override
    public Set<String> getViewResponsibilities(Department department) {
        return new HashSet<String>(this.jpaDao.getList(Responsibilities.class, String.class, (root, cb) -> root.get(Responsibilities_.view), (Specification & Serializable)(root, cq, cb) -> cb.and((Expression)cb.equal((Expression)root.get(Responsibilities_.departmentId), (Object)department.getId()), (Expression)cb.equal((Expression)root.get(Responsibilities_.responsibilityType), (Object)Responsibilities.ResponsibilityType.VIEW))));
    }

    @ConstructorProperties(value={"jpaDao"})
    @Generated
    public ResponsibilitiesServiceImpl(JpaDao jpaDao) {
        this.jpaDao = jpaDao;
    }
}

