/*
 * Decompiled with CFR 0.152.
 */
package org.cxbox.core.service.impl;

import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.stream.Collectors;
import org.cxbox.core.crudma.bc.BcRegistry;
import org.cxbox.core.crudma.bc.impl.BcDescription;
import org.cxbox.core.dao.BaseDAO;
import org.cxbox.core.exception.EntityNotFoundException;
import org.cxbox.core.service.EntityUrlBuilder;
import org.cxbox.core.service.RouterService;
import org.cxbox.model.core.dao.util.JpaUtils;
import org.cxbox.model.core.entity.BaseEntity;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Transactional
@Service(value="entityRouterService")
public class RouterServiceImpl
implements RouterService {
    private final Map<Class, List<EntityUrlBuilder>> urlBuilders;
    @Autowired
    private BaseDAO baseDAO;
    @Autowired
    private BcRegistry bcRegistry;

    public RouterServiceImpl(Optional<List<EntityUrlBuilder>> builders) {
        this.urlBuilders = builders.map(list -> list.stream().collect(Collectors.groupingBy(EntityUrlBuilder::getEntityType))).orElse(Collections.emptyMap());
    }

    @Override
    public String getLocation(String type, Long id, String bcName) {
        BaseEntity entity = this.baseDAO.findById(type, id);
        if (entity == null) {
            throw new EntityNotFoundException(type, id);
        }
        Optional<BcDescription> bcDescription = Optional.ofNullable(bcName).map(this.bcRegistry::getBcDescription);
        return Optional.ofNullable(this.urlBuilders.get(JpaUtils.unproxiedClass((BaseEntity)entity))).map(list -> list.stream().map(builder -> builder.buildUrl(entity, bcDescription)).filter(Objects::nonNull).findFirst().orElse(null)).orElseThrow(UnsupportedOperationException::new);
    }
}

