/*
 * Decompiled with CFR 0.152.
 */
package org.cxbox.core.service.impl;

import com.fasterxml.jackson.databind.ObjectMapper;
import java.beans.ConstructorProperties;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import lombok.Generated;
import org.apache.commons.lang3.StringUtils;
import org.cxbox.api.data.dictionary.LOV;
import org.cxbox.core.dto.data.view.ScreenDTO;
import org.cxbox.core.dto.data.view.ScreenResponsibility;
import org.cxbox.core.service.ResponsibilitiesService;
import org.cxbox.core.service.ScreenResponsibilityService;
import org.cxbox.core.service.UIService;
import org.cxbox.core.service.ViewService;
import org.cxbox.model.core.entity.User;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service
@Transactional
public class ScreenResponsibilityServiceImpl
implements ScreenResponsibilityService {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(ScreenResponsibilityServiceImpl.class);
    @Qualifier(value="cxboxObjectMapper")
    private final ObjectMapper objectMapper;
    private final ResponsibilitiesService respService;
    private final UIService uiService;
    private final ViewService viewService;

    @Override
    public List<ScreenResponsibility> getScreens(User user, LOV userRole) {
        ArrayList<ScreenResponsibility> result = new ArrayList<ScreenResponsibility>();
        try {
            List<ScreenResponsibility> commonScreens;
            String screens = this.respService.getListScreensByUser(user, userRole);
            if (StringUtils.isNotBlank((CharSequence)screens)) {
                result.addAll((Collection)this.objectMapper.readValue(screens, ScreenResponsibility.LIST_TYPE_REFERENCE));
            }
            if ((commonScreens = this.uiService.getCommonScreens()) != null) {
                result.addAll(commonScreens);
            }
            result.forEach(resp -> {
                String screenName = resp.getName();
                ScreenDTO screenDto = this.viewService.getScreen(screenName);
                resp.setMeta(screenDto);
            });
            return result;
        }
        catch (IOException e) {
            log.error(e.getLocalizedMessage(), (Throwable)e);
            return result;
        }
    }

    @ConstructorProperties(value={"objectMapper", "respService", "uiService", "viewService"})
    @Generated
    public ScreenResponsibilityServiceImpl(@Qualifier(value="cxboxObjectMapper") ObjectMapper objectMapper, ResponsibilitiesService respService, UIService uiService, ViewService viewService) {
        this.objectMapper = objectMapper;
        this.respService = respService;
        this.uiService = uiService;
        this.viewService = viewService;
    }
}

