/*
 * Decompiled with CFR 0.152.
 */
package org.cxbox.core.service.impl;

import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import java.beans.ConstructorProperties;
import java.io.InputStream;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.function.Function;
import java.util.stream.Collectors;
import javax.annotation.PostConstruct;
import javax.persistence.criteria.Expression;
import javax.persistence.criteria.Order;
import javax.persistence.criteria.Predicate;
import lombok.Generated;
import org.cxbox.api.data.dictionary.CoreDictionaries;
import org.cxbox.api.data.dictionary.LOV;
import org.cxbox.api.service.tx.TransactionService;
import org.cxbox.api.util.Invoker;
import org.cxbox.core.dto.data.view.BusinessObjectDTO;
import org.cxbox.core.dto.data.view.ScreenNavigation;
import org.cxbox.core.dto.data.view.ScreenResponsibility;
import org.cxbox.core.service.ResponsibilitiesService;
import org.cxbox.core.service.UIService;
import org.cxbox.core.service.impl.UserRoleService;
import org.cxbox.model.core.dao.JpaDao;
import org.cxbox.model.core.entity.User;
import org.cxbox.model.ui.entity.BcProperties;
import org.cxbox.model.ui.entity.BcProperties_;
import org.cxbox.model.ui.entity.FilterGroup;
import org.cxbox.model.ui.entity.FilterGroup_;
import org.cxbox.model.ui.entity.Screen;
import org.cxbox.model.ui.entity.Screen_;
import org.cxbox.model.ui.entity.View;
import org.cxbox.model.ui.entity.ViewWidgets;
import org.cxbox.model.ui.entity.ViewWidgets_;
import org.cxbox.model.ui.entity.View_;
import org.cxbox.model.ui.navigation.NavigationGroup;
import org.cxbox.model.ui.navigation.NavigationGroup_;
import org.cxbox.model.ui.navigation.NavigationView;
import org.cxbox.model.ui.navigation.NavigationView_;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.cache.CacheManager;
import org.springframework.cache.annotation.CacheEvict;
import org.springframework.cache.annotation.Cacheable;
import org.springframework.data.jpa.domain.Specification;
import org.springframework.stereotype.Component;
import org.springframework.stereotype.Service;

@Service
public class UIServiceImpl
implements UIService {
    @Qualifier(value="cxboxObjectMapper")
    private final ObjectMapper objectMapper;
    private final ResponsibilitiesService responsibilitiesService;
    private final UserRoleService userRoleService;
    private final JpaDao jpaDao;
    private final UICache uiCache;
    private final CacheManager cacheManager;
    private final TransactionService txService;
    private JsonNode defaultUserSettings;
    private List<ScreenResponsibility> commonScreens;

    @PostConstruct
    protected void init() {
        InputStream screens;
        InputStream userSettings = this.getClass().getResourceAsStream("/userSettings.json");
        if (userSettings != null) {
            this.defaultUserSettings = this.objectMapper.readTree(userSettings);
        }
        this.commonScreens = (screens = this.getClass().getResourceAsStream("/commonScreens.json")) != null ? (List<Object>)this.objectMapper.readValue(screens, ScreenResponsibility.LIST_TYPE_REFERENCE) : new ArrayList<ScreenResponsibility>();
    }

    @Override
    public List<ScreenResponsibility> getCommonScreens() {
        return this.commonScreens;
    }

    @Override
    public boolean isCommonScreen(String screenName) {
        List<ScreenResponsibility> commonScreens = this.getCommonScreens();
        for (ScreenResponsibility screen : commonScreens) {
            if (!screenName.equals(screen.getName())) continue;
            return true;
        }
        return false;
    }

    @Override
    public JsonNode getUserSettings() {
        return this.defaultUserSettings;
    }

    @Override
    public Map<String, Boolean> getResponsibilities(User user, LOV userRole) {
        return this.responsibilitiesService.getListRespByUser(user, userRole);
    }

    @Override
    public String getFirstViewFromResponsibilities(User user, LOV userRole, String ... views) {
        Set<String> responsibilities = this.getResponsibilities(user, userRole).keySet();
        if (responsibilities.isEmpty() && views.length > 0) {
            return views[0];
        }
        for (String view : views) {
            if (!responsibilities.contains(view)) continue;
            return view;
        }
        return null;
    }

    @Override
    public String getFirstViewFromResponsibilities(User user, String ... views) {
        return this.getFirstViewFromResponsibilities(user, this.userRoleService.getMainUserRoleKey(user), views);
    }

    @Override
    public List<String> getViews(String screenName, User user, LOV userRole) {
        Set<String> responsibilities = this.getResponsibilities(user, userRole).keySet();
        boolean getAll = Objects.equals(userRole, CoreDictionaries.InternalRole.ADMIN) || this.isCommonScreen(screenName);
        return this.jpaDao.getList(NavigationView.class, (Specification & Serializable)(root, query, cb) -> cb.and(new Predicate[]{cb.equal((Expression)root.get(NavigationView_.screenName), (Object)screenName), cb.equal((Expression)root.get(NavigationView_.typeCd), (Object)CoreDictionaries.ViewGroupType.NAVIGATION), getAll ? cb.and(new Predicate[0]) : root.get(NavigationView_.viewName).in((Collection)responsibilities)})).stream().map(NavigationView::getViewName).distinct().collect(Collectors.toList());
    }

    @Override
    public Map<String, BcProperties> getStringDefaultBcPropertiesMap(BusinessObjectDTO boDto) {
        HashMap<String, BcProperties> result = new HashMap<String, BcProperties>(boDto.getBc().size());
        Map<String, BcProperties> allProperties = this.uiCache.getBcProperties();
        boDto.getBc().forEach(bc -> result.put(bc.getName(), (BcProperties)allProperties.get(bc.getName())));
        return result;
    }

    @Override
    public Map<String, List<FilterGroup>> getFilterGroups(BusinessObjectDTO boDto) {
        HashMap<String, List<FilterGroup>> result = new HashMap<String, List<FilterGroup>>(boDto.getBc().size());
        Map<String, List<FilterGroup>> all = this.uiCache.getFilterGroups();
        boDto.getBc().forEach(bc -> result.put(bc.getName(), (List)all.get(bc.getName())));
        return result;
    }

    @Override
    public Map<String, List<ViewWidgets>> getAllWidgetsWithPositionByScreen(List<String> views) {
        HashMap<String, List<ViewWidgets>> result = new HashMap<String, List<ViewWidgets>>(views.size());
        Map<String, List<ViewWidgets>> all = this.uiCache.getWidgets();
        views.forEach(view -> result.put((String)view, (List)all.get(view)));
        return result;
    }

    @Override
    public List<View> getViews(List<String> views) {
        ArrayList<View> result = new ArrayList<View>(views.size());
        Map<String, View> allViews = this.uiCache.getViews();
        views.forEach(view -> result.add((View)allViews.get(view)));
        return result;
    }

    @Override
    public ScreenNavigation getScreenNavigation(Screen screen) {
        return this.uiCache.getScreenNavigation(screen);
    }

    @Override
    public Screen findScreenByName(String name) {
        return (Screen)this.jpaDao.getSingleResultOrNull(Screen.class, (Specification & Serializable)(root, cq, cb) -> cb.equal((Expression)root.get(Screen_.name), (Object)name));
    }

    @Override
    public void invalidateCache() {
        this.txService.invokeAfterCompletion(Invoker.of(() -> this.cacheManager.getCache("widgetcache").clear()));
    }

    private static void sortMenuItemsBySeq(ScreenNavigation screenNavigation) {
        screenNavigation.getMenu().sort(Comparator.comparingInt(ScreenNavigation.MenuItem::getSeq));
        screenNavigation.getMenu().forEach(UIServiceImpl::recursiveSort);
    }

    private static void recursiveSort(ScreenNavigation.MenuItem m) {
        if (m instanceof ScreenNavigation.ViewGroup) {
            List<ScreenNavigation.MenuItem> child = ((ScreenNavigation.ViewGroup)m).getChild();
            child.sort(Comparator.comparingInt(ScreenNavigation.MenuItem::getSeq));
            child.forEach(UIServiceImpl::recursiveSort);
        }
    }

    @ConstructorProperties(value={"objectMapper", "responsibilitiesService", "userRoleService", "jpaDao", "uiCache", "cacheManager", "txService"})
    @Generated
    public UIServiceImpl(@Qualifier(value="cxboxObjectMapper") ObjectMapper objectMapper, ResponsibilitiesService responsibilitiesService, UserRoleService userRoleService, JpaDao jpaDao, UICache uiCache, CacheManager cacheManager, TransactionService txService) {
        this.objectMapper = objectMapper;
        this.responsibilitiesService = responsibilitiesService;
        this.userRoleService = userRoleService;
        this.jpaDao = jpaDao;
        this.uiCache = uiCache;
        this.cacheManager = cacheManager;
        this.txService = txService;
    }

    @Component
    public static class UICache {
        private final JpaDao jpaDao;

        @Cacheable(cacheResolver="cxboxCacheResolver", cacheNames={"widgetcache"}, key="{#root.methodName}")
        public Map<String, List<ViewWidgets>> getWidgets() {
            return this.jpaDao.getList(ViewWidgets.class, (Specification & Serializable)(root, cq, cb) -> {
                root.fetch(ViewWidgets_.widget);
                return cb.isNotNull((Expression)root.get(ViewWidgets_.viewName));
            }).stream().collect(Collectors.groupingBy(ViewWidgets::getViewName));
        }

        @Cacheable(cacheResolver="cxboxCacheResolver", cacheNames={"widgetcache"}, key="{#root.methodName}")
        public Map<String, View> getViews() {
            return this.jpaDao.getList(View.class, (Specification & Serializable)(root, cq, cb) -> cb.isNotNull((Expression)root.get(View_.name))).stream().collect(Collectors.toMap(View::getName, Function.identity()));
        }

        @Cacheable(cacheResolver="cxboxCacheResolver", cacheNames={"widgetcache"}, key="{#root.methodName}")
        public Map<String, BcProperties> getBcProperties() {
            return this.jpaDao.getList(BcProperties.class, (Specification & Serializable)(root, cq, cb) -> cb.isNotNull((Expression)root.get(BcProperties_.bc))).stream().collect(Collectors.toMap(BcProperties::getBc, Function.identity()));
        }

        @Cacheable(cacheResolver="cxboxCacheResolver", cacheNames={"widgetcache"}, key="{#root.methodName}")
        public Map<String, List<FilterGroup>> getFilterGroups() {
            return this.jpaDao.getList(FilterGroup.class, (Specification & Serializable)(root, cq, cb) -> cb.isNotNull((Expression)root.get(FilterGroup_.bc))).stream().collect(Collectors.groupingBy(FilterGroup::getBc));
        }

        @Cacheable(cacheResolver="cxboxCacheResolver", cacheNames={"widgetcache"}, key="{#root.methodName, #screen.name}")
        public ScreenNavigation getScreenNavigation(Screen screen) {
            List<ScreenNavigation.MenuItem> childList;
            ScreenNavigation.ViewGroup parentGroup;
            List groups = this.jpaDao.getList(NavigationGroup.class, (Specification & Serializable)(root, query, cb) -> {
                query.orderBy(new Order[]{cb.asc((Expression)root.get(NavigationGroup_.seq))});
                return cb.and((Expression)cb.equal((Expression)root.get(NavigationGroup_.screenName), (Object)screen.getName()), (Expression)cb.equal((Expression)root.get(NavigationGroup_.typeCd), (Object)CoreDictionaries.ViewGroupType.NAVIGATION));
            });
            List views = this.jpaDao.getList(NavigationView.class, (Specification & Serializable)(root, query, cb) -> {
                query.orderBy(new Order[]{cb.asc((Expression)root.get(NavigationView_.seq))});
                return cb.and((Expression)cb.equal((Expression)root.get(NavigationView_.screenName), (Object)screen.getName()), (Expression)cb.equal((Expression)root.get(NavigationView_.typeCd), (Object)CoreDictionaries.ViewGroupType.NAVIGATION));
            });
            ArrayList<ScreenNavigation.MenuItem> firstLevelMenu = new ArrayList<ScreenNavigation.MenuItem>();
            HashMap<String, ScreenNavigation.MenuItem> map = new HashMap<String, ScreenNavigation.MenuItem>();
            for (NavigationGroup navigationGroup : groups) {
                ScreenNavigation.ViewGroup viewGroup = (ScreenNavigation.ViewGroup)map.computeIfAbsent(navigationGroup.getId(), key -> new ScreenNavigation.ViewGroup());
                viewGroup.setId(navigationGroup.getId());
                viewGroup.setHidden(navigationGroup.getHidden());
                viewGroup.setTitle(navigationGroup.getTitle());
                viewGroup.setDefaultView(navigationGroup.getDefaultView());
                viewGroup.setSeq(navigationGroup.getSeq());
                if (navigationGroup.getParent() == null) {
                    firstLevelMenu.add(navigationGroup.getSeq() > firstLevelMenu.size() ? firstLevelMenu.size() : navigationGroup.getSeq().intValue(), viewGroup);
                    continue;
                }
                parentGroup = (ScreenNavigation.ViewGroup)map.computeIfAbsent(navigationGroup.getParent().getId(), key -> new ScreenNavigation.ViewGroup());
                if (parentGroup.getChild() == null) {
                    parentGroup.setChild(new ArrayList<ScreenNavigation.MenuItem>());
                }
                childList = parentGroup.getChild();
                childList.add(navigationGroup.getSeq() > childList.size() ? childList.size() : navigationGroup.getSeq() - 1, viewGroup);
            }
            for (NavigationView view : views) {
                ScreenNavigation.SingleView singleView = new ScreenNavigation.SingleView();
                singleView.setViewName(view.getViewName());
                singleView.setHidden(view.getHidden());
                singleView.setId(view.getId());
                singleView.setSeq(view.getSeq());
                if (view.getParentGroup() == null) {
                    firstLevelMenu.add(view.getSeq() > firstLevelMenu.size() ? firstLevelMenu.size() : view.getSeq().intValue(), singleView);
                    continue;
                }
                parentGroup = (ScreenNavigation.ViewGroup)map.get(view.getParentGroup().getId());
                if (parentGroup.getChild() == null) {
                    parentGroup.setChild(new ArrayList<ScreenNavigation.MenuItem>());
                }
                childList = parentGroup.getChild();
                childList.add(view.getSeq() > childList.size() ? childList.size() : view.getSeq() - 1, singleView);
            }
            ScreenNavigation screenNavigation = new ScreenNavigation();
            screenNavigation.setMenu(firstLevelMenu);
            UIServiceImpl.sortMenuItemsBySeq(screenNavigation);
            return screenNavigation;
        }

        @CacheEvict(cacheResolver="cxboxCacheResolver", cacheNames={"widgetcache"}, allEntries=true)
        public void evict() {
        }

        @ConstructorProperties(value={"jpaDao"})
        @Generated
        public UICache(JpaDao jpaDao) {
            this.jpaDao = jpaDao;
        }
    }
}

