/*
 * Decompiled with CFR 0.152.
 */
package org.cxbox.core.service.impl;

import java.beans.ConstructorProperties;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.stream.Collectors;
import javax.persistence.criteria.Expression;
import lombok.Generated;
import org.cxbox.api.data.dictionary.DictionaryCache;
import org.cxbox.api.data.dictionary.LOV;
import org.cxbox.api.data.dictionary.SimpleDictionary;
import org.cxbox.api.exception.ServerException;
import org.cxbox.model.core.dao.JpaDao;
import org.cxbox.model.core.entity.AbstractEntity;
import org.cxbox.model.core.entity.User;
import org.cxbox.model.core.entity.UserRole;
import org.cxbox.model.core.entity.UserRole_;
import org.springframework.data.jpa.domain.Specification;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service
@Transactional
public class UserRoleService {
    private final JpaDao jpaDao;
    private final DictionaryCache dictionaryCache;

    public LOV getMainUserRoleKey(User user) {
        List<UserRole> userRoleList = this.getListByUser(user);
        return userRoleList != null ? userRoleList.stream().filter(UserRole::getMain).map(UserRole::getInternalRoleCd).findFirst().orElse(userRoleList.stream().findFirst().map(UserRole::getInternalRoleCd).orElse(user.getInternalRole())) : user.getInternalRole();
    }

    public void upsertUserRoles(Long userId, List<String> intUserRoleKeyList) {
        User user = (User)this.jpaDao.findById(User.class, userId);
        List<UserRole> userRoleList = this.updateUserRoles(user, intUserRoleKeyList);
    }

    public String getMainUserRole(List<String> intUserRoleKeyList) {
        Map<String, Integer> roleKeyOrderMap = this.dictionaryCache.getAll("INTERNAL_ROLE").stream().collect(Collectors.toMap(SimpleDictionary::getKey, SimpleDictionary::getDisplayOrder));
        String mainUserRole = null;
        if (intUserRoleKeyList != null) {
            mainUserRole = intUserRoleKeyList.stream().filter(Objects::nonNull).filter(userRole -> !userRole.startsWith("OPT_")).filter(roleKeyOrderMap::containsKey).min(Comparator.comparingInt(roleKeyOrderMap::get)).orElse(null);
        }
        return mainUserRole;
    }

    public List<SimpleDictionary> getUserRoles(User user) {
        Map<String, String> dictRoleMap = this.dictionaryCache.getAll("INTERNAL_ROLE").stream().collect(Collectors.toMap(SimpleDictionary::getKey, SimpleDictionary::getValue));
        List<UserRole> userRoleList = this.getListByUser(user);
        if (userRoleList == null || userRoleList.isEmpty()) {
            throw new ServerException(String.format("User [id=%s] has no roles!", user.getId()));
        }
        return userRoleList.stream().filter(userRole -> userRole.getActive() != false && !userRole.getInternalRoleCd().getKey().contains("OPT_")).map(userRole -> {
            String key = userRole.getInternalRoleCd().getKey();
            String value = (String)dictRoleMap.get(key);
            return value != null ? new SimpleDictionary(key, value) : new SimpleDictionary(key, key);
        }).collect(Collectors.toList());
    }

    public void updateMainUserRole(User user, LOV mainUserRole) {
        user.setInternalRole(mainUserRole);
        List<UserRole> userRoleList = this.getListByUser(user);
        if (userRoleList != null && mainUserRole != null) {
            userRoleList.stream().filter(UserRole::getMain).findFirst().ifPresent(mur -> mur.setMain(Boolean.valueOf(false)));
            userRoleList.stream().filter(ur -> ur.getInternalRoleCd().getKey().equals(mainUserRole.getKey())).findFirst().ifPresent(ur -> ur.setMain(Boolean.valueOf(true)));
        }
    }

    public LOV getMatchedRole(User user, String roleName) {
        List<UserRole> userRoleList = this.getListByUser(user);
        if (userRoleList.stream().anyMatch(ur -> ur.getActive() != false && ur.getInternalRoleCd().getKey().equals(roleName))) {
            return new LOV(roleName);
        }
        return null;
    }

    private List<UserRole> updateUserRoles(User user, List<String> intUserRoleKeyList) {
        List<UserRole> userRoleList = this.getListByUser(user);
        ArrayList<UserRole> activeUserRoleList = new ArrayList<UserRole>();
        for (UserRole userRole2 : userRoleList) {
            if (intUserRoleKeyList.contains(userRole2.getInternalRoleCd().getKey())) {
                userRole2.setActive(Boolean.valueOf(true));
                activeUserRoleList.add(userRole2);
                continue;
            }
            userRole2.setActive(Boolean.valueOf(false));
            userRole2.setMain(Boolean.valueOf(false));
        }
        List userRoleKeyList = userRoleList.stream().map(userRole -> userRole.getInternalRoleCd().getKey()).collect(Collectors.toList());
        for (String userRoleKey : intUserRoleKeyList) {
            if (userRoleKeyList.contains(userRoleKey)) continue;
            activeUserRoleList.add(this.createUserRole(user, new LOV(userRoleKey)));
        }
        if (activeUserRoleList.stream().noneMatch(UserRole::getMain)) {
            String string = this.getMainUserRole(intUserRoleKeyList);
            activeUserRoleList.stream().filter(ur -> ur.getInternalRoleCd().getKey().equals(mainUserRole)).findFirst().ifPresent(userRole -> userRole.setMain(Boolean.valueOf(true)));
        }
        return activeUserRoleList;
    }

    private UserRole createUserRole(User user, LOV internalRoleCd) {
        this.jpaDao.lockAndRefresh((AbstractEntity)user, -1);
        UserRole userRole = (UserRole)this.jpaDao.getSingleResultOrNull(UserRole.class, (Specification & Serializable)(root, query, cb) -> cb.and((Expression)cb.equal((Expression)root.get(UserRole_.user), (Object)user), (Expression)cb.equal((Expression)root.get(UserRole_.internalRoleCd), (Object)internalRoleCd)));
        if (userRole == null) {
            userRole = new UserRole();
            userRole.setUser(user);
            userRole.setInternalRoleCd(internalRoleCd);
            userRole.setActive(Boolean.valueOf(true));
            userRole.setMain(Boolean.valueOf(false));
            this.jpaDao.save((Object)userRole);
        }
        return userRole;
    }

    private List<UserRole> getListByUser(User user) {
        return this.jpaDao.getList(UserRole.class, (Specification & Serializable)(root, query, cb) -> cb.equal((Expression)root.get(UserRole_.user), (Object)user));
    }

    @ConstructorProperties(value={"jpaDao", "dictionaryCache"})
    @Generated
    public UserRoleService(JpaDao jpaDao, DictionaryCache dictionaryCache) {
        this.jpaDao = jpaDao;
        this.dictionaryCache = dictionaryCache;
    }
}

