/*
 * Decompiled with CFR 0.152.
 */
package org.cxbox.core.service.impl;

import com.fasterxml.jackson.core.TreeNode;
import com.fasterxml.jackson.databind.JsonNode;
import java.beans.ConstructorProperties;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.stream.Collectors;
import javax.persistence.criteria.Expression;
import lombok.Generated;
import org.cxbox.api.util.i18n.ErrorMessageSource;
import org.cxbox.core.crudma.bc.BcRegistry;
import org.cxbox.core.crudma.bc.impl.BcDescription;
import org.cxbox.core.dao.impl.ViewDAO;
import org.cxbox.core.dto.data.view.BcSourceBaseDTO;
import org.cxbox.core.dto.data.view.BusinessComponentDTO;
import org.cxbox.core.dto.data.view.BusinessObjectDTO;
import org.cxbox.core.dto.data.view.ScreenBuildMeta;
import org.cxbox.core.dto.data.view.ScreenDTO;
import org.cxbox.core.dto.data.view.ViewDTO;
import org.cxbox.core.dto.data.view.WidgetDTO;
import org.cxbox.core.dto.rowmeta.FilterGroupDTO;
import org.cxbox.core.exception.ClientException;
import org.cxbox.core.service.ViewService;
import org.cxbox.core.service.impl.UIServiceImpl;
import org.cxbox.core.ui.model.json.WidgetOptions;
import org.cxbox.core.util.JsonUtils;
import org.cxbox.core.util.session.SessionService;
import org.cxbox.model.core.dao.JpaDao;
import org.cxbox.model.ui.entity.BcProperties;
import org.cxbox.model.ui.entity.FilterGroup;
import org.cxbox.model.ui.entity.Screen;
import org.cxbox.model.ui.entity.Screen_;
import org.cxbox.model.ui.entity.View;
import org.cxbox.model.ui.entity.ViewWidgets;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.data.jpa.domain.Specification;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service
@Transactional
public class ViewServiceImpl
implements ViewService {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(ViewServiceImpl.class);
    private final JpaDao jpaDao;
    private final ViewDAO viewDAO;
    private final BcRegistry bcRegistry;
    private final UIServiceImpl uiService;
    private final SessionService sessionService;

    private ViewDTO buildViewDTO(View view, Map<String, List<ViewWidgets>> allViewWidgets, Map<String, Boolean> responsibilities) {
        int widgetIdCounter = 0;
        List<Object> viewWidgetsList = allViewWidgets.get(view.getName());
        if (viewWidgetsList == null) {
            viewWidgetsList = Collections.emptyList();
        }
        ViewDTO result = new ViewDTO(view);
        result.setReadOnly(Optional.ofNullable(responsibilities.get(view.getName())).orElse(false));
        ArrayList<WidgetDTO> list = new ArrayList<WidgetDTO>();
        for (ViewWidgets viewWidgets : viewWidgetsList) {
            WidgetDTO widgetDTO = new WidgetDTO(viewWidgets, widgetIdCounter);
            widgetDTO.setUrl(this.bcRegistry.getUrlFromBc(viewWidgets.getWidget().getBc()));
            list.add(widgetDTO);
            ++widgetIdCounter;
        }
        result.setWidgets(list);
        return result;
    }

    @Override
    public ScreenDTO getScreen(String name) {
        Screen screen = (Screen)this.jpaDao.getSingleResultOrNull(Screen.class, (Specification & Serializable)(root, query, cb) -> cb.equal((Expression)root.get(Screen_.name), (Object)name));
        if (screen == null) {
            throw new ClientException(ErrorMessageSource.errorMessage((String)"error.screen_not_found", (Object[])new Object[]{name}));
        }
        List<String> views = this.sessionService.getViews(screen.getName());
        Map<String, Boolean> responsibilities = this.sessionService.getResponsibilities();
        return this.getScreen(screen, new ScreenBuildMeta(views, responsibilities));
    }

    private ScreenDTO getScreen(Screen screen, ScreenBuildMeta meta) {
        Map<String, List<ViewWidgets>> allViewWidgets = this.uiService.getAllWidgetsWithPositionByScreen(meta.getViews());
        List<View> views = this.uiService.getViews(meta.getViews());
        List<ViewDTO> viewDTOs = views.stream().map(view -> this.buildViewDTO((View)view, allViewWidgets, meta.getResponsibilities())).collect(Collectors.toList());
        ScreenDTO result = new ScreenDTO(screen);
        result.setNavigation(this.uiService.getScreenNavigation(screen));
        result.setViews(viewDTOs);
        result.setBo(this.getBusinessObject(viewDTOs));
        return result;
    }

    private BusinessObjectDTO getBusinessObject(List<ViewDTO> viewDTOs) {
        BusinessObjectDTO businessObjectDTO = new BusinessObjectDTO(viewDTOs.stream().map(ViewDTO::getWidgets).flatMap(Collection::stream).filter(widgetDTO -> Objects.nonNull(widgetDTO.getBcName())).map(this::getWidgetBc).flatMap(Collection::stream).peek(this::setBcId).distinct().sorted(Comparator.comparing(BusinessComponentDTO::getUrl)).collect(Collectors.toList()));
        this.setBcParameters(businessObjectDTO);
        this.setFilterGroups(businessObjectDTO);
        return businessObjectDTO;
    }

    private void setBcId(BusinessComponentDTO dto) {
        BcDescription description = this.bcRegistry.getBcDescription(dto.getName());
        if (description != null) {
            Optional.ofNullable(description.getId()).ifPresent(dto::setId);
        }
    }

    private void setBcParameters(BusinessObjectDTO boDto) {
        Map<String, BcProperties> defaultBcPropertiesMap = this.uiService.getStringDefaultBcPropertiesMap(boDto);
        boDto.getBc().forEach(dto -> {
            BcDescription bcDescription;
            BcProperties bcProperties = (BcProperties)defaultBcPropertiesMap.get(dto.getName());
            if (bcProperties != null) {
                Optional.ofNullable(bcProperties.getLimit()).ifPresent(dto::setLimit);
                Optional.ofNullable(bcProperties.getReportPeriod()).ifPresent(dto::setReportPeriod);
                Optional.ofNullable(bcProperties.getSort()).ifPresent(dto::setDefaultSort);
                Optional.ofNullable(bcProperties.getFilter()).ifPresent(dto::setDefaultFilter);
                Optional.ofNullable(bcProperties.getDimFilterSpec()).ifPresent(dto::setDimFilterSpec);
            }
            if ((bcDescription = this.bcRegistry.getBcDescription(dto.getName())) != null) {
                Optional.ofNullable(bcDescription.getParentName()).ifPresent(dto::setParentName);
                Optional.ofNullable(bcDescription.isRefresh()).ifPresent(dto::setRefresh);
                Optional.ofNullable(bcDescription.getBindsString()).ifPresent(dto::setBinds);
                Optional.ofNullable(bcDescription.getPageLimit()).ifPresent(dto::setLimit);
            }
        });
    }

    private void setFilterGroups(BusinessObjectDTO boDto) {
        Map<String, List<FilterGroup>> filterGroupMap = this.uiService.getFilterGroups(boDto);
        boDto.getBc().forEach(dto -> {
            List filterGroups = (List)filterGroupMap.get(dto.getName());
            if (filterGroups != null && !filterGroups.isEmpty()) {
                ArrayList<FilterGroupDTO> result = new ArrayList<FilterGroupDTO>();
                filterGroups.forEach(fg -> {
                    FilterGroupDTO filterGroupDTO = FilterGroupDTO.builder().entity((FilterGroup)fg).build();
                    result.add(filterGroupDTO);
                });
                dto.setFilterGroups(result);
            }
        });
    }

    private List<BusinessComponentDTO> getWidgetBc(WidgetDTO widgetDTO) {
        ArrayList<BusinessComponentDTO> result = new ArrayList<BusinessComponentDTO>();
        result.add(new BusinessComponentDTO(widgetDTO));
        Optional.ofNullable(widgetDTO.getOptions()).map(JsonUtils::readTree).filter(JsonNode::isObject).map(options -> JsonUtils.readValue(WidgetOptions.class, (TreeNode)options)).map(WidgetOptions::getHierarchy).ifPresent(list -> list.forEach(item -> {
            String bcName = item.getBcName();
            String url = this.bcRegistry.getUrlFromBc(bcName);
            result.add(new BusinessComponentDTO(new BcSourceBaseDTO(bcName, url)));
        }));
        return result;
    }

    @ConstructorProperties(value={"jpaDao", "viewDAO", "bcRegistry", "uiService", "sessionService"})
    @Generated
    public ViewServiceImpl(JpaDao jpaDao, ViewDAO viewDAO, BcRegistry bcRegistry, UIServiceImpl uiService, SessionService sessionService) {
        this.jpaDao = jpaDao;
        this.viewDAO = viewDAO;
        this.bcRegistry = bcRegistry;
        this.uiService = uiService;
        this.sessionService = sessionService;
    }
}

