/*
 * Decompiled with CFR 0.152.
 */
package org.cxbox.core.ui;

import com.google.common.cache.CacheBuilder;
import com.google.common.cache.CacheLoader;
import com.google.common.cache.LoadingCache;
import java.beans.ConstructorProperties;
import java.io.Serializable;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.concurrent.ExecutionException;
import java.util.stream.Collectors;
import javax.persistence.criteria.Expression;
import lombok.Generated;
import org.cxbox.api.data.dto.DataResponseDTO;
import org.cxbox.constgen.DtoField;
import org.cxbox.core.bc.InnerBcTypeAware;
import org.cxbox.core.crudma.bc.BcIdentifier;
import org.cxbox.core.crudma.bc.BcRegistry;
import org.cxbox.core.crudma.bc.impl.BcDescription;
import org.cxbox.core.crudma.bc.impl.InnerBcDescription;
import org.cxbox.core.dto.DTOUtils;
import org.cxbox.core.ui.WidgetUtils;
import org.cxbox.core.ui.field.IRequiredFieldsSupplier;
import org.cxbox.core.ui.model.BcField;
import org.cxbox.core.util.session.SessionService;
import org.cxbox.model.core.dao.JpaDao;
import org.cxbox.model.ui.entity.ViewWidgets;
import org.cxbox.model.ui.entity.ViewWidgets_;
import org.cxbox.model.ui.entity.Widget;
import org.cxbox.model.ui.entity.Widget_;
import org.springframework.cache.annotation.Cacheable;
import org.springframework.data.jpa.domain.Specification;
import org.springframework.stereotype.Service;

@Service
public class BcUtils {
    private final InnerBcTypeAware innerBcTypeAware;
    private final JpaDao jpaDao;
    private final BcRegistry bcRegistry;
    private final SessionService sessionService;
    private final Optional<List<IRequiredFieldsSupplier>> requiredFieldsSuppliers;
    private final LoadingCache<String, Set<BcField>> bcFields = CacheBuilder.newBuilder().build((CacheLoader)new BcFieldCacheLoader());
    private final LoadingCache<Long, Set<BcField>> widgetFields = CacheBuilder.newBuilder().build((CacheLoader)new WidgetFieldCacheLoader());
    private final LoadingCache<String, Map<String, Set<BcField>>> viewFields = CacheBuilder.newBuilder().build((CacheLoader)new ViewFieldCacheLoader());
    private final LoadingCache<Class<? extends DataResponseDTO>, Set<DtoField<DataResponseDTO, ?>>> dtoFieldsCache = CacheBuilder.newBuilder().build(new DtoFieldCacheLoader());

    public void invalidateFieldCache() {
        this.bcFields.invalidateAll();
        this.widgetFields.invalidateAll();
        this.viewFields.invalidateAll();
    }

    @Deprecated
    public void invalidateFieldCacheByView(String viewName) {
        this.viewFields.invalidate((Object)viewName);
    }

    @Deprecated
    public void invalidateFieldCacheByWidget(Long widgetId) {
        this.widgetFields.invalidate((Object)widgetId);
        this.jpaDao.getList(ViewWidgets.class, String.class, (root, cb) -> root.get(ViewWidgets_.viewName), (Specification & Serializable)(root, query, cb) -> {
            query.distinct(true);
            return cb.equal((Expression)root.get(ViewWidgets_.widget).get(Widget_.id), (Object)widgetId);
        }).forEach(this::invalidateFieldCacheByView);
    }

    @Deprecated
    public void invalidateFieldCacheByBc(String bc) {
        this.bcFields.invalidate((Object)bc);
        this.jpaDao.getList(Widget.class, Long.class, (root, cb) -> root.get(Widget_.id), (Specification & Serializable)(root, query, cb) -> cb.equal((Expression)root.get(Widget_.bc), (Object)bc)).forEach(this::invalidateFieldCacheByWidget);
    }

    public <D extends DataResponseDTO> Set<DtoField<D, ?>> getDtoFields(Class<D> dtoClass) {
        return (Set)this.dtoFieldsCache.get(dtoClass);
    }

    public <D extends DataResponseDTO> Set<DtoField<D, ?>> getDtoFields(BcIdentifier bcIdentifier) {
        BcDescription bcDescription = this.bcRegistry.getBcDescription(bcIdentifier.getName());
        if (bcDescription instanceof InnerBcDescription) {
            try {
                InnerBcDescription innerBcDescription = (InnerBcDescription)bcDescription;
                Class<? extends DataResponseDTO> dtoClass = this.innerBcTypeAware.getTypeOfDto(innerBcDescription);
                return (Set)this.dtoFieldsCache.get(dtoClass);
            }
            catch (ExecutionException e) {
                return Collections.emptySet();
            }
        }
        return Collections.emptySet();
    }

    @Cacheable(cacheResolver="cxboxCacheResolver", cacheNames={"requestCache"}, key="{#root.methodName, #bc.name}")
    public Set<String> getBcFieldsForCurrentScreen(BcIdentifier bc) {
        HashSet<String> viewFields = new HashSet<String>();
        for (String viewName : this.sessionService.getCurrentScreenViews()) {
            Set fields = ((Map)this.viewFields.get((Object)viewName)).getOrDefault(bc.getName(), Collections.emptySet());
            for (BcField field : fields) {
                viewFields.add(field.getName());
            }
        }
        return viewFields;
    }

    @Cacheable(cacheResolver="cxboxCacheResolver", cacheNames={"requestCache"}, key="{#root.methodName, #bc.name}")
    public <D extends DataResponseDTO> Set<DtoField<D, ?>> getDtoFieldsForCurrentScreen(BcIdentifier bc) {
        Set<String> viewFields = this.getBcFieldsForCurrentScreen(bc);
        return this.getDtoFields(bc).stream().filter(field -> viewFields.contains(field.getName())).map(field -> field).collect(Collectors.toSet());
    }

    @Cacheable(cacheResolver="cxboxCacheResolver", cacheNames={"requestCache"}, key="{#root.methodName, #bc.name, #dtoClass}")
    public <D extends DataResponseDTO> Set<DtoField<D, ?>> getDtoFieldsForCurrentScreen(BcIdentifier bc, Class<? extends DataResponseDTO> dtoClass) {
        Set<String> viewFields = this.getBcFieldsForCurrentScreen(bc);
        return this.getDtoFields(dtoClass).stream().filter(field -> viewFields.contains(field.getName())).map(field -> field).collect(Collectors.toSet());
    }

    @Deprecated
    public Set<String> getBcByDto(Class<? extends DataResponseDTO> dtoClass) {
        return this.bcRegistry.select(InnerBcDescription.class).filter(bcDescription -> Objects.equals(this.innerBcTypeAware.getTypeOfDto((InnerBcDescription)bcDescription), dtoClass)).map(BcDescription::getName).collect(Collectors.toSet());
    }

    @ConstructorProperties(value={"innerBcTypeAware", "jpaDao", "bcRegistry", "sessionService", "requiredFieldsSuppliers"})
    @Generated
    public BcUtils(InnerBcTypeAware innerBcTypeAware, JpaDao jpaDao, BcRegistry bcRegistry, SessionService sessionService, Optional<List<IRequiredFieldsSupplier>> requiredFieldsSuppliers) {
        this.innerBcTypeAware = innerBcTypeAware;
        this.jpaDao = jpaDao;
        this.bcRegistry = bcRegistry;
        this.sessionService = sessionService;
        this.requiredFieldsSuppliers = requiredFieldsSuppliers;
    }

    private final class ViewFieldCacheLoader
    extends CacheLoader<String, Map<String, Set<BcField>>> {
        private ViewFieldCacheLoader() {
        }

        public Map<String, Set<BcField>> load(String viewName) {
            List widgetIds = BcUtils.this.jpaDao.getList(ViewWidgets.class, Long.class, (root, cb) -> root.get(ViewWidgets_.widget).get(Widget_.id), (Specification & Serializable)(root, query, cb) -> cb.equal((Expression)root.get(ViewWidgets_.viewName), (Object)viewName));
            HashSet fields = new HashSet();
            for (Long widgetId : widgetIds) {
                fields.addAll((Collection)BcUtils.this.widgetFields.get((Object)widgetId));
            }
            return fields.stream().collect(Collectors.groupingBy(BcField::getBc, Collectors.toSet()));
        }
    }

    private final class WidgetFieldCacheLoader
    extends CacheLoader<Long, Set<BcField>> {
        private WidgetFieldCacheLoader() {
        }

        public Set<BcField> load(Long widgetId) {
            Widget widget = (Widget)BcUtils.this.jpaDao.findById(Widget.class, widgetId);
            HashSet<BcField> fields = new HashSet<BcField>(WidgetUtils.extractAllFields(widget));
            Set bcNames = fields.stream().map(BcField::getBc).filter(Objects::nonNull).collect(Collectors.toSet());
            for (String bcName : bcNames) {
                fields.addAll((Collection)BcUtils.this.bcFields.get((Object)bcName));
            }
            return fields;
        }
    }

    private final class BcFieldCacheLoader
    extends CacheLoader<String, Set<BcField>> {
        private BcFieldCacheLoader() {
        }

        public Set<BcField> load(String bc) {
            HashSet<BcField> fields = new HashSet<BcField>();
            BcUtils.this.requiredFieldsSuppliers.ifPresent(suppliers -> suppliers.forEach(supplier -> fields.addAll(supplier.getRequiredFields(bc))));
            return fields;
        }
    }

    private class DtoFieldCacheLoader<D extends DataResponseDTO>
    extends CacheLoader<Class<D>, Set<DtoField<D, ?>>> {
        private DtoFieldCacheLoader() {
        }

        public Set<DtoField<D, ?>> load(Class<D> dtoClass) {
            return DTOUtils.getAllFields(dtoClass);
        }
    }
}

