/*
 * Decompiled with CFR 0.152.
 */
package org.cxbox.core.ui;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.apache.commons.collections4.CollectionUtils;
import org.cxbox.api.util.ServiceUtils;
import org.cxbox.core.ui.field.FieldExtractor;
import org.cxbox.core.ui.model.BcField;
import org.cxbox.core.ui.model.ViewWidgetsGroup;
import org.cxbox.model.ui.entity.ViewWidgets;
import org.cxbox.model.ui.entity.Widget;

public final class WidgetUtils {
    private static final Map<String, FieldExtractor> FIELD_EXTRACTOR_MAP;

    public static Set<BcField> extractFields(Widget widget) {
        FieldExtractor fieldExtractor = FIELD_EXTRACTOR_MAP.get(widget.getType());
        if (fieldExtractor == null) {
            return Collections.emptySet();
        }
        return fieldExtractor.extract(widget);
    }

    public static Set<BcField> extractPickListFields(Widget widget) {
        return WidgetUtils.extractFields(widget).stream().map(field -> (Set)field.getAttribute(BcField.Attribute.PICK_LIST_FIELDS)).filter(CollectionUtils::isNotEmpty).flatMap(Collection::stream).collect(Collectors.toSet());
    }

    public static Set<BcField> extractShowConditionFields(Widget widget) {
        return FIELD_EXTRACTOR_MAP.get("ShowConditionFields").extract(widget);
    }

    public static Set<BcField> extractPivotFields(Widget widget) {
        return FIELD_EXTRACTOR_MAP.get("PivotFields").extract(widget);
    }

    public static Set<BcField> extractChartFields(Widget widget) {
        return FIELD_EXTRACTOR_MAP.get("ChartFields").extract(widget);
    }

    public static Set<BcField> extractHierarchyFields(Widget widget) {
        return FIELD_EXTRACTOR_MAP.get("HierarchyFields").extract(widget);
    }

    public static Set<BcField> extractAllFields(Widget widget) {
        HashSet<BcField> fields = new HashSet<BcField>(WidgetUtils.extractFields(widget));
        fields.addAll(WidgetUtils.extractShowConditionFields(widget));
        fields.addAll(WidgetUtils.extractPivotFields(widget));
        fields.addAll(WidgetUtils.extractChartFields(widget));
        fields.addAll(WidgetUtils.extractHierarchyFields(widget));
        fields.addAll(fields.stream().map(field -> (Set)field.getAttribute(BcField.Attribute.PICK_LIST_FIELDS)).filter(CollectionUtils::isNotEmpty).flatMap(Collection::stream).collect(Collectors.toSet()));
        return fields;
    }

    public static List<ViewWidgetsGroup> getViewWidgetsGroups(List<ViewWidgets> viewWidgetList) {
        HashMap<String, List> viewWidgets = new HashMap<String, List>();
        for (ViewWidgets viewWidget : viewWidgetList) {
            viewWidgets.computeIfAbsent(viewWidget.getViewName(), s -> new ArrayList()).add(viewWidget.getWidget());
        }
        return viewWidgets.entrySet().stream().map(entry -> new ViewWidgetsGroup((String)entry.getKey(), (List)entry.getValue())).collect(Collectors.toList());
    }

    static {
        HashMap extractors = new HashMap();
        ServiceUtils.loadServices(FieldExtractor.class, WidgetUtils.class).forEach(extractor -> extractor.getSupportedTypes().forEach(type -> extractors.compute(type, (key, current) -> Stream.of(current, extractor).filter(Objects::nonNull).min(Comparator.comparing(FieldExtractor::getPriority)).orElse((FieldExtractor)extractor))));
        FIELD_EXTRACTOR_MAP = Collections.unmodifiableMap(extractors);
    }
}

