/*
 * Decompiled with CFR 0.152.
 */
package org.cxbox.core.ui.field;

import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.naming.OperationNotSupportedException;
import lombok.Generated;
import org.cxbox.api.util.ServiceUtils;
import org.cxbox.core.ui.field.CustomFields;
import org.cxbox.core.ui.model.BcField;
import org.cxbox.core.ui.model.json.PivotMeta;
import org.cxbox.core.ui.model.json.field.FieldMeta;

public final class CustomFieldExtractor {
    public static Set<BcField> extract(Long widgetId, String bc, Object meta) {
        HashSet<BcField> fields = new HashSet<BcField>();
        CustomFields service = (CustomFields)ServiceUtils.getService(CustomFields.class, null);
        if (service == null) {
            return fields;
        }
        Map<Object, Object> custom = new HashMap();
        if (meta instanceof FieldMeta.FieldMetaBase) {
            custom = ((FieldMeta.FieldMetaBase)meta).getCustomFields();
        } else if (meta instanceof PivotMeta.TableColRow) {
            throw new OperationNotSupportedException("meta type PivotMeta is not supported");
        }
        List<String> fieldNames = service.getFieldNames();
        for (Map.Entry<Object, Object> entry : custom.entrySet()) {
            if (!fieldNames.contains(entry.getKey())) {
                throw new IllegalArgumentException("Not found field with key:" + (String)entry.getKey());
            }
            fields.add(new BcField(bc, (String)entry.getValue()).putAttribute(BcField.Attribute.WIDGET_ID, widgetId));
        }
        return fields;
    }

    @Generated
    private CustomFieldExtractor() {
        throw new UnsupportedOperationException("This is a utility class and cannot be instantiated");
    }
}

