/*
 * Decompiled with CFR 0.152.
 */
package org.cxbox.core.ui.field;

import com.fasterxml.jackson.core.TreeNode;
import com.fasterxml.jackson.databind.JsonNode;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Optional;
import java.util.Set;
import org.cxbox.core.ui.field.FieldExtractor;
import org.cxbox.core.ui.field.link.LinkFieldExtractor;
import org.cxbox.core.ui.model.BcField;
import org.cxbox.core.ui.model.json.WidgetOptions;
import org.cxbox.core.util.JsonUtils;
import org.cxbox.model.ui.entity.Widget;

public class HierarchyFieldExtractor
implements FieldExtractor {
    @Override
    public Set<BcField> extract(Widget widget) {
        HashSet<BcField> fields = new HashSet<BcField>();
        Optional.ofNullable(widget.getOptions()).map(JsonUtils::readTree).filter(JsonNode::isObject).map(options -> JsonUtils.readValue(WidgetOptions.class, (TreeNode)options)).map(WidgetOptions::getHierarchy).ifPresent(list -> list.forEach(item -> {
            if (item.getAssocValueKey() != null) {
                fields.add(new BcField(item.getBcName(), item.getAssocValueKey()).putAttribute(BcField.Attribute.WIDGET_ID, widget.getId()));
            }
            item.getFields().forEach(field -> {
                fields.add(new BcField(item.getBcName(), field.getKey()).putAttribute(BcField.Attribute.WIDGET_ID, widget.getId()));
                fields.addAll(LinkFieldExtractor.extract(widget.getId(), item.getBcName(), field));
            });
        }));
        return fields;
    }

    @Override
    public List<String> getSupportedTypes() {
        ArrayList<String> result = new ArrayList<String>();
        result.add("HierarchyFields");
        return result;
    }
}

