/*
 * Decompiled with CFR 0.152.
 */
package org.cxbox.core.ui.field;

import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.cxbox.core.ui.field.FieldExtractor;
import org.cxbox.core.ui.field.link.LinkFieldExtractor;
import org.cxbox.core.ui.model.BcField;
import org.cxbox.core.ui.model.json.PivotMeta;
import org.cxbox.core.ui.model.json.field.FieldMeta;
import org.cxbox.core.util.JsonUtils;
import org.cxbox.model.ui.entity.Widget;

public final class PivotFieldExtractor
implements FieldExtractor {
    @Override
    public Set<BcField> extract(Widget widget) {
        HashSet<BcField> fields = new HashSet<BcField>();
        if (widget.getPivotFields() != null) {
            PivotMeta pivotMeta = JsonUtils.readValue(PivotMeta.class, widget.getPivotFields());
            pivotMeta.getRows().forEach(row -> fields.addAll(this.extract(widget, (PivotMeta.TableColRow)row)));
            pivotMeta.getCols().forEach(col -> fields.addAll(this.extract(widget, (PivotMeta.TableColRow)col)));
            pivotMeta.getValues().forEach(value -> fields.addAll(this.extract(widget, (PivotMeta.TableValue)value)));
        }
        return fields;
    }

    private Set<BcField> extract(Widget widget, PivotMeta.TableColRow tableColRow) {
        Set<BcField> fields = LinkFieldExtractor.extract(widget, tableColRow);
        if (tableColRow.getChildren() != null) {
            tableColRow.getChildren().forEach(child -> fields.addAll(this.extract(widget, (PivotMeta.TableColRow)child)));
        }
        return fields;
    }

    private Set<BcField> extract(Widget widget, PivotMeta.TableValue tableValue) {
        FieldMeta fieldMeta = tableValue.getField();
        HashSet<BcField> fields = new HashSet<BcField>(LinkFieldExtractor.extract(widget, fieldMeta));
        fields.add(new BcField(widget.getBc(), fieldMeta.getKey()).putAttribute(BcField.Attribute.WIDGET_ID, widget.getId()));
        return fields;
    }

    @Override
    public List<String> getSupportedTypes() {
        ArrayList<String> result = new ArrayList<String>();
        result.add("PivotFields");
        return result;
    }
}

