/*
 * Decompiled with CFR 0.152.
 */
package org.cxbox.core.ui.field;

import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import org.cxbox.core.ui.field.FieldExtractor;
import org.cxbox.core.ui.model.BcField;
import org.cxbox.core.ui.model.json.Condition;
import org.cxbox.core.util.JsonUtils;
import org.cxbox.model.ui.entity.Widget;

public final class ShowConditionFieldExtractor
implements FieldExtractor {
    @Override
    public Set<BcField> extract(Widget widget) {
        HashSet<BcField> fields = new HashSet<BcField>();
        if (!Objects.equals(widget.getShowCondition(), "[]")) {
            Condition condition = JsonUtils.readValue(Condition.class, widget.getShowCondition());
            if (condition.getParams() != null) {
                fields.add(this.getField(widget, condition, condition.getParams()));
            }
            if (condition.getMultipleParams() != null) {
                for (Condition.IConditionFieldEqualityParams multipleParam : condition.getMultipleParams()) {
                    fields.add(this.getField(widget, condition, multipleParam));
                }
            }
        }
        return fields;
    }

    private BcField getField(Widget widget, Condition condition, Condition.IConditionFieldEqualityParams params) {
        String bc = condition.getBcName() == null ? widget.getBc() : condition.getBcName();
        return new BcField(bc, params.getFieldKey()).putAttribute(BcField.Attribute.WIDGET_ID, widget.getId());
    }

    @Override
    public List<String> getSupportedTypes() {
        ArrayList<String> result = new ArrayList<String>();
        result.add("ShowConditionFields");
        return result;
    }
}

