/*
 * Decompiled with CFR 0.152.
 */
package org.cxbox.core.util;

import java.sql.SQLException;
import lombok.Generated;

public final class SQLExceptions {
    public static boolean isUniqueConstraintViolation(Throwable ex) {
        return SQLExceptions.isOra(ex, 1);
    }

    public static boolean isNotNullViolation(Throwable ex) {
        return SQLExceptions.isOra(ex, 1400);
    }

    public static boolean isChildRecordsFound(Throwable ex) {
        return SQLExceptions.isOra(ex, 2292);
    }

    public static boolean isParentRecordNotFound(Throwable ex) {
        return SQLExceptions.isOra(ex, 2291);
    }

    public static boolean isOra(Throwable ex, int code) {
        if (ex == null) {
            return false;
        }
        if (ex instanceof SQLException && SQLExceptions.hasErrorCode((SQLException)ex, code)) {
            return true;
        }
        return SQLExceptions.isOra(ex.getCause(), code);
    }

    public static boolean hasErrorCode(SQLException ex, int code) {
        if (ex == null) {
            return false;
        }
        if (ex.getErrorCode() == code) {
            return true;
        }
        return SQLExceptions.isOra(ex.getNextException(), code);
    }

    @Generated
    private SQLExceptions() {
        throw new UnsupportedOperationException("This is a utility class and cannot be instantiated");
    }
}

