/*
 * Decompiled with CFR 0.152.
 */
package org.cxbox.core.util;

import com.google.common.collect.ImmutableMap;
import java.math.BigDecimal;
import java.sql.Timestamp;
import java.time.LocalDateTime;
import java.util.Map;
import java.util.function.Function;
import lombok.Generated;
import org.cxbox.api.exception.ServerException;
import org.cxbox.core.util.DateTimeUtil;

public final class TypeConverter {
    private static final Map<Class<?>, Function<String, Object>> VALUE_MAPPERS = ImmutableMap.builder().put(String.class, TypeConverter::toString).put(Boolean.class, TypeConverter::toBoolean).put(Boolean.TYPE, TypeConverter::toBoolean).put(Integer.class, TypeConverter::toInteger).put(Integer.TYPE, TypeConverter::toInteger).put(Long.class, TypeConverter::toLong).put(Long.TYPE, TypeConverter::toLong).put(Double.class, TypeConverter::toDouble).put(Double.TYPE, TypeConverter::toDouble).put(Float.class, TypeConverter::toFloat).put(BigDecimal.class, TypeConverter::toBigDecimal).put(Byte.class, TypeConverter::toByte).put(Short.class, TypeConverter::toShort).put(LocalDateTime.class, TypeConverter::toLocalDateTime).put(Timestamp.class, TypeConverter::toSqlTimestamp).build();

    public static String toString(String stringValue) {
        return stringValue;
    }

    public static Integer toInteger(String stringValue) {
        return Integer.valueOf(stringValue);
    }

    public static Long toLong(String stringValue) {
        return Long.valueOf(stringValue);
    }

    public static Double toDouble(String stringValue) {
        return Double.valueOf(stringValue);
    }

    public static Float toFloat(String stringValue) {
        return Float.valueOf(stringValue);
    }

    public static BigDecimal toBigDecimal(String stringValue) {
        return new BigDecimal(stringValue);
    }

    public static Byte toByte(String stringValue) {
        return Byte.valueOf(stringValue);
    }

    public static Short toShort(String stringValue) {
        return Short.valueOf(stringValue);
    }

    public static Boolean toBoolean(String stringValue) {
        return Boolean.valueOf(stringValue);
    }

    public static LocalDateTime toLocalDateTime(String stringValue) {
        return DateTimeUtil.stringToDateTime(stringValue);
    }

    public static LocalDateTime toLocalDateTimeTzAware(String stringValue) {
        return TypeConverter.toLocalDateTime(stringValue).with(DateTimeUtil.fromSession());
    }

    public static Timestamp toSqlTimestamp(String stringValue) {
        return Timestamp.valueOf(TypeConverter.toLocalDateTime(stringValue));
    }

    public static Timestamp toSqlTimestampTzAware(String stringValue) {
        return Timestamp.valueOf(TypeConverter.toLocalDateTimeTzAware(stringValue));
    }

    public static <T> T to(Class<T> clazz, String stringValue) {
        return (T)VALUE_MAPPERS.getOrDefault(clazz, parameter -> {
            throw new ServerException(String.format("\u041d\u0435\u0432\u043e\u0437\u043c\u043e\u0436\u043d\u043e \u043f\u0440\u0435\u043e\u0431\u0440\u0430\u0437\u043e\u0432\u0430\u0442\u044c \u0437\u043d\u0430\u0447\u0435\u043d\u0438\u0435 \"%s\" \u043a \u043a\u043b\u0430\u0441\u0441\u0443 %s", stringValue, clazz));
        }).apply(stringValue);
    }

    @Generated
    private TypeConverter() {
        throw new UnsupportedOperationException("This is a utility class and cannot be instantiated");
    }
}

