/*
 * Decompiled with CFR 0.152.
 */
package org.cxbox.core.util.session.impl;

import java.beans.ConstructorProperties;
import java.util.Collections;
import lombok.Generated;
import org.cxbox.api.data.dictionary.LOV;
import org.cxbox.api.service.session.CxboxAuthenticationService;
import org.cxbox.api.service.session.CxboxUserDetails;
import org.cxbox.api.service.session.CxboxUserDetailsInterface;
import org.cxbox.core.service.impl.UserRoleService;
import org.cxbox.core.util.session.UserService;
import org.cxbox.model.core.entity.User;
import org.springframework.security.core.userdetails.UserDetails;
import org.springframework.security.core.userdetails.UsernameNotFoundException;
import org.springframework.stereotype.Service;

@Service
public class CxboxAuthenticationServiceImpl
implements CxboxAuthenticationService {
    private final UserService userService;
    private final UserRoleService userRoleService;

    public UserDetails loadUserByUsername(String username) throws UsernameNotFoundException {
        return this.loadUserByUsername(username, null);
    }

    public UserDetails loadUserByUsername(String username, LOV userRole) throws UsernameNotFoundException {
        User user = this.userService.getUserByLogin(username);
        if (user == null) {
            throw new UsernameNotFoundException(username);
        }
        return this.createUserDetails(user, userRole == null ? this.userRoleService.getMainUserRoleKey(user) : userRole);
    }

    private CxboxUserDetailsInterface createUserDetails(User user, LOV userRole) {
        return CxboxUserDetails.builder().id(user.getId()).username(user.getLogin()).password(user.getPassword()).userRole(userRole).timezone(user.getTimezone()).localeCd(user.getLocale()).authorities(Collections.emptySet()).build();
    }

    @ConstructorProperties(value={"userService", "userRoleService"})
    @Generated
    public CxboxAuthenticationServiceImpl(UserService userService, UserRoleService userRoleService) {
        this.userService = userService;
        this.userRoleService = userRoleService;
    }
}

