/*
 * Decompiled with CFR 0.152.
 */
package org.cxbox.core.util.session.impl;

import java.beans.ConstructorProperties;
import java.util.Iterator;
import java.util.List;
import java.util.Optional;
import lombok.Generated;
import org.cxbox.api.service.session.CoreSessionService;
import org.cxbox.api.service.session.CxboxUserDetailsInterface;
import org.cxbox.api.service.session.InternalAuthorizationService;
import org.cxbox.core.util.session.SessionUser;
import org.cxbox.core.util.session.UserExternalService;
import org.cxbox.core.util.session.UserService;
import org.cxbox.model.core.api.EffectiveUserAware;
import org.cxbox.model.core.dao.JpaDao;
import org.cxbox.model.core.entity.User;
import org.springframework.security.web.authentication.session.SessionAuthenticationException;
import org.springframework.stereotype.Service;

@Service
public class EffectiveUserAwareImpl
implements EffectiveUserAware<User> {
    private final Optional<List<UserExternalService>> userExternalServices;
    private final UserService userService;
    private final JpaDao jpaDao;
    private final CoreSessionService coreSessionService;

    private User getSessionUserInternal(boolean fallbackToSystem) {
        CxboxUserDetailsInterface details = this.coreSessionService.getSessionUserDetails(false);
        if (details != null) {
            return this.getUserFromDetails(details);
        }
        SessionUser sessionUser = null;
        if (this.userExternalServices.isPresent()) {
            UserExternalService userExternalService;
            Iterator<UserExternalService> iterator = this.userExternalServices.get().iterator();
            while (iterator.hasNext() && (sessionUser = (userExternalService = iterator.next()).getSessionUser()) == null) {
            }
        }
        if (sessionUser == null) {
            throw new SessionAuthenticationException("Not authorized");
        }
        User user = this.userService.getUserByLogin(sessionUser.getId());
        if (user == null && fallbackToSystem) {
            user = new User();
            user.setId(InternalAuthorizationService.VANILLA.getId());
        }
        return user;
    }

    public User getEffectiveSessionUser() {
        return this.getSessionUserInternal(true);
    }

    private User getUserFromDetails(CxboxUserDetailsInterface userDetails) {
        return (User)this.jpaDao.findById(User.class, userDetails.getId());
    }

    @ConstructorProperties(value={"userExternalServices", "userService", "jpaDao", "coreSessionService"})
    @Generated
    public EffectiveUserAwareImpl(Optional<List<UserExternalService>> userExternalServices, UserService userService, JpaDao jpaDao, CoreSessionService coreSessionService) {
        this.userExternalServices = userExternalServices;
        this.userService = userService;
        this.jpaDao = jpaDao;
        this.coreSessionService = coreSessionService;
    }
}

