/*
 * Decompiled with CFR 0.152.
 */
package org.cxbox.core.util.session.impl;

import java.beans.ConstructorProperties;
import java.util.Collection;
import java.util.List;
import java.util.stream.Collectors;
import lombok.Generated;
import org.cxbox.api.data.dictionary.CoreDictionaries;
import org.cxbox.api.data.dictionary.LOV;
import org.cxbox.api.data.dictionary.SimpleDictionary;
import org.cxbox.api.system.SystemSettings;
import org.cxbox.core.dto.LoggedUser;
import org.cxbox.core.dto.data.view.ScreenResponsibility;
import org.cxbox.core.metahotreload.conf.properties.MetaConfigurationProperties;
import org.cxbox.core.service.ScreenResponsibilityService;
import org.cxbox.core.service.UIService;
import org.cxbox.core.service.impl.UserRoleService;
import org.cxbox.core.util.session.LoginService;
import org.cxbox.core.util.session.SessionService;
import org.cxbox.model.core.entity.User;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.context.i18n.LocaleContextHolder;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service
@Transactional
public class LoginServiceImpl
implements LoginService {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(LoginServiceImpl.class);
    private final SessionService sessionService;
    private final UserRoleService userRoleService;
    private final SystemSettings systemSettings;
    private final UIService uiService;
    private final ScreenResponsibilityService screenResponsibilityService;
    private final MetaConfigurationProperties metaConfigurationProperties;

    @Override
    public LoggedUser getLoggedUser(String role) {
        this.sessionService.setSessionUserInternalRole(role);
        User user = this.sessionService.getSessionUser();
        LOV activeUserRole = this.sessionService.getSessionUserRole();
        return LoggedUser.builder().sessionId(this.sessionService.getSessionId()).user(user).activeRole(activeUserRole.getKey()).roles(this.userRoleService.getUserRoles(user)).screens(this.getScreens(user, activeUserRole)).userSettings(this.uiService.getUserSettings()).featureSettings(this.getFeatureSettings()).systemUrl(this.systemSettings.getValue(CoreDictionaries.SystemPref.SYSTEM_URL)).language(LocaleContextHolder.getLocale().getLanguage()).timezone(LocaleContextHolder.getTimeZone().getID()).devPanelEnabled(this.metaConfigurationProperties.isDevPanelEnabled()).build();
    }

    @Deprecated
    private List<ScreenResponsibility> getScreens(User user, LOV userRole) {
        return this.screenResponsibilityService.getScreens(user, userRole);
    }

    public Collection<SimpleDictionary> getFeatureSettings() {
        return this.systemSettings.select(key -> key.startsWith("FEATURE_")).map(p -> new SimpleDictionary((String)p.getKey(), (String)p.getValue())).collect(Collectors.toList());
    }

    @ConstructorProperties(value={"sessionService", "userRoleService", "systemSettings", "uiService", "screenResponsibilityService", "metaConfigurationProperties"})
    @Generated
    public LoginServiceImpl(SessionService sessionService, UserRoleService userRoleService, SystemSettings systemSettings, UIService uiService, ScreenResponsibilityService screenResponsibilityService, MetaConfigurationProperties metaConfigurationProperties) {
        this.sessionService = sessionService;
        this.userRoleService = userRoleService;
        this.systemSettings = systemSettings;
        this.uiService = uiService;
        this.screenResponsibilityService = screenResponsibilityService;
        this.metaConfigurationProperties = metaConfigurationProperties;
    }
}

