/*
 * Decompiled with CFR 0.152.
 */
package org.cxbox.core.util.session.impl;

import java.beans.ConstructorProperties;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import javax.servlet.http.HttpServletRequest;
import lombok.Generated;
import org.apache.commons.lang3.StringUtils;
import org.cxbox.api.data.dictionary.LOV;
import org.cxbox.api.service.session.CoreSessionService;
import org.cxbox.api.service.session.CxboxUserDetailsInterface;
import org.cxbox.core.controller.BcHierarchyAware;
import org.cxbox.core.service.UIService;
import org.cxbox.core.service.impl.UserRoleService;
import org.cxbox.core.util.session.SessionService;
import org.cxbox.core.util.session.UserExternalService;
import org.cxbox.core.util.session.UserService;
import org.cxbox.core.util.session.WebHelper;
import org.cxbox.model.core.dao.JpaDao;
import org.cxbox.model.core.entity.Department;
import org.cxbox.model.core.entity.Division;
import org.cxbox.model.core.entity.User;
import org.cxbox.model.core.entity.UserRole;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.cache.annotation.Cacheable;
import org.springframework.security.web.authentication.session.SessionAuthenticationException;
import org.springframework.stereotype.Component;
import org.springframework.stereotype.Service;
import org.springframework.web.context.request.RequestContextHolder;
import org.springframework.web.context.request.ServletRequestAttributes;

@Service(value="sessionService")
public class SessionServiceImpl
implements SessionService {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(SessionServiceImpl.class);
    private final UIService uiService;
    private final Optional<List<UserExternalService>> userExternalServices;
    private final UserService userService;
    private final UserRoleService userRoleService;
    private final JpaDao jpaDao;
    private final CoreSessionService coreSessionService;
    private final BcHierarchyAware bcHierarchyAware;
    private final UserCache userCache;

    @Override
    @Cacheable(cacheResolver="cxboxCacheResolver", cacheNames={"requestCache"}, key="#root.methodName")
    public User getSessionUser() {
        User user = this.getUserFromDetails(this.coreSessionService.getSessionUserDetails(true));
        if (user == null) {
            throw new SessionAuthenticationException("Not authorized");
        }
        return user;
    }

    @Override
    public Department getSessionUserDepartment() {
        return this.getSessionUser().getDepartment();
    }

    @Override
    @Cacheable(cacheResolver="cxboxCacheResolver", cacheNames={"requestCache"}, key="#root.methodName")
    public LOV getSessionUserRole() {
        CxboxUserDetailsInterface userDetails = this.coreSessionService.getSessionUserDetails(true);
        HttpServletRequest request = WebHelper.getCurrentRequest().orElse(null);
        if (request == null) {
            return userDetails.getUserRole();
        }
        return this.calculateUserRole(request, userDetails);
    }

    private LOV calculateUserRole(HttpServletRequest request, CxboxUserDetailsInterface userDetails) {
        LOV mainRole = userDetails.getUserRole();
        String requestedRole = request.getHeader("RequestedUserRole");
        if (StringUtils.isBlank((CharSequence)requestedRole)) {
            return mainRole;
        }
        if (mainRole != null && requestedRole.equals(mainRole.getKey())) {
            return mainRole;
        }
        LOV currentRole = this.userRoleService.getMatchedRole(this.getUserFromDetails(userDetails), requestedRole);
        if (currentRole == null) {
            currentRole = userDetails.getUserRole();
        }
        return currentRole;
    }

    @Override
    public void setSessionUserTimezone(LOV timezone) {
        CxboxUserDetailsInterface userDetails = this.coreSessionService.getSessionUserDetails(true);
        if (timezone == null || userDetails == null) {
            return;
        }
        userDetails.setTimezone(timezone);
    }

    @Override
    public void setSessionUserLocale(LOV locale) {
        CxboxUserDetailsInterface userDetails = this.coreSessionService.getSessionUserDetails(true);
        if (locale == null || userDetails == null) {
            return;
        }
        userDetails.setLocaleCd(locale);
    }

    @Override
    public void setSessionUserInternalRole(String role) {
        CxboxUserDetailsInterface userDetails = this.coreSessionService.getSessionUserDetails(true);
        if (role == null || role.isEmpty() || userDetails == null) {
            return;
        }
        User user = this.getUserFromDetails(userDetails);
        LOV matchedRole = this.userRoleService.getMatchedRole(user, role);
        if (matchedRole == null) {
            return;
        }
        userDetails.setUserRole(matchedRole);
        this.userRoleService.updateMainUserRole(user, matchedRole);
    }

    @Override
    public String getSessionIpAddress() {
        String forwardedFor = "X-Forwarded-For";
        ServletRequestAttributes attrs = (ServletRequestAttributes)RequestContextHolder.currentRequestAttributes();
        try {
            if (attrs.getRequest().getHeader(forwardedFor) == null || attrs.getRequest().getHeader(forwardedFor).trim().length() == 0) {
                return attrs.getRequest().getRemoteAddr();
            }
            return attrs.getRequest().getHeader(forwardedFor);
        }
        catch (Exception e) {
            log.warn("Cannot get user ip", (Throwable)e);
            return "";
        }
    }

    @Override
    public Map<String, Boolean> getResponsibilities() {
        return this.userCache.getResponsibilities(this.getSessionUser(), this.getSessionUserRole());
    }

    @Override
    public String getFirstViewFromResponsibilities(String ... views) {
        return this.uiService.getFirstViewFromResponsibilities(this.getSessionUser(), this.getSessionUserRole(), views);
    }

    private User getUserFromDetails(CxboxUserDetailsInterface userDetails) {
        return (User)this.jpaDao.findById(User.class, userDetails.getId());
    }

    @Override
    public String getSessionId() {
        return this.coreSessionService.getSessionId();
    }

    @Override
    public Division getSessionUserDivision(LOV levelCd) {
        return this.getSessionUserRoles().stream().filter(userRole -> Objects.equals(this.getSessionUserRole(), userRole.getInternalRoleCd())).findFirst().map(UserRole::getDivision).map(division -> division.getParentByLevelCode(levelCd)).orElse(null);
    }

    @Override
    public Division getSessionUserDivision() {
        return this.getSessionUserRoles().stream().filter(userRole -> Objects.equals(this.getSessionUserRole(), userRole.getInternalRoleCd())).findFirst().map(UserRole::getDivision).orElse(null);
    }

    @Override
    public List<UserRole> getSessionUserRoles() {
        return this.getSessionUser().getUserRoleList();
    }

    @Override
    public Collection<String> getCurrentScreenViews() {
        return this.getViews(this.bcHierarchyAware.getScreenName());
    }

    @Override
    public List<String> getViews(String screenName) {
        return this.userCache.getViews(screenName, this.getSessionUser(), this.getSessionUserRole());
    }

    @ConstructorProperties(value={"uiService", "userExternalServices", "userService", "userRoleService", "jpaDao", "coreSessionService", "bcHierarchyAware", "userCache"})
    @Generated
    public SessionServiceImpl(UIService uiService, Optional<List<UserExternalService>> userExternalServices, UserService userService, UserRoleService userRoleService, JpaDao jpaDao, CoreSessionService coreSessionService, BcHierarchyAware bcHierarchyAware, UserCache userCache) {
        this.uiService = uiService;
        this.userExternalServices = userExternalServices;
        this.userService = userService;
        this.userRoleService = userRoleService;
        this.jpaDao = jpaDao;
        this.coreSessionService = coreSessionService;
        this.bcHierarchyAware = bcHierarchyAware;
        this.userCache = userCache;
    }

    @Component
    public static class UserCache {
        private final UIService uiService;

        @Cacheable(cacheResolver="cxboxCacheResolver", cacheNames={"userCache"}, key="{#root.methodName, #user.id, #userRole}")
        public Map<String, Boolean> getResponsibilities(User user, LOV userRole) {
            return this.uiService.getResponsibilities(user, userRole);
        }

        @Cacheable(cacheResolver="cxboxCacheResolver", cacheNames={"userCache"}, key="{#root.methodName, #screenName, #user.id, #userRole}")
        public List<String> getViews(String screenName, User user, LOV userRole) {
            return this.uiService.getViews(screenName, user, userRole);
        }

        @ConstructorProperties(value={"uiService"})
        @Generated
        public UserCache(UIService uiService) {
            this.uiService = uiService;
        }
    }
}

