/*
 * Decompiled with CFR 0.152.
 */
package org.cxbox.core.util.session.impl;

import java.beans.ConstructorProperties;
import java.io.Serializable;
import java.util.List;
import java.util.Objects;
import java.util.stream.Stream;
import javax.persistence.criteria.Expression;
import javax.persistence.criteria.Predicate;
import lombok.Generated;
import org.cxbox.api.data.PageSpecification;
import org.cxbox.api.data.ResultPage;
import org.cxbox.core.controller.UserController;
import org.cxbox.core.util.session.UserService;
import org.cxbox.model.core.dao.JpaDao;
import org.cxbox.model.core.entity.User;
import org.cxbox.model.core.entity.User_;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.data.jpa.domain.Specification;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service
@Transactional
public class UserServiceImpl
implements UserService {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(UserServiceImpl.class);
    private final JpaDao jpaDao;

    @Override
    public ResultPage<UserController.UserDto> getByMention(String mention, PageSpecification page) {
        ResultPage users = this.jpaDao.getPage(User.class, (Specification & Serializable)(root, cq, cb) -> {
            Predicate[] searchTokens = (Predicate[])Stream.of(mention.split(" ")).filter(Objects::nonNull).map(String::toLowerCase).map(item -> cb.or((Expression)cb.like(cb.lower((Expression)root.get(User_.fullUserName)), "%" + item + "%"), (Expression)cb.like(cb.lower((Expression)root.get(User_.email)), "%" + item + "%"))).toArray(Predicate[]::new);
            return cb.or(searchTokens);
        }, page);
        return ResultPage.of((ResultPage)users, this::entityToDto);
    }

    private UserController.UserDto entityToDto(User user) {
        UserController.UserDto dto = new UserController.UserDto();
        dto.setId(user.getId().toString());
        dto.setFio(user.getFullName());
        dto.setEmail(user.getEmail());
        dto.setPhone(user.getPhone());
        dto.setFirstName(user.getFirstName());
        dto.setLastName(user.getLastName());
        dto.setPatronymic(user.getPatronymic());
        dto.setLogin(user.getLogin());
        return dto;
    }

    @Override
    public User getUserByLogin(String login) {
        List user = this.jpaDao.getList(User.class, (Specification & Serializable)(root, cq, cb) -> cb.equal(cb.upper((Expression)root.get(User_.login)), (Object)login.toUpperCase()));
        return !user.isEmpty() ? (User)user.listIterator().next() : null;
    }

    @ConstructorProperties(value={"jpaDao"})
    @Generated
    public UserServiceImpl(JpaDao jpaDao) {
        this.jpaDao = jpaDao;
    }
}

